/*
 * Decompiled with CFR 0.152.
 */
package com.byteplus.service.livesaas.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.parser.Feature;
import com.byteplus.error.SdkError;
import com.byteplus.helper.Utils;
import com.byteplus.model.ServiceInfo;
import com.byteplus.model.livesaas.CreateActivityAPIV2Request;
import com.byteplus.model.livesaas.CreateActivityAPIV2Response;
import com.byteplus.model.livesaas.GetSDKTokenAPIRequest;
import com.byteplus.model.livesaas.GetSDKTokenAPIResponse;
import com.byteplus.model.livesaas.GetTemporaryLoginTokenAPIRequest;
import com.byteplus.model.livesaas.GetTemporaryLoginTokenAPIResponse;
import com.byteplus.model.livesaas.ListActivityAPIRequest;
import com.byteplus.model.livesaas.ListActivityAPIResponse;
import com.byteplus.model.livesaas.UpdateActivityBasicConfigAPIRequest;
import com.byteplus.model.livesaas.UpdateActivityBasicConfigAPIResponse;
import com.byteplus.model.response.RawResponse;
import com.byteplus.model.response.ResponseMetadata;
import com.byteplus.service.BaseServiceImpl;
import com.byteplus.service.live.LiveConfig;
import com.byteplus.service.livesaas.LiveSaaSConfig;
import com.byteplus.service.livesaas.LiveSaaSService;
import java.util.ArrayList;
import org.apache.http.HttpHost;
import org.apache.http.NameValuePair;

public class LiveSaaSServiceImpl
extends BaseServiceImpl
implements LiveSaaSService {
    private LiveSaaSServiceImpl() {
        super(LiveSaaSConfig.serviceInfoMap.get("ap-singapore-1"), LiveSaaSConfig.apiInfoList);
    }

    private LiveSaaSServiceImpl(HttpHost proxy) {
        super(LiveSaaSConfig.serviceInfoMap.get("ap-singapore-1"), LiveSaaSConfig.apiInfoList);
    }

    private LiveSaaSServiceImpl(ServiceInfo serviceInfo) {
        super(serviceInfo, LiveSaaSConfig.apiInfoList);
    }

    public static LiveSaaSService getInstance() {
        return new LiveSaaSServiceImpl();
    }

    public static LiveSaaSService getInstance(HttpHost proxy) {
        return new LiveSaaSServiceImpl(proxy);
    }

    public static LiveSaaSService getInstance(String region) throws Exception {
        ServiceInfo serviceInfo = LiveConfig.serviceInfoMap.get(region);
        if (serviceInfo == null) {
            throw new Exception("Live not support region " + region);
        }
        return new LiveSaaSServiceImpl(serviceInfo);
    }

    @Override
    public CreateActivityAPIV2Response CreateActivityAPIV2(CreateActivityAPIV2Request request) throws Exception {
        RawResponse response = this.json("CreateActivityAPIV2", new ArrayList<NameValuePair>(), JSON.toJSONString((Object)request));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        CreateActivityAPIV2Response res = (CreateActivityAPIV2Response)JSON.parseObject((byte[])response.getData(), CreateActivityAPIV2Response.class, (Feature[])new Feature[0]);
        if (res.getResponseMetadata().getError() != null) {
            ResponseMetadata meta = res.getResponseMetadata();
            throw new Exception(meta.getRequestId() + "error: " + meta.getError().getMessage() + JSON.toJSONString((Object)res));
        }
        res.getResponseMetadata().setService("livesaas");
        return res;
    }

    @Override
    public ListActivityAPIResponse ListActivityAPI(ListActivityAPIRequest request) throws Exception {
        RawResponse response = this.json("ListActivityAPI", new ArrayList<NameValuePair>(), JSON.toJSONString((Object)request));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        ListActivityAPIResponse res = (ListActivityAPIResponse)JSON.parseObject((byte[])response.getData(), ListActivityAPIResponse.class, (Feature[])new Feature[0]);
        if (res.getResponseMetadata().getError() != null) {
            ResponseMetadata meta = res.getResponseMetadata();
            throw new Exception(meta.getRequestId() + "error: " + meta.getError().getMessage() + JSON.toJSONString((Object)res));
        }
        res.getResponseMetadata().setService("livesaas");
        return res;
    }

    @Override
    public UpdateActivityBasicConfigAPIResponse UpdateActivityBasicConfigAPI(UpdateActivityBasicConfigAPIRequest request) throws Exception {
        RawResponse response = this.json("UpdateActivityBasicConfigAPI", new ArrayList<NameValuePair>(), JSON.toJSONString((Object)request));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        UpdateActivityBasicConfigAPIResponse res = (UpdateActivityBasicConfigAPIResponse)JSON.parseObject((byte[])response.getData(), UpdateActivityBasicConfigAPIResponse.class, (Feature[])new Feature[0]);
        if (res.getResponseMetadata().getError() != null) {
            ResponseMetadata meta = res.getResponseMetadata();
            throw new Exception(meta.getRequestId() + "error: " + meta.getError().getMessage() + JSON.toJSONString((Object)res));
        }
        res.getResponseMetadata().setService("livesaas");
        return res;
    }

    @Override
    public GetTemporaryLoginTokenAPIResponse GetTemporaryLoginTokenAPI(GetTemporaryLoginTokenAPIRequest request) throws Exception {
        RawResponse response = this.query("GetTemporaryLoginTokenAPI", Utils.mapToPairList(Utils.paramsToMap(request)));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        GetTemporaryLoginTokenAPIResponse res = (GetTemporaryLoginTokenAPIResponse)JSON.parseObject((byte[])response.getData(), GetTemporaryLoginTokenAPIResponse.class, (Feature[])new Feature[0]);
        if (res.getResponseMetadata().getError() != null) {
            ResponseMetadata meta = res.getResponseMetadata();
            throw new Exception(meta.getRequestId() + "error: " + meta.getError().getMessage() + JSON.toJSONString((Object)res));
        }
        res.getResponseMetadata().setService("livesaas");
        return res;
    }

    @Override
    public GetSDKTokenAPIResponse GetSDKTokenAPI(GetSDKTokenAPIRequest request) throws Exception {
        RawResponse response = this.json("GetSDKTokenAPI", new ArrayList<NameValuePair>(), JSON.toJSONString((Object)request));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        GetSDKTokenAPIResponse res = (GetSDKTokenAPIResponse)JSON.parseObject((byte[])response.getData(), GetSDKTokenAPIResponse.class, (Feature[])new Feature[0]);
        if (res.getResponseMetadata().getError() != null) {
            ResponseMetadata meta = res.getResponseMetadata();
            throw new Exception(meta.getRequestId() + "error: " + meta.getError().getMessage() + JSON.toJSONString((Object)res));
        }
        res.getResponseMetadata().setService("livesaas");
        return res;
    }
}

