/*
 * Decompiled with CFR 0.152.
 */
package com.contentstack.sdk;

import com.contentstack.sdk.Entry;
import com.contentstack.sdk.Query;
import com.contentstack.sdk.Stack;
import java.util.LinkedHashMap;
import java.util.Map;

public class ContentType {
    protected String contentTypeName = null;
    protected Stack stackInstance = null;
    private LinkedHashMap<String, Object> localHeader = null;
    private LinkedHashMap<String, Object> stackHeader = null;

    private ContentType() {
    }

    protected ContentType(String contentTypeName) {
        this.contentTypeName = contentTypeName;
        this.localHeader = new LinkedHashMap();
    }

    protected void setStackInstance(Stack stack) {
        this.stackInstance = stack;
        this.stackHeader = stack.localHeader;
    }

    public void setHeader(String key, String value) {
        if (!key.isEmpty() && !value.isEmpty()) {
            this.localHeader.put(key, value);
        }
    }

    public void removeHeader(String key) {
        if (!key.isEmpty()) {
            this.localHeader.remove(key);
        }
    }

    public Entry entry(String entryUid) {
        Entry entry = new Entry(this.contentTypeName);
        entry.formHeader = this.getHeader(this.localHeader);
        entry.setContentTypeInstance(this);
        entry.setUid(entryUid);
        return entry;
    }

    protected Entry entry() {
        Entry entry = new Entry(this.contentTypeName);
        entry.formHeader = this.getHeader(this.localHeader);
        entry.setContentTypeInstance(this);
        return entry;
    }

    public Query query() {
        Query query = new Query(this.contentTypeName);
        query.formHeader = this.getHeader(this.localHeader);
        query.setContentTypeInstance(this);
        return query;
    }

    private LinkedHashMap<String, Object> getHeader(LinkedHashMap<String, Object> localHeader) {
        LinkedHashMap<String, Object> mainHeader = this.stackHeader;
        LinkedHashMap<String, Object> classHeaders = new LinkedHashMap<String, Object>();
        if (localHeader != null && localHeader.size() > 0) {
            if (mainHeader != null && mainHeader.size() > 0) {
                String key;
                for (Map.Entry<String, Object> entry : localHeader.entrySet()) {
                    key = entry.getKey();
                    classHeaders.put(key, entry.getValue());
                }
                for (Map.Entry<String, Object> entry : mainHeader.entrySet()) {
                    key = entry.getKey();
                    if (classHeaders.containsKey(key)) continue;
                    classHeaders.put(key, entry.getValue());
                }
                return classHeaders;
            }
            return localHeader;
        }
        return this.stackHeader;
    }
}

