/*
 * Decompiled with CFR 0.152.
 */
package com.contentstack.sdk;

import com.contentstack.sdk.APIService;
import com.contentstack.sdk.Asset;
import com.contentstack.sdk.AssetLibrary;
import com.contentstack.sdk.AssetModel;
import com.contentstack.sdk.AssetsModel;
import com.contentstack.sdk.CSHttpConnection;
import com.contentstack.sdk.Config;
import com.contentstack.sdk.ContentType;
import com.contentstack.sdk.ContentTypesCallback;
import com.contentstack.sdk.ContentTypesModel;
import com.contentstack.sdk.EntriesModel;
import com.contentstack.sdk.Entry;
import com.contentstack.sdk.EntryModel;
import com.contentstack.sdk.EntryResultCallBack;
import com.contentstack.sdk.Error;
import com.contentstack.sdk.FetchResultCallback;
import com.contentstack.sdk.INotifyClass;
import com.contentstack.sdk.IRequestModelHTTP;
import com.contentstack.sdk.Query;
import com.contentstack.sdk.ResponseType;
import com.contentstack.sdk.ResultCallBack;
import com.contentstack.sdk.Stack;
import com.contentstack.sdk.SyncResultCallBack;
import com.contentstack.sdk.SyncStack;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import org.json.JSONObject;

class CSConnectionRequest
implements IRequestModelHTTP {
    protected String endpoint;
    private String urlToCall;
    private String controller;
    private String requestInfo;
    private LinkedHashMap<String, Object> header;
    private HashMap<String, Object> urlQueries;
    private ResultCallBack resultCallBack;
    private INotifyClass notifyClass;
    private AssetLibrary assetLibrary;
    private APIService service;
    private Config config;
    private Entry entryInstance;
    private Asset assetInstance;
    private Stack stackInstance;

    public CSConnectionRequest(Query queryInstance) {
        this.notifyClass = queryInstance;
        this.endpoint = queryInstance.contentTypeInstance.stackInstance.config.getEndpoint();
    }

    public CSConnectionRequest(Entry entryInstance) {
        this.entryInstance = entryInstance;
        this.endpoint = this.entryInstance.contentType.stackInstance.config.getEndpoint();
    }

    public CSConnectionRequest(AssetLibrary assetLibrary) {
        this.assetLibrary = assetLibrary;
        this.endpoint = this.assetLibrary.stackInstance.config.getEndpoint();
    }

    public CSConnectionRequest(Asset asset) {
        this.assetInstance = asset;
        this.endpoint = this.assetInstance.stackInstance.config.getEndpoint();
    }

    public CSConnectionRequest(Stack stack) {
        this.stackInstance = stack;
    }

    public CSConnectionRequest(ContentType contentType) {
        this.endpoint = contentType.stackInstance.config.getEndpoint();
    }

    public void setQueryInstance(Query queryInstance) {
        this.endpoint = queryInstance.contentTypeInstance.stackInstance.config.getEndpoint();
    }

    public void setURLQueries(HashMap<String, Object> urlQueries) {
        this.urlQueries = urlQueries;
    }

    public void setStackInstance(Stack stackInstance) {
        this.endpoint = this.stackInstance.config.getEndpoint();
        this.stackInstance = stackInstance;
    }

    public void setParams(Object ... objects) {
        this.urlToCall = (String)objects[0];
        this.header = (LinkedHashMap)objects[1];
        this.controller = (String)objects[2];
        this.requestInfo = (String)objects[3];
        if (objects[4] != null) {
            this.resultCallBack = (ResultCallBack)objects[4];
        }
        this.service = (APIService)objects[5];
        if (objects.length > 6) {
            this.stackInstance = (Stack)objects[6];
            this.config = this.stackInstance.config;
        }
        this.sendRequest();
    }

    @Override
    public void sendRequest() {
        CSHttpConnection connection = new CSHttpConnection(this.urlToCall, this);
        connection.setController(this.controller);
        connection.setHeaders(this.header);
        connection.setInfo(this.requestInfo);
        connection.setAPIService(this.service);
        connection.setConfig(this.config);
        connection.setStack(this.stackInstance);
        connection.setCallBackObject(this.resultCallBack);
        if (this.urlQueries != null && this.urlQueries.size() > 0) {
            connection.setFormParams(this.urlQueries);
        }
        connection.send();
    }

    @Override
    public void onRequestFailed(JSONObject error, int statusCode, ResultCallBack callBackObject) {
        Error errResp = new Error();
        if (error.has("error_message")) {
            String errMsg = error.optString("error_message");
            errResp.setErrorMessage(errMsg);
        }
        if (error.has("error_code")) {
            int errCode = error.optInt("error_code");
            errResp.setErrorCode(errCode);
        }
        if (error.has("errors")) {
            String errorDetail = (String)error.opt("errors");
            errResp.setErrorDetail(errorDetail);
        }
        if (this.resultCallBack != null) {
            this.resultCallBack.onRequestFail(ResponseType.NETWORK, errResp);
        }
    }

    @Override
    public void onRequestFinished(CSHttpConnection request) {
        JSONObject jsonResponse = request.getResponse();
        if (request.getController().equalsIgnoreCase("getQueryEntries")) {
            EntriesModel model = new EntriesModel(jsonResponse);
            this.notifyClass.getResultObject(model.objectList, jsonResponse, false);
        } else if (request.getController().equalsIgnoreCase("getSingleQueryEntries")) {
            EntriesModel model = new EntriesModel(jsonResponse);
            this.notifyClass.getResultObject(model.objectList, jsonResponse, true);
        } else if (request.getController().equalsIgnoreCase("getEntry")) {
            EntryModel model = new EntryModel(jsonResponse);
            this.entryInstance.resultJson = model.jsonObject;
            this.entryInstance.title = model.title;
            this.entryInstance.url = model.url;
            this.entryInstance.language = model.language;
            this.entryInstance.uid = model.uid;
            this.entryInstance.setTags(model.tags);
            if (request.getCallBackObject() != null) {
                ((EntryResultCallBack)request.getCallBackObject()).onRequestFinish(ResponseType.NETWORK);
            }
        } else if (request.getController().equalsIgnoreCase("getAllAssets")) {
            AssetsModel assetsModel = new AssetsModel(jsonResponse);
            List<Object> objectList = assetsModel.objects;
            this.assetLibrary.getResultObject(objectList, jsonResponse, false);
        } else if (request.getController().equalsIgnoreCase("getAssets")) {
            AssetModel model = new AssetModel(jsonResponse, false);
            this.assetInstance.contentType = model.contentType;
            this.assetInstance.fileSize = model.fileSize;
            this.assetInstance.uploadUrl = model.uploadUrl;
            this.assetInstance.fileName = model.fileName;
            this.assetInstance.json = model.json;
            this.assetInstance.assetUid = model.uploadedUid;
            this.assetInstance.setTags(model.tags);
            if (request.getCallBackObject() != null) {
                ((FetchResultCallback)request.getCallBackObject()).onRequestFinish(ResponseType.NETWORK);
            }
        } else if (request.getController().equalsIgnoreCase("getSync")) {
            SyncStack model = new SyncStack();
            model.setJSON(jsonResponse);
            if (request.getCallBackObject() != null) {
                ((SyncResultCallBack)request.getCallBackObject()).onRequestFinish(model);
            }
        } else if (request.getController().equalsIgnoreCase("getContentTypes")) {
            ContentTypesModel model = new ContentTypesModel();
            model.setJSON(jsonResponse);
            if (request.getCallBackObject() != null) {
                ((ContentTypesCallback)request.getCallBackObject()).onRequestFinish(model);
            }
        }
    }
}

