/*
 * Decompiled with CFR 0.152.
 */
package com.contentstack.sdk;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.jetbrains.annotations.NotNull;
import org.json.JSONArray;
import org.json.JSONObject;

public class SyncStack {
    private static final Logger logger = Logger.getLogger(SyncStack.class.getName());
    private JSONObject receiveJson;
    private int skip;
    private int limit;
    private int count;
    private String url;
    private String paginationToken;
    private String syncToken;
    private ArrayList<JSONObject> syncItems;

    public String getUrl() {
        return this.url;
    }

    public JSONObject getJSONResponse() {
        return this.receiveJson;
    }

    public int getCount() {
        return this.count;
    }

    public int getLimit() {
        return this.limit;
    }

    public int getSkip() {
        return this.skip;
    }

    public String getPaginationToken() {
        return this.paginationToken;
    }

    public String getSyncToken() {
        return this.syncToken;
    }

    public List<JSONObject> getItems() {
        return this.syncItems;
    }

    protected synchronized void setJSON(@NotNull JSONObject jsonobject) {
        if (jsonobject == null) {
            throw new IllegalArgumentException("JSON object cannot be null.");
        }
        this.receiveJson = jsonobject;
        if (this.receiveJson.has("items")) {
            Object itemsObj = this.receiveJson.opt("items");
            if (itemsObj instanceof JSONArray) {
                JSONArray jsonArray = (JSONArray)itemsObj;
                this.syncItems = new ArrayList();
                for (int i = 0; i < jsonArray.length(); ++i) {
                    JSONObject jsonItem = jsonArray.optJSONObject(i);
                    if (jsonItem == null) continue;
                    this.syncItems.add(this.sanitizeJson(jsonItem));
                }
            } else if (itemsObj instanceof JSONObject) {
                this.syncItems = new ArrayList();
                this.syncItems.add(this.sanitizeJson((JSONObject)itemsObj));
            } else if (itemsObj instanceof List) {
                List itemsList = (List)itemsObj;
                this.syncItems = new ArrayList();
                for (Object item : itemsList) {
                    if (item instanceof JSONObject) {
                        this.syncItems.add(this.sanitizeJson((JSONObject)item));
                        continue;
                    }
                    if (item instanceof Map) {
                        JSONObject jsonItem = new JSONObject((Map)item);
                        this.syncItems.add(this.sanitizeJson(jsonItem));
                        continue;
                    }
                    logger.warning("Item in ArrayList is not a JSONObject or LinkedHashMap. Skipping. Type: " + item.getClass().getName());
                }
            } else {
                logger.warning("'items' is not a valid JSONArray, JSONObject, or ArrayList. Type: " + (itemsObj != null ? itemsObj.getClass().getName() : "null"));
                this.syncItems = new ArrayList();
            }
        } else {
            this.syncItems = new ArrayList();
        }
        this.paginationToken = null;
        this.syncToken = null;
        if (this.receiveJson.has("skip")) {
            this.skip = this.receiveJson.optInt("skip");
        }
        if (this.receiveJson.has("total_count")) {
            this.count = this.receiveJson.optInt("total_count");
        }
        if (this.receiveJson.has("limit")) {
            this.limit = this.receiveJson.optInt("limit");
        }
        this.paginationToken = this.receiveJson.has("pagination_token") ? this.validateToken(this.receiveJson.optString("pagination_token")) : null;
        this.syncToken = this.receiveJson.has("sync_token") ? this.validateToken(this.receiveJson.optString("sync_token")) : null;
    }

    private JSONObject sanitizeJson(JSONObject json) {
        JSONObject sanitizedJson = new JSONObject();
        for (String key : json.keySet()) {
            Object value = json.opt(key);
            if (value instanceof String) {
                String cleanValue = ((String)value).replaceAll("(?i)<script>", "&lt;script&gt;").replaceAll("(?i)</script>", "&lt;/script&gt;");
                sanitizedJson.put(key, (Object)cleanValue);
                continue;
            }
            sanitizedJson.put(key, value);
        }
        return sanitizedJson;
    }

    private String validateToken(String token) {
        if (token != null && !token.matches("^[a-zA-Z0-9-_.]+$")) {
            logger.warning("Invalid token detected: ");
            return null;
        }
        return token;
    }
}

