/*
 * Decompiled with CFR 0.152.
 */
package com.contentstack.sdk;

import com.contentstack.sdk.CSBackgroundTask;
import com.contentstack.sdk.Constants;
import com.contentstack.sdk.GlobalFieldsCallback;
import com.contentstack.sdk.ResultCallBack;
import com.contentstack.sdk.Stack;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.logging.Logger;
import org.jetbrains.annotations.NotNull;
import org.json.JSONObject;

public class GlobalField {
    protected static final Logger logger = Logger.getLogger(GlobalField.class.getSimpleName());
    protected String globalFieldUid;
    protected Stack stackInstance = null;
    protected JSONObject params = new JSONObject();
    protected LinkedHashMap<String, Object> headers = null;

    protected GlobalField() {
        this.headers = new LinkedHashMap();
    }

    protected GlobalField(@NotNull String globalFieldUid) {
        this.globalFieldUid = globalFieldUid;
        this.headers = new LinkedHashMap();
    }

    protected void setStackInstance(Stack stack) {
        this.stackInstance = stack;
        this.headers = stack.headers;
    }

    public void setHeader(String headerKey, String headerValue) {
        if (!headerKey.isEmpty() && !headerValue.isEmpty()) {
            this.headers.put(headerKey, headerValue);
        }
    }

    public void removeHeader(String headerKey) {
        if (!headerKey.isEmpty()) {
            this.headers.remove(headerKey);
        }
    }

    public GlobalField includeBranch() {
        this.params.put("include_branch", true);
        return this;
    }

    public GlobalField includeGlobalFieldSchema() {
        this.params.put("include_global_field_schema", true);
        return this;
    }

    public void fetch(GlobalFieldsCallback callback) throws IllegalAccessException {
        String urlString = "global_fields/" + this.globalFieldUid;
        if (this.globalFieldUid == null || this.globalFieldUid.isEmpty()) {
            throw new IllegalAccessException("globalFieldUid is required");
        }
        this.fetchGlobalFields(urlString, this.params, this.headers, callback);
    }

    public void findAll(GlobalFieldsCallback callback) {
        String urlString = "global_fields";
        this.fetchGlobalFields(urlString, this.params, this.headers, callback);
    }

    private void fetchGlobalFields(String urlString, JSONObject params, HashMap<String, Object> headers, GlobalFieldsCallback callback) {
        if (callback != null) {
            HashMap<String, Object> urlParams = this.getUrlParams(params);
            new CSBackgroundTask(this, this.stackInstance, "getGlobalFields", urlString, headers, urlParams, Constants.REQUEST_CONTROLLER.GLOBALFIELDS.toString(), (ResultCallBack)callback);
        }
    }

    private HashMap<String, Object> getUrlParams(JSONObject urlQueriesJSON) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        if (urlQueriesJSON != null && urlQueriesJSON.length() > 0) {
            Iterator itStr = urlQueriesJSON.keys();
            while (itStr.hasNext()) {
                String key = (String)itStr.next();
                Object value = urlQueriesJSON.opt(key);
                hashMap.put(key, value);
            }
        }
        return hashMap;
    }
}

