/*
 * Decompiled with CFR 0.152.
 */
package com.datadoghq.datadog_lambda_java;

import com.datadoghq.datadog_lambda_java.DDLogger;
import java.util.HashMap;
import java.util.Map;

class DDTraceContext {
    protected String traceID;
    protected String parentID;
    protected String samplingPriority;
    protected String ddTraceKey = "x-datadog-trace-id";
    protected String ddParentKey = "x-datadog-parent-id";
    protected String ddSamplingKey = "x-datadog-sampling-priority";

    public String getTraceID() {
        return this.traceID;
    }

    public String getParentID() {
        return this.parentID;
    }

    public String getSamplingPriority() {
        return this.samplingPriority;
    }

    public DDTraceContext() {
    }

    public DDTraceContext(Map<String, String> headers) throws Exception {
        if (headers == null) {
            DDLogger.getLoggerImpl().debug("Unable to extract DD Context from null headers", new Object[0]);
            throw new Exception("null headers!");
        }
        if ((headers = this.toLowerKeys(headers)).get(this.ddTraceKey) == null) {
            DDLogger.getLoggerImpl().debug("Headers missing the DD Trace ID", new Object[0]);
            throw new Exception("No trace ID");
        }
        this.traceID = headers.get(this.ddTraceKey);
        if (headers.get(this.ddParentKey) == null) {
            DDLogger.getLoggerImpl().debug("Headers missing the DD Parent ID", new Object[0]);
            throw new Exception("Missing Parent ID");
        }
        this.parentID = headers.get(this.ddParentKey);
        if (headers.get(this.ddSamplingKey) == null) {
            DDLogger.getLoggerImpl().debug("Headers missing the DD Sampling Priority. Defaulting to '2'", new Object[0]);
            headers.put(this.ddSamplingKey, "2");
        }
        this.samplingPriority = headers.get(this.ddSamplingKey);
    }

    private Map<String, String> toLowerKeys(Map<String, String> headers) {
        HashMap<String, String> headers2 = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : headers.entrySet()) {
            String k = entry.getKey();
            String v = entry.getValue();
            headers2.put(k, v);
            headers2.put(k.toLowerCase(), v);
        }
        return headers2;
    }

    public Map<String, String> toJSONMap() {
        HashMap<String, String> jo = new HashMap<String, String>();
        jo.put("trace-id", this.getTraceID());
        jo.put("parent-id", this.getParentID());
        jo.put("sampling-priority", this.getSamplingPriority());
        return jo;
    }

    public Map<String, String> getKeyValues() {
        HashMap<String, String> keyValues = new HashMap<String, String>();
        if (this.traceID != null) {
            keyValues.put(this.ddTraceKey, this.traceID);
        }
        if (this.parentID != null) {
            keyValues.put(this.ddParentKey, this.parentID);
        }
        if (this.samplingPriority != null) {
            keyValues.put(this.ddSamplingKey, this.samplingPriority);
        }
        return keyValues;
    }
}

