/*
 * Decompiled with CFR 0.152.
 */
package com.docusign.webforms.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;

@Schema(description="An error occurred while processing a request. Source - https://www.baeldung.com/rest-api-error-handling-best-practices")
public class HttpError {
    @JsonProperty(value="errorCode")
    private String errorCode = null;
    @JsonProperty(value="message")
    private String message = null;

    public HttpError errorCode(String errorCode) {
        this.errorCode = errorCode;
        return this;
    }

    @Schema(description="A granular, human and computer readable code indicating more deeply what error occurred.")
    public String getErrorCode() {
        return this.errorCode;
    }

    public void setErrorCode(String errorCode) {
        this.errorCode = errorCode;
    }

    public HttpError message(String message) {
        this.message = message;
        return this;
    }

    @Schema(description="A human-readable description of the error, meant for developers to store for their review.")
    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HttpError httpError = (HttpError)o;
        return Objects.equals(this.errorCode, httpError.errorCode) && Objects.equals(this.message, httpError.message);
    }

    public int hashCode() {
        return Objects.hash(this.errorCode, this.message);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class HttpError {\n");
        sb.append("    errorCode: ").append(this.toIndentedString(this.errorCode)).append("\n");
        sb.append("    message: ").append(this.toIndentedString(this.message)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

