package com.docusign.webforms.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serializable;
import java.util.Objects;

/** WebFormInstanceEnvelopes. */
public class WebFormInstanceEnvelopes implements Serializable {
  private static final long serialVersionUID = 1L;

  @JsonProperty("id")
  private String id = null;

  @JsonProperty("createdDateTime")
  private String createdDateTime = null;

  /**
   * id.
   *
   * @return WebFormInstanceEnvelopes
   */
  public WebFormInstanceEnvelopes id(String id) {
    this.id = id;
    return this;
  }

  /**
   * Get id.
   *
   * @return id
   */
  @Schema(description = "")
  public String getId() {
    return id;
  }

  /** setId. */
  public void setId(String id) {
    this.id = id;
  }

  /**
   * createdDateTime.
   *
   * @return WebFormInstanceEnvelopes
   */
  public WebFormInstanceEnvelopes createdDateTime(String createdDateTime) {
    this.createdDateTime = createdDateTime;
    return this;
  }

  /**
   * The dateTime when an envelope is created..
   *
   * @return createdDateTime
   */
  @Schema(description = "The dateTime when an envelope is created.")
  public String getCreatedDateTime() {
    return createdDateTime;
  }

  /** setCreatedDateTime. */
  public void setCreatedDateTime(String createdDateTime) {
    this.createdDateTime = createdDateTime;
  }

  /**
   * Compares objects.
   *
   * @return true or false depending on comparison result.
   */
  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    WebFormInstanceEnvelopes webFormInstanceEnvelopes = (WebFormInstanceEnvelopes) o;
    return Objects.equals(this.id, webFormInstanceEnvelopes.id)
        && Objects.equals(this.createdDateTime, webFormInstanceEnvelopes.createdDateTime);
  }

  /** Returns the HashCode. */
  @Override
  public int hashCode() {
    return Objects.hash(id, createdDateTime);
  }

  /** Converts the given object to string. */
  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class WebFormInstanceEnvelopes {\n");

    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    createdDateTime: ").append(toIndentedString(createdDateTime)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}
