/*
 * Decompiled with CFR 0.152.
 */
package com.exsoloscript.challonge.handler.call;

import com.exsoloscript.challonge.handler.call.AsyncCallback;
import com.exsoloscript.challonge.handler.call.Callback;
import com.exsoloscript.challonge.handler.call.ChallongeApiCall;
import com.exsoloscript.challonge.model.exception.ChallongeException;
import com.exsoloscript.challonge.util.ErrorUtil;
import java.io.IOException;
import retrofit2.Call;
import retrofit2.Response;

public class RetrofitChallongeApiCall<T>
implements ChallongeApiCall<T> {
    private final Call<T> retrofitCall;
    private final ErrorUtil errorUtil;

    RetrofitChallongeApiCall(Call<T> retrofitCall, ErrorUtil errorUtil) {
        this.retrofitCall = retrofitCall;
        this.errorUtil = errorUtil;
    }

    @Override
    public T sync() throws IOException, ChallongeException {
        Response<T> response = this.retrofitCall.execute();
        if (response.isSuccessful()) {
            return response.body();
        }
        this.errorUtil.parseException(response);
        return response.body();
    }

    @Override
    public void async(final Callback<T> success, final Callback<Throwable> error) {
        this.retrofitCall.enqueue(new retrofit2.Callback<T>(){

            @Override
            public void onResponse(Call<T> call, Response<T> response) {
                if (response.isSuccessful()) {
                    success.handle(response.body());
                } else {
                    try {
                        RetrofitChallongeApiCall.this.errorUtil.parseException(response);
                    }
                    catch (ChallongeException | IOException e) {
                        error.handle(e);
                    }
                }
            }

            @Override
            public void onFailure(Call<T> call, Throwable t) {
                error.handle(t);
            }
        });
    }

    @Override
    @Deprecated
    public void async(AsyncCallback<T> callback) {
        this.async(callback::handleSuccess, callback::handleFailure);
    }
}

