/*
 * Decompiled with CFR 0.152.
 */
package com.exsoloscript.challonge.library.google.common.collect;

import com.exsoloscript.challonge.library.google.common.annotations.GwtCompatible;
import com.exsoloscript.challonge.library.google.common.annotations.GwtIncompatible;
import com.exsoloscript.challonge.library.google.common.collect.ImmutableList;
import com.exsoloscript.challonge.library.google.common.collect.ImmutableSortedSet;
import com.exsoloscript.challonge.library.google.common.collect.RegularImmutableAsList;
import com.exsoloscript.challonge.library.google.common.collect.RegularImmutableSortedSet;
import com.exsoloscript.challonge.library.google.common.collect.SortedIterable;
import com.exsoloscript.challonge.library.javax.annotation.Nullable;
import java.util.Comparator;

@GwtCompatible(emulated=true)
final class ImmutableSortedAsList<E>
extends RegularImmutableAsList<E>
implements SortedIterable<E> {
    ImmutableSortedAsList(ImmutableSortedSet<E> backingSet, ImmutableList<E> backingList) {
        super(backingSet, backingList);
    }

    @Override
    ImmutableSortedSet<E> delegateCollection() {
        return (ImmutableSortedSet)super.delegateCollection();
    }

    @Override
    public Comparator<? super E> comparator() {
        return ((ImmutableSortedSet)this.delegateCollection()).comparator();
    }

    @Override
    @GwtIncompatible(value="ImmutableSortedSet.indexOf")
    public int indexOf(@Nullable Object target) {
        int index = ((ImmutableSortedSet)this.delegateCollection()).indexOf(target);
        return index >= 0 && this.get(index).equals(target) ? index : -1;
    }

    @Override
    @GwtIncompatible(value="ImmutableSortedSet.indexOf")
    public int lastIndexOf(@Nullable Object target) {
        return this.indexOf(target);
    }

    @Override
    public boolean contains(Object target) {
        return this.indexOf(target) >= 0;
    }

    @Override
    @GwtIncompatible(value="super.subListUnchecked does not exist; inherited subList is valid if slow")
    ImmutableList<E> subListUnchecked(int fromIndex, int toIndex) {
        ImmutableList parentSubList = super.subListUnchecked(fromIndex, toIndex);
        return new RegularImmutableSortedSet(parentSubList, this.comparator()).asList();
    }
}

