/*
 * Decompiled with CFR 0.152.
 */
package sk.antons.json.parse;

import java.util.ArrayList;
import java.util.List;
import sk.antons.json.literal.JsonLiteral;
import sk.antons.json.literal.impl.JsonLiteralImpl;
import sk.antons.json.match.Match;
import sk.antons.json.match.PathMatcher;
import sk.antons.json.parse.traversal.JsonContentHandler;
import sk.antons.json.parse.traversal.StopTraverse;
import sk.antons.json.parse.traversal.TraversalParser;
import sk.antons.json.source.JsonSource;

public class LiteralParser {
    public static JsonLiteral first(JsonSource source, PathMatcher matcher) {
        Handler handler = new Handler(matcher, true);
        TraversalParser.instance(source, handler).parse();
        List<JsonLiteral> literals = handler.literals();
        if (literals.isEmpty()) {
            return null;
        }
        return literals.get(0);
    }

    public static List<JsonLiteral> all(JsonSource source, PathMatcher matcher) {
        Handler handler = new Handler(matcher, false);
        TraversalParser.instance(source, handler).parse();
        List<JsonLiteral> literals = handler.literals();
        return literals;
    }

    public static String firstAsString(JsonSource source, PathMatcher matcher) {
        JsonLiteral literal = LiteralParser.first(source, matcher);
        if (literal == null) {
            return null;
        }
        return literal.stringValue();
    }

    public static List<String> allAsString(JsonSource source, PathMatcher matcher) {
        List<JsonLiteral> literals = LiteralParser.all(source, matcher);
        ArrayList<String> values = new ArrayList<String>();
        for (JsonLiteral literal : literals) {
            values.add(literal.stringValue());
        }
        return values;
    }

    private static class Handler
    implements JsonContentHandler {
        private PathMatcher matcher = null;
        List<String> path = new ArrayList<String>();
        List<Object> realpath = new ArrayList<Object>();
        private boolean onlyFirstOne = false;
        List<JsonLiteral> literals = new ArrayList<JsonLiteral>();
        private boolean nextStringLiteralIsAttr = false;

        public Handler(PathMatcher matcher, boolean onlyFirstOne) {
            this.matcher = matcher;
            this.onlyFirstOne = onlyFirstOne;
        }

        public List<JsonLiteral> literals() {
            return this.literals;
        }

        @Override
        public String contextInfo() {
            StringBuilder sb = new StringBuilder("path: ");
            for (String item : this.path) {
                sb.append('/').append(item);
            }
            return sb.toString();
        }

        @Override
        public void startDocument() {
        }

        @Override
        public void endDocument() {
        }

        @Override
        public void startArray() {
            this.path.add("0");
            this.realpath.add(0);
        }

        @Override
        public void endArray() {
            this.path.remove(this.path.size() - 1);
            this.realpath.remove(this.realpath.size() - 1);
        }

        @Override
        public void startObject() {
            this.nextStringLiteralIsAttr = true;
        }

        @Override
        public void endObject() {
            this.nextStringLiteralIsAttr = false;
        }

        @Override
        public void valueSeparator() {
            Object o = this.realpath.get(this.realpath.size() - 1);
            this.path.remove(this.path.size() - 1);
            this.realpath.remove(this.realpath.size() - 1);
            if (o instanceof Integer) {
                int i = (Integer)o;
                this.path.add("" + ++i);
                this.realpath.add(i);
            } else {
                this.nextStringLiteralIsAttr = true;
            }
        }

        @Override
        public void nameSeparator() {
        }

        @Override
        public void literal(JsonLiteralImpl literal) {
            if (this.nextStringLiteralIsAttr) {
                if (!literal.isStringLiteral()) {
                    throw new IllegalArgumentException("Expecten name of the attribute and is " + literal);
                }
                this.path.add(literal.stringValue());
                this.realpath.add(literal.stringValue());
                this.nextStringLiteralIsAttr = false;
            } else if (this.matcher.match(this.path, literal) == Match.FULLY) {
                this.literals.add(literal);
                if (this.onlyFirstOne) {
                    throw StopTraverse.instance();
                }
            }
        }

        @Override
        public void whiteSpace(String content, int offset, int length) {
        }
    }
}

