/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.javaflacencoder;

public class EncodingConfiguration
implements Cloneable {
    public static final int MAX_LPC_ORDER = 32;
    public static final int MIN_LPC_ORDER = 1;
    public static final int MAX_RICE_PARTITION_ORDER = 15;
    public static final SubframeType DEFAULT_SUBFRAME_TYPE = SubframeType.EXHAUSTIVE;
    public static final ChannelConfig DEFAULT_CHANNEL_CONFIG = ChannelConfig.ENCODER_CHOICE;
    public static final int DEFAULT_MAX_LPC_ORDER = 12;
    public static final int DEFAULT_MIN_LPC_ORDER = 1;
    public static final int DEFAULT_MAX_RICE_ORDER = 0;
    ChannelConfig channelConfig;
    SubframeType subframeType;
    int minimumLPCOrder = 1;
    int maximumLPCOrder = 16;
    int maximumRicePartitionOrder = 0;

    public EncodingConfiguration() {
        this.subframeType = DEFAULT_SUBFRAME_TYPE;
        this.channelConfig = DEFAULT_CHANNEL_CONFIG;
        this.maximumLPCOrder = 12;
        this.minimumLPCOrder = 1;
        this.maximumRicePartitionOrder = 0;
    }

    public EncodingConfiguration(EncodingConfiguration e) {
        this.subframeType = e.subframeType;
        this.channelConfig = e.channelConfig;
        this.minimumLPCOrder = e.minimumLPCOrder;
        this.maximumLPCOrder = e.maximumLPCOrder;
        this.maximumRicePartitionOrder = e.maximumRicePartitionOrder;
    }

    public void setChannelConfig(ChannelConfig conf) {
        this.channelConfig = conf;
    }

    public ChannelConfig getChannelConfig() {
        return this.channelConfig;
    }

    public void setSubframeType(SubframeType type) {
        this.subframeType = type;
    }

    public SubframeType getSubframeType() {
        return this.subframeType;
    }

    public int getMinLPCOrder() {
        return this.minimumLPCOrder;
    }

    public int getMaxLPCOrder() {
        return this.maximumLPCOrder;
    }

    public void setMinLPCOrder(int order) {
        this.minimumLPCOrder = order < 1 ? 1 : order;
        this.minimumLPCOrder = this.minimumLPCOrder > 32 ? 32 : this.minimumLPCOrder;
    }

    public void setMaxLPCOrder(int order) {
        this.maximumLPCOrder = order < 1 ? 1 : order;
        this.maximumLPCOrder = this.maximumLPCOrder > 32 ? 32 : this.maximumLPCOrder;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SubframeType {
        CONSTANT,
        FIXED,
        LPC,
        VERBATIM,
        EXHAUSTIVE;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ChannelConfig {
        INDEPENDENT,
        LEFT_SIDE,
        RIGHT_SIDE,
        MID_SIDE,
        EXHAUSTIVE,
        ENCODER_CHOICE;

    }
}

