/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.javaflacencoder;

import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.locks.ReentrantLock;
import net.sourceforge.javaflacencoder.ArrayRecycler;
import net.sourceforge.javaflacencoder.BlockEncodeRequest;
import net.sourceforge.javaflacencoder.BlockThreadManager;
import net.sourceforge.javaflacencoder.EncodedElement;
import net.sourceforge.javaflacencoder.EncodingConfiguration;
import net.sourceforge.javaflacencoder.FLACOutputStream;
import net.sourceforge.javaflacencoder.FLACStreamController;
import net.sourceforge.javaflacencoder.FLAC_MD5;
import net.sourceforge.javaflacencoder.Frame;
import net.sourceforge.javaflacencoder.StreamConfiguration;

public class FLACEncoder {
    int DEBUG_LEV = 0;
    private int MAX_THREADED_FRAMES = Runtime.getRuntime().availableProcessors();
    volatile EncodingConfiguration encodingConfig = null;
    volatile StreamConfiguration streamConfig = null;
    volatile Boolean isEncoding = false;
    volatile boolean flacStreamIsOpen = false;
    public final ReentrantLock streamLock = new ReentrantLock();
    private final ReentrantLock sampleLock = new ReentrantLock();
    private ReentrantLock blockFinishedLock = new ReentrantLock();
    private volatile BlockEncodeRequest unfilledRequest = null;
    private volatile int unfinishedBlockUsed = 0;
    volatile Frame frame = null;
    FLAC_MD5 md5 = null;
    BlockThreadManager threadManager = null;
    Frame[] threadedFrames = null;
    FLACStreamController flacWriter = null;
    boolean error = false;
    IOException childException = null;
    LinkedBlockingQueue<BlockEncodeRequest> usedBlockEncodeRequests = new LinkedBlockingQueue();
    LinkedBlockingQueue<BlockEncodeRequest> preparedRequests = new LinkedBlockingQueue();
    ArrayRecycler recycler = new ArrayRecycler();

    public FLACEncoder() {
        this.streamConfig = new StreamConfiguration();
        this.encodingConfig = new EncodingConfiguration();
        this.frame = new Frame(this.streamConfig);
        this.frame.registerConfiguration(this.encodingConfig);
        this.prepareThreadManager(this.streamConfig);
        try {
            this.md5 = new FLAC_MD5();
            this.clear();
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("Error! FLACEncoder cannot functionwithout a valid MD5 implementation.", e);
        }
    }

    public boolean setThreadCount(int count) {
        boolean result = false;
        if (count < 0 || this.flacStreamIsOpen) {
            return false;
        }
        this.streamLock.lock();
        try {
            if (this.flacStreamIsOpen) {
                result = false;
            } else {
                this.MAX_THREADED_FRAMES = count;
                this.prepareThreadManager(this.streamConfig);
                result = true;
            }
        }
        finally {
            this.streamLock.unlock();
        }
        return result;
    }

    private void prepareThreadManager(StreamConfiguration sc) {
        assert (!this.flacStreamIsOpen);
        if (this.MAX_THREADED_FRAMES > 0) {
            this.threadManager = new BlockThreadManager(this);
            this.threadedFrames = new Frame[this.MAX_THREADED_FRAMES];
            for (int i = 0; i < this.MAX_THREADED_FRAMES; ++i) {
                this.threadedFrames[i] = new Frame(this.streamConfig);
                this.threadManager.addFrameThread(this.threadedFrames[i]);
            }
        } else {
            this.threadManager = null;
        }
    }

    public int getThreadCount() {
        return this.MAX_THREADED_FRAMES;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setEncodingConfiguration(EncodingConfiguration ec) {
        boolean changed = false;
        if (!this.isEncoding.booleanValue() && ec != null) {
            this.streamLock.lock();
            try {
                if (!this.isEncoding.booleanValue()) {
                    this.encodingConfig = ec;
                    this.frame.registerConfiguration(ec);
                    for (int i = 0; i < this.MAX_THREADED_FRAMES; ++i) {
                        this.threadedFrames[i].registerConfiguration(ec);
                    }
                    changed = true;
                }
            }
            finally {
                this.streamLock.unlock();
            }
        }
        return changed;
    }

    public boolean setStreamConfiguration(StreamConfiguration sc) {
        boolean changed = false;
        if ((sc = new StreamConfiguration(sc)) != null) {
            if (this.flacStreamIsOpen || this.isEncoding.booleanValue()) {
                changed = false;
            } else {
                this.streamLock.lock();
                try {
                    if (this.flacStreamIsOpen || this.isEncoding.booleanValue()) {
                        changed = false;
                    } else {
                        this.streamConfig = sc;
                        this.reset();
                        this.frame = new Frame(sc);
                        this.prepareThreadManager(sc);
                        this.setEncodingConfiguration(this.encodingConfig);
                        this.clear();
                        changed = true;
                    }
                }
                finally {
                    this.streamLock.unlock();
                }
            }
        }
        return changed;
    }

    private void reset() {
        this.md5.getMD().reset();
        if (this.flacWriter != null) {
            this.flacWriter = new FLACStreamController(this.flacWriter.getFLACOutputStream(), this.streamConfig);
        }
    }

    public final void clear() {
        this.unfilledRequest = null;
        this.preparedRequests.clear();
    }

    private void closeFLACStream() throws IOException {
        this.checkForThreadErrors();
        if (this.DEBUG_LEV > 0) {
            System.err.println("FLACEncoder::closeFLACStream : Begin");
        }
        this.streamLock.lock();
        try {
            if (!this.flacStreamIsOpen) {
                throw new IllegalStateException("Cannot close a non-opened stream");
            }
            byte[] md5Hash = this.md5.getMD().digest();
            this.flacWriter.closeFLACStream(md5Hash, this.streamConfig);
            this.flacStreamIsOpen = false;
        }
        finally {
            this.streamLock.unlock();
        }
    }

    public void openFLACStream() throws IOException {
        this.streamLock.lock();
        try {
            this.flacWriter.openFLACStream();
            this.flacStreamIsOpen = true;
        }
        finally {
            this.streamLock.unlock();
        }
    }

    private BlockEncodeRequest prepareRequest(int blockSize, int channels) {
        int[] block = this.recycler.getArray(blockSize * channels);
        BlockEncodeRequest ber = this.usedBlockEncodeRequests.poll();
        if (ber == null) {
            ber = new BlockEncodeRequest();
        }
        EncodedElement result = new EncodedElement(1, 0);
        ber.setAll(block, 0, 0, channels - 1, 0L, result);
        return ber;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSamples(int[] samples, int count) {
        assert (count * this.streamConfig.getChannelCount() <= samples.length);
        if (samples.length < count * this.streamConfig.getChannelCount()) {
            throw new IllegalArgumentException("count given exceeds samples array bounds");
        }
        this.sampleLock.lock();
        try {
            int channels = this.streamConfig.getChannelCount();
            int maxBlock = this.streamConfig.getMaxBlockSize();
            if (this.unfilledRequest == null) {
                this.unfilledRequest = this.prepareRequest(maxBlock, channels);
            }
            int remaining = count;
            int offset = 0;
            while (remaining > 0) {
                int newRemaining = this.unfilledRequest.addInterleavedSamples(samples, offset, remaining, maxBlock);
                offset += (remaining - newRemaining) * channels;
                remaining = newRemaining;
                if (this.unfilledRequest.isFull(maxBlock)) {
                    this.preparedRequests.add(this.unfilledRequest);
                    this.unfilledRequest = null;
                }
                if (remaining <= 0) continue;
                this.unfilledRequest = this.prepareRequest(maxBlock, channels);
            }
        }
        finally {
            this.sampleLock.unlock();
        }
    }

    private void writeFinishedBlock(BlockEncodeRequest ber) throws IOException {
        this.flacWriter.writeBlock(ber);
        this.md5.addSamplesToMD5(ber.samples, ber.encodedSamples, ber.skip + 1, this.streamConfig.getBitsPerSample());
        this.recycler.add(ber.samples);
        ber.result = null;
        ber.samples = null;
        this.usedBlockEncodeRequests.add(ber);
        if (this.threadManager.getTotalManagedCount() == 1) {
            this.streamLock.lock();
            try {
                if (this.threadManager.getTotalManagedCount() == 1) {
                    this.isEncoding = false;
                }
            }
            finally {
                this.streamLock.unlock();
            }
        }
    }

    protected void blockFinished(BlockEncodeRequest ber) {
        assert (this.flacStreamIsOpen);
        this.blockFinishedLock.lock();
        try {
            this.writeFinishedBlock(ber);
        }
        catch (IOException e) {
            this.error = true;
            if (this.childException != null) {
                this.childException = e;
            }
        }
        finally {
            this.blockFinishedLock.unlock();
        }
    }

    private void checkForThreadErrors() throws IOException {
        if (this.error && this.childException != null) {
            this.error = false;
            IOException temp = this.childException;
            this.childException = null;
            throw temp;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int t_encodeSamples(int inCount, boolean end, int blockingCount) throws IOException {
        int count = inCount;
        if (this.MAX_THREADED_FRAMES <= 0) {
            return this.encodeSamples(count, end);
        }
        int encodedCount = 0;
        if (end) {
            this.sampleLock.lock();
        }
        try {
            this.checkForThreadErrors();
            this.streamLock.lock();
            try {
                while (count > 0 && this.preparedRequests.size() > 0) {
                    BlockEncodeRequest ber = this.preparedRequests.poll();
                    int encodedSamples = ber.count;
                    ber.frameNumber = this.flacWriter.incrementFrameNumber();
                    this.threadManager.addRequest(ber);
                    this.isEncoding = true;
                    count -= encodedSamples;
                    encodedCount += encodedSamples;
                }
            }
            finally {
                this.streamLock.unlock();
            }
            this.threadManager.blockWhileQueueExceeds(blockingCount);
            if (end) {
                this.streamLock.lock();
                try {
                    if (count > 0 && this.unfilledRequest != null && this.unfilledRequest.count >= count) {
                        int encodedSamples = this.unfilledRequest.count;
                        this.threadManager.addRequest(this.unfilledRequest);
                        this.unfilledRequest = null;
                        this.isEncoding = true;
                        count -= encodedSamples;
                        encodedCount += encodedSamples;
                    }
                }
                finally {
                    this.streamLock.unlock();
                }
                this.threadManager.blockWhileQueueExceeds(0);
                this.threadManager.stop();
            }
            if (end && encodedCount >= inCount) {
                this.closeFLACStream();
            }
        }
        finally {
            if (end && this.sampleLock.isHeldByCurrentThread()) {
                this.sampleLock.unlock();
            }
        }
        return encodedCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int encodeSamples(int count, boolean end) throws IOException {
        int encodedCount = 0;
        this.streamLock.lock();
        try {
            int encodedSamples;
            BlockEncodeRequest ber;
            this.checkForThreadErrors();
            int channels = this.streamConfig.getChannelCount();
            boolean encodeError = false;
            while (count > 0 && this.preparedRequests.size() > 0 && !encodeError) {
                ber = this.preparedRequests.peek();
                encodedSamples = this.encodeRequest(ber, channels);
                if (encodedSamples < 0) {
                    System.err.println("FLACEncoder::encodeSamples : Error in encoding");
                    encodeError = true;
                    break;
                }
                this.preparedRequests.poll();
                encodedCount += encodedSamples;
                count -= encodedSamples;
            }
            if (end) {
                if (this.threadManager != null) {
                    this.threadManager.stop();
                }
                if (count > 0 && this.unfilledRequest != null && this.unfilledRequest.count >= count) {
                    ber = this.unfilledRequest;
                    encodedSamples = this.encodeRequest(ber, channels);
                    if (encodedSamples < 0) {
                        System.err.println("FLACEncoder::encodeSamples : (end)Error in encoding");
                        count = -1;
                    } else {
                        count -= encodedSamples;
                        encodedCount += encodedSamples;
                        this.unfilledRequest = null;
                    }
                }
                if (count <= 0) {
                    this.closeFLACStream();
                }
            } else if (end && this.DEBUG_LEV > 30) {
                System.err.println("End set but not done. Error possible. This can also happen if number of samples requested to encode exeeds available samples");
            }
        }
        finally {
            this.streamLock.unlock();
        }
        return encodedCount;
    }

    private int encodeRequest(BlockEncodeRequest ber, int channels) throws IOException {
        ber.frameNumber = this.flacWriter.incrementFrameNumber();
        int[] block = ber.samples;
        int encodedSamples = ber.count;
        EncodedElement result = ber.result;
        int encoded = this.frame.encodeSamples(block, encodedSamples, 0, channels - 1, result, ber.frameNumber);
        if (encoded != encodedSamples) {
            System.err.println("FLACEncoder::encodeSamples : Error in encoding");
            return -1;
        }
        ber.encodedSamples = encoded;
        this.writeFinishedBlock(ber);
        return encodedSamples;
    }

    public int fullBlockSamplesAvailableToEncode() {
        int available = 0;
        int channels = this.streamConfig.getChannelCount();
        for (BlockEncodeRequest ber : this.preparedRequests) {
            int[] block = ber.samples;
            available += block.length / channels;
        }
        return available;
    }

    public int samplesAvailableToEncode() {
        int available = 0;
        int channels = this.streamConfig.getChannelCount();
        for (BlockEncodeRequest ber : this.preparedRequests) {
            int[] block = ber.samples;
            available += block.length / channels;
        }
        if (this.unfilledRequest != null) {
            available += this.unfilledRequest.count;
        }
        return available;
    }

    public void setOutputStream(FLACOutputStream fos) {
        if (fos == null) {
            throw new IllegalArgumentException("FLACOutputStream fos must not be null.");
        }
        if (this.flacWriter == null) {
            this.flacWriter = new FLACStreamController(fos, this.streamConfig);
        } else {
            this.flacWriter.setFLACOutputStream(fos);
        }
    }
}

