/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.javaflacencoder;

import net.sourceforge.javaflacencoder.CRC16;
import net.sourceforge.javaflacencoder.ChannelData;
import net.sourceforge.javaflacencoder.EncodedElement;
import net.sourceforge.javaflacencoder.EncodingConfiguration;
import net.sourceforge.javaflacencoder.FrameHeader;
import net.sourceforge.javaflacencoder.StreamConfiguration;
import net.sourceforge.javaflacencoder.Subframe_Constant;
import net.sourceforge.javaflacencoder.Subframe_Fixed;
import net.sourceforge.javaflacencoder.Subframe_LPC;
import net.sourceforge.javaflacencoder.Subframe_Verbatim;

public class Frame {
    public static int DEBUG_LEV = 0;
    private int lastEncodeSize;
    EncodingConfiguration ec;
    StreamConfiguration sc;
    int channels;
    int bitsPerSample;
    FrameHeader frameHeader;
    CRC16 crc16;
    Subframe_Verbatim verbatimSubframe;
    Subframe_Fixed fixedSubframe;
    Subframe_LPC lpcSubframe;
    Subframe_Constant constantSubframe;
    boolean testConstant;
    long[] _decorrelationResults = new long[4];
    boolean[] _constantCandidate = new boolean[4];
    int[] _midSideSamples = null;
    ChannelData[] indChanData = null;
    ChannelData[] msChanData = null;
    long[] r_sums = new long[4];

    private Frame() {
    }

    public Frame(StreamConfiguration sc) {
        this.lastEncodeSize = 0;
        this.channels = sc.getChannelCount();
        this.sc = sc;
        this.frameHeader = new FrameHeader();
        this.crc16 = new CRC16();
        this.ec = null;
        this.verbatimSubframe = new Subframe_Verbatim(sc);
        this.fixedSubframe = new Subframe_Fixed(sc);
        this.lpcSubframe = new Subframe_LPC(sc);
        this.constantSubframe = new Subframe_Constant(sc);
        this.bitsPerSample = sc.getBitsPerSample();
        this.testConstant = true;
        this.registerConfiguration(new EncodingConfiguration());
    }

    public boolean registerConfiguration(EncodingConfiguration ec) {
        boolean changed = false;
        if (this.sc.getChannelCount() != 2) {
            ec.setChannelConfig(EncodingConfiguration.ChannelConfig.INDEPENDENT);
        }
        this.ec = new EncodingConfiguration(ec);
        this.verbatimSubframe.registerConfiguration(this.ec);
        this.fixedSubframe.registerConfiguration(this.ec);
        this.lpcSubframe.registerConfiguration(this.ec);
        this.constantSubframe.registerConfiguration(this.ec);
        changed = true;
        return changed;
    }

    public int encodeSamples_OLD(int[] samples, int count, int start, int skip, EncodedElement result, long frameNumber) {
        if (DEBUG_LEV > 0) {
            System.err.println("FRAME::encodeSamples(...)");
            if (DEBUG_LEV > 10) {
                System.err.println("\tsamples.length:" + samples.length + ":count:" + count + ":start:" + start + ":skip:" + skip + ":frameNumber:" + frameNumber);
            }
        }
        int samplesEncoded = count;
        this.testConstant = true;
        EncodedElement data = null;
        EncodingConfiguration.ChannelConfig chConf = this.ec.getChannelConfig();
        if (chConf == EncodingConfiguration.ChannelConfig.INDEPENDENT) {
            data = new EncodedElement(100, 0);
            int n = this.encodeIndependent(samples, count, start, skip, data, 0);
        } else if (chConf == EncodingConfiguration.ChannelConfig.LEFT_SIDE) {
            data = new EncodedElement(100, 0);
            int n = this.encodeLeftSide(samples, count, start, skip, data, 0);
        } else if (chConf == EncodingConfiguration.ChannelConfig.MID_SIDE) {
            data = new EncodedElement(100, 0);
            int n = Frame.encodeMidSide(samples, count, start, skip, data, 0, this);
        } else if (chConf == EncodingConfiguration.ChannelConfig.RIGHT_SIDE) {
            data = new EncodedElement(100, 0);
            int n = this.encodeRightSide(samples, count, start, skip, data, 0);
        } else if (chConf == EncodingConfiguration.ChannelConfig.ENCODER_CHOICE) {
            data = new EncodedElement(100, 0);
            int size = Frame.allChannelDecorrelation(samples, count, start, skip, data, 0, this);
            chConf = this.ec.channelConfig;
            this.ec.channelConfig = EncodingConfiguration.ChannelConfig.ENCODER_CHOICE;
        } else if (chConf == EncodingConfiguration.ChannelConfig.EXHAUSTIVE) {
            EncodedElement dataLeftSide = new EncodedElement(100, 0);
            this.ec.channelConfig = EncodingConfiguration.ChannelConfig.LEFT_SIDE;
            int sizeLeft = this.encodeLeftSide(samples, count, start, skip, dataLeftSide, 0);
            this.ec.channelConfig = EncodingConfiguration.ChannelConfig.MID_SIDE;
            EncodedElement dataMidSide = new EncodedElement(100, 0);
            int sizeMid = Frame.encodeMidSide(samples, count, start, skip, dataMidSide, 0, this);
            this.ec.channelConfig = EncodingConfiguration.ChannelConfig.INDEPENDENT;
            EncodedElement dataIndependent = new EncodedElement(100, 0);
            int sizeInd = this.encodeIndependent(samples, count, start, skip, dataIndependent, 0);
            this.ec.channelConfig = chConf;
            if (sizeLeft <= sizeMid && sizeLeft <= sizeInd) {
                data = dataLeftSide;
                chConf = EncodingConfiguration.ChannelConfig.LEFT_SIDE;
            } else if (sizeMid <= sizeInd) {
                data = dataMidSide;
                chConf = EncodingConfiguration.ChannelConfig.MID_SIDE;
            } else {
                data = dataIndependent;
                chConf = EncodingConfiguration.ChannelConfig.INDEPENDENT;
            }
        }
        EncodedElement header = this.frameHeader.createHeader(true, count, this.sc.getSampleRate(), chConf, this.sc.getBitsPerSample(), frameNumber, this.channels, new EncodedElement(128, 0));
        result.setNext(header);
        header.attachEnd(data);
        data.padToByte();
        EncodedElement crc16Ele = this.getCRC16(header);
        data.attachEnd(crc16Ele);
        if (DEBUG_LEV > 0) {
            System.err.println("Frame::encodeSamples(...): End");
        }
        return samplesEncoded;
    }

    private EncodingConfiguration.ChannelConfig determineConfigUsed(ChannelData[] channels) {
        EncodingConfiguration.ChannelConfig result = EncodingConfiguration.ChannelConfig.INDEPENDENT;
        if (channels.length == 2) {
            ChannelData.ChannelName n1 = channels[0].getChannelName();
            ChannelData.ChannelName n2 = channels[1].getChannelName();
            if (n2 == ChannelData.ChannelName.SIDE) {
                if (n1 == ChannelData.ChannelName.LEFT) {
                    result = EncodingConfiguration.ChannelConfig.LEFT_SIDE;
                } else if (n1 == ChannelData.ChannelName.MID) {
                    result = EncodingConfiguration.ChannelConfig.MID_SIDE;
                } else {
                    System.err.println("Error in n2, determinConfigUsed");
                }
            }
            if (n1 == ChannelData.ChannelName.SIDE) {
                if (n2 == ChannelData.ChannelName.RIGHT) {
                    result = EncodingConfiguration.ChannelConfig.RIGHT_SIDE;
                } else {
                    System.err.println("Error in n1, determinConfigUsed");
                }
            }
        }
        return result;
    }

    public int encodeSamples(int[] samples, int count, int start, int skip, EncodedElement result, long frameNumber) {
        if (DEBUG_LEV > 0) {
            System.err.println("FRAME::encodeSamplesNew(...)");
            if (DEBUG_LEV > 10) {
                System.err.println("\tsamples.length:" + samples.length + ":count:" + count + ":start:" + start + ":skip:" + skip + ":frameNumber:" + frameNumber);
            }
        }
        int samplesEncoded = count;
        this.testConstant = true;
        EncodedElement data = null;
        ChannelData[][] chanConfigData = this.getChannelsToEncode(samples, count, this.sc.getChannelCount(), this.sc.getBitsPerSample());
        int size = Integer.MAX_VALUE;
        EncodingConfiguration.ChannelConfig chConf = EncodingConfiguration.ChannelConfig.INDEPENDENT;
        for (int i = 0; i < chanConfigData.length; ++i) {
            EncodedElement temp = new EncodedElement();
            int configSize = this.encodeChannels(chanConfigData[i], temp);
            if (configSize >= size) continue;
            size = configSize;
            data = temp;
            chConf = this.determineConfigUsed(chanConfigData[i]);
        }
        EncodedElement header = new EncodedElement(128, 0);
        this.frameHeader.createHeader(true, count, this.sc.getSampleRate(), chConf, this.sc.getBitsPerSample(), frameNumber, this.channels, header);
        result.attachEnd(header);
        header.attachEnd(data);
        data.padToByte();
        EncodedElement crc16Ele = this.getCRC16(header);
        data.attachEnd(crc16Ele);
        if (DEBUG_LEV > 0) {
            System.err.println("Frame::encodeSamples(...): End");
        }
        return samplesEncoded;
    }

    EncodedElement getCRC16(EncodedElement header) {
        EncodedElement crc16Ele = new EncodedElement(2, 0);
        short valNew = header.getCRC16();
        crc16Ele.addInt(valNew, 16);
        return crc16Ele;
    }

    int encodeChannels(ChannelData[] channels, EncodedElement result) {
        int totalSize = 0;
        int channelLength = 0;
        int offset = 0;
        int count = channels[0].getCount();
        for (int i = 0; i < channels.length; ++i) {
            EncodedElement temp = new EncodedElement();
            channelLength = this.encodeChannel(channels[i].getSamples(), count, 0, 0, offset, temp, channels[i].getSampleSize());
            result.attachEnd(temp);
            offset = (totalSize += channelLength) % 8;
        }
        return totalSize;
    }

    int encodeIndependent(int[] samples, int count, int start, int skip, EncodedElement result, int offset) {
        int i;
        if (DEBUG_LEV > 0) {
            System.err.println("Frame::encodeIndependent : Begin");
            System.err.println("start:skip:offset::" + start + ":" + skip + ":" + offset);
        }
        int totalSize = 0;
        int channelLength = 0;
        int channelCount = skip + 1;
        int inputOffset = offset;
        EncodedElement[] subframes = new EncodedElement[channelCount];
        EncodingConfiguration.ChannelConfig chConf = this.ec.channelConfig;
        for (i = 0; i < channelCount; ++i) {
            int channelBitsPerSample = this.bitsPerSample;
            if (i == 1 && chConf == EncodingConfiguration.ChannelConfig.LEFT_SIDE) {
                ++channelBitsPerSample;
            } else if (i == 1 && chConf == EncodingConfiguration.ChannelConfig.MID_SIDE) {
                ++channelBitsPerSample;
            } else if (i == 0 && chConf == EncodingConfiguration.ChannelConfig.RIGHT_SIDE) {
                ++channelBitsPerSample;
            }
            subframes[i] = new EncodedElement();
            channelLength = this.encodeChannel(samples, count, start + i, skip, offset, subframes[i], channelBitsPerSample);
            offset = (inputOffset + (totalSize += channelLength)) % 8;
        }
        result.attachEnd(subframes[0]);
        for (i = 1; i < channelCount; ++i) {
            subframes[i - 1].attachEnd(subframes[i]);
        }
        if (DEBUG_LEV > 0) {
            System.err.println("Frame::encodeIndependent : End");
        }
        return totalSize;
    }

    int encodeChannel(int[] samples, int count, int start, int skip, int offset, EncodedElement data, int channelBitsPerSample) {
        if (DEBUG_LEV > 0) {
            System.err.println("Frame::encodeChannel : Begin");
        }
        int size = 0;
        EncodingConfiguration.SubframeType subframeType = this.ec.getSubframeType();
        if (subframeType == EncodingConfiguration.SubframeType.VERBATIM) {
            this.verbatimSubframe.encodeSamples(samples, count, start, skip, data, offset, channelBitsPerSample);
            size = this.verbatimSubframe.getEncodedSize();
        } else if (subframeType == EncodingConfiguration.SubframeType.FIXED) {
            this.fixedSubframe.encodeSamples(samples, count, start, skip, data, offset, channelBitsPerSample);
            size = this.fixedSubframe.getEncodedSize();
        } else if (subframeType == EncodingConfiguration.SubframeType.LPC) {
            this.lpcSubframe.encodeSamples(samples, count, start, skip, data, offset, channelBitsPerSample);
            size = this.lpcSubframe.getEncodedSize();
        } else if (subframeType == EncodingConfiguration.SubframeType.EXHAUSTIVE) {
            int conCount = -1;
            EncodedElement constantEle = new EncodedElement(200, offset);
            EncodedElement smallest = null;
            if (this.testConstant) {
                conCount = this.constantSubframe.encodeSamples(samples, count, start, skip, constantEle, offset, channelBitsPerSample);
            }
            if (conCount == count) {
                size = this.constantSubframe.getEncodedSize();
                smallest = constantEle;
            } else {
                int verbatimSize = this.verbatimSubframe.estimateSize(count, channelBitsPerSample);
                this.fixedSubframe.encodeSamples(samples, count, start, skip, offset, channelBitsPerSample);
                int fixedSize = this.fixedSubframe.estimatedSize();
                this.lpcSubframe.encodeSamples(samples, count, start, skip, offset, channelBitsPerSample);
                int lpcSize = this.lpcSubframe.estimatedSize();
                if (verbatimSize < lpcSize && verbatimSize < fixedSize) {
                    System.err.println("Running verbatim");
                    smallest = new EncodedElement(verbatimSize, offset);
                    this.verbatimSubframe.encodeSamples(samples, count, start, skip, smallest, offset, channelBitsPerSample);
                    size = this.verbatimSubframe.getEncodedSize();
                } else if (lpcSize < fixedSize && lpcSize < verbatimSize) {
                    smallest = this.lpcSubframe.getData();
                    size = this.lpcSubframe.getEncodedSize();
                    if (size > lpcSize) {
                        System.err.println("Lpc size wrong: exp:real : " + lpcSize + ":" + size);
                    }
                } else {
                    smallest = this.fixedSubframe.getData();
                    size = this.fixedSubframe.getEncodedSize();
                    if (size > fixedSize) {
                        System.err.println("Fixed size wrong: exp:real : " + fixedSize + ":" + size);
                    }
                }
            }
            data.data = smallest.data;
            data.next = smallest.next;
            data.usableBits = smallest.usableBits;
            data.offset = smallest.offset;
        }
        if (DEBUG_LEV > 0) {
            System.err.println("Frame::encodeChannel : End");
        }
        return size;
    }

    public int getEncodedSize() {
        if (DEBUG_LEV > 0) {
            System.err.println("Frame::getEncodedSize : Begin");
        }
        return this.lastEncodeSize;
    }

    private int encodeRightSide(int[] samples, int count, int start, int skip, EncodedElement data, int offset) {
        int[] rightSide = new int[samples.length];
        for (int i = 0; i < count; ++i) {
            rightSide[2 * i] = samples[2 * i] - samples[2 * i + 1];
            rightSide[2 * i + 1] = samples[2 * i + 1];
        }
        return this.encodeIndependent(rightSide, count, start, skip, data, offset);
    }

    private int encodeLeftSide(int[] samples, int count, int start, int skip, EncodedElement data, int offset) {
        int[] leftSide = new int[samples.length];
        for (int i = 0; i < count; ++i) {
            leftSide[2 * i] = samples[2 * i];
            leftSide[2 * i + 1] = samples[2 * i] - samples[2 * i + 1];
        }
        return this.encodeIndependent(leftSide, count, start, skip, data, offset);
    }

    private static void getIndependentChannels(int[] samples, int count, ChannelData[] channels, int sampleSize) {
        int i;
        int channelCount = channels.length;
        int[][] independentSamples = new int[channels.length][];
        for (i = 0; i < channelCount; ++i) {
            ChannelData temp = channels[i];
            if (temp != null) {
                independentSamples[i] = channels[i].getSamples();
            }
            if (independentSamples[i] == null || independentSamples[i].length < count) {
                independentSamples[i] = new int[count];
            }
            if (temp != null) {
                channels[i].setData(independentSamples[i], count, sampleSize, ChannelData.ChannelName.INDEPENDENT);
                continue;
            }
            channels[i] = new ChannelData(independentSamples[i], count, sampleSize, ChannelData.ChannelName.INDEPENDENT);
        }
        for (i = 0; i < count; ++i) {
            for (int x = 0; x < channelCount; ++x) {
                independentSamples[x][i] = samples[channelCount * i + x];
            }
        }
    }

    private static void getMidSideChannels(int[] samples, int count, ChannelData[] channels, int sampleSize) {
        ChannelData midData = channels[0];
        ChannelData sideData = channels[1];
        int[] midSamples = null;
        int[] sideSamples = null;
        if (midData != null) {
            midSamples = midData.getSamples();
        }
        if (sideData != null) {
            sideSamples = sideData.getSamples();
        }
        if (midSamples == null || midSamples.length < count) {
            midSamples = new int[count];
        }
        if (sideSamples == null || sideSamples.length < count) {
            sideSamples = new int[count];
        }
        if (midData != null) {
            channels[0].setData(midSamples, count, sampleSize, ChannelData.ChannelName.MID);
        } else {
            channels[0] = new ChannelData(midSamples, count, sampleSize, ChannelData.ChannelName.MID);
        }
        if (sideData != null) {
            channels[1].setData(sideSamples, count, sampleSize + 1, ChannelData.ChannelName.SIDE);
        } else {
            channels[1] = new ChannelData(sideSamples, count, sampleSize + 1, ChannelData.ChannelName.SIDE);
        }
        for (int i = 0; i < count; ++i) {
            int temp;
            midSamples[i] = temp = samples[2 * i] + samples[2 * i + 1] >> 1;
            sideSamples[i] = samples[2 * i] - samples[2 * i + 1];
        }
    }

    private static long[] sumChannelSamplesABS(ChannelData[] channels) {
        int i;
        long[] result = new long[channels.length];
        for (int i2 = 0; i2 < result.length; ++i2) {
            result[i2] = 0L;
        }
        int[][] samples = new int[channels.length][];
        for (i = 0; i < channels.length; ++i) {
            samples[i] = channels[i].getSamples();
        }
        for (i = 0; i < channels[0].getCount(); ++i) {
            int x = 0;
            while (x < channels.length) {
                int temp = samples[x][i];
                if (temp < 0) {
                    temp = -temp;
                }
                int n = x++;
                result[n] = result[n] + (long)temp;
            }
        }
        return result;
    }

    private ChannelData[][] getChannelsToEncode(int[] samples, int count, int channels, int sampleSize) {
        ChannelData[] independent = this.indChanData;
        ChannelData[] midSide = this.msChanData;
        ChannelData[][] results = null;
        EncodingConfiguration.ChannelConfig chConf = this.ec.getChannelConfig();
        if (channels != 2) {
            chConf = EncodingConfiguration.ChannelConfig.INDEPENDENT;
        }
        if (chConf != EncodingConfiguration.ChannelConfig.MID_SIDE) {
            if (independent == null || independent.length != channels) {
                independent = new ChannelData[channels];
            }
            Frame.getIndependentChannels(samples, count, independent, sampleSize);
        }
        if (chConf != EncodingConfiguration.ChannelConfig.INDEPENDENT) {
            if (midSide == null || midSide.length != 2) {
                midSide = new ChannelData[2];
            }
            Frame.getMidSideChannels(samples, count, midSide, sampleSize);
        }
        if (chConf == EncodingConfiguration.ChannelConfig.ENCODER_CHOICE) {
            chConf = this.selectOptimalChannels(independent, midSide, count);
        }
        if (chConf == EncodingConfiguration.ChannelConfig.INDEPENDENT) {
            results = new ChannelData[][]{independent};
        } else if (chConf == EncodingConfiguration.ChannelConfig.LEFT_SIDE) {
            results = new ChannelData[1][2];
            independent[0].setChannelName(ChannelData.ChannelName.LEFT);
            results[0][0] = independent[0];
            results[0][1] = midSide[1];
        } else if (chConf == EncodingConfiguration.ChannelConfig.MID_SIDE) {
            results = new ChannelData[1][2];
            results[0] = midSide;
        } else if (chConf == EncodingConfiguration.ChannelConfig.RIGHT_SIDE) {
            results = new ChannelData[1][2];
            independent[1].setChannelName(ChannelData.ChannelName.RIGHT);
            results[0][1] = independent[1];
            results[0][0] = midSide[1];
        } else if (chConf == EncodingConfiguration.ChannelConfig.EXHAUSTIVE) {
            results = new ChannelData[4][];
            results[2] = new ChannelData[2];
            results[3] = new ChannelData[2];
            results[0] = independent;
            results[1] = midSide;
            results[2][0] = independent[0];
            independent[0].setChannelName(ChannelData.ChannelName.LEFT);
            results[2][1] = midSide[1];
            results[3][0] = midSide[1];
            results[3][1] = independent[1];
            independent[1].setChannelName(ChannelData.ChannelName.RIGHT);
        }
        this.indChanData = independent;
        this.msChanData = midSide;
        return results;
    }

    private boolean determineTestConstant(long[] sums, ChannelData[] channels) {
        boolean result = false;
        int count = channels[0].getCount();
        for (int i = 0; i < sums.length; ++i) {
            if (sums[i] / (long)count != (long)channels[i].getSamples()[0]) continue;
            result = true;
        }
        return result;
    }

    private EncodingConfiguration.ChannelConfig selectOptimalChannels(ChannelData[] independent, ChannelData[] midSide, int count) {
        EncodingConfiguration.ChannelConfig result;
        long[] sumInd = Frame.sumChannelSamplesABS(independent);
        long[] sumMS = Frame.sumChannelSamplesABS(midSide);
        boolean ind = this.determineTestConstant(sumInd, independent);
        boolean ms = this.determineTestConstant(sumMS, midSide);
        this.testConstant = ind | ms;
        this.r_sums[0] = sumInd[0] + sumInd[1];
        this.r_sums[1] = sumMS[0] + sumMS[1];
        this.r_sums[2] = sumInd[0] + sumMS[1];
        this.r_sums[3] = sumInd[1] + sumMS[1];
        long lowestVal = this.r_sums[0];
        int lowestIndex = 0;
        for (int i = 0; i < 4; ++i) {
            if (lowestVal <= this.r_sums[i]) continue;
            lowestVal = this.r_sums[i];
            lowestIndex = i;
        }
        switch (lowestIndex) {
            case 3: {
                result = EncodingConfiguration.ChannelConfig.RIGHT_SIDE;
                break;
            }
            case 2: {
                result = EncodingConfiguration.ChannelConfig.LEFT_SIDE;
                break;
            }
            case 1: {
                result = EncodingConfiguration.ChannelConfig.MID_SIDE;
                break;
            }
            default: {
                result = EncodingConfiguration.ChannelConfig.INDEPENDENT;
            }
        }
        return result;
    }

    private static int encodeMidSide(int[] samples, int count, int start, int skip, EncodedElement data, int offset, Frame f) {
        int[] midSide = new int[samples.length];
        for (int i = 0; i < count; ++i) {
            int temp;
            midSide[2 * i] = temp = samples[2 * i] + samples[2 * i + 1] >> 1;
            midSide[2 * i + 1] = samples[2 * i] - samples[2 * i + 1];
        }
        return f.encodeIndependent(midSide, count, start, skip, data, offset);
    }

    private static double getVariance(ChannelData chan, double mean) {
        double variance = 0.0;
        int[] samples = chan.getSamples();
        for (int i = 0; i < chan.getCount(); ++i) {
            double val = mean - (double)samples[i];
            variance += val * val;
        }
        return variance;
    }

    private static double getVariance(double mean, int[] samples, int count, int start, int increment) {
        double var = 0.0;
        for (int i = 0; i < count; ++i) {
            int loc = start + i * increment;
            double val = mean - (double)samples[loc];
            var += val * val;
        }
        return var;
    }

    private static int allChannelDecorrelation(int[] samples, int count, int start, int skip, EncodedElement data, int offset, Frame f) {
        int i;
        if (DEBUG_LEV > 0) {
            System.err.println("Frame::allChannelDecorrelation(...)");
        }
        long sums0 = 0L;
        long sums1 = 0L;
        long sums2 = 0L;
        long sums3 = 0L;
        boolean[] constantCandidate = f._constantCandidate;
        for (int i2 = 0; i2 < 4; ++i2) {
            constantCandidate[i2] = false;
        }
        int[] midSideSamples = f._midSideSamples;
        if (midSideSamples == null || midSideSamples.length < samples.length) {
            f._midSideSamples = midSideSamples = new int[samples.length];
        }
        int index = 0;
        for (i = 0; i < count; ++i) {
            int temp;
            midSideSamples[index] = temp = samples[index] + samples[index + 1] >> 1;
            midSideSamples[index + 1] = samples[index] - samples[index + 1];
            index += 2;
        }
        index = 0;
        for (i = 0; i < count; ++i) {
            long temp = samples[index];
            if (temp < 0L) {
                temp = -temp;
            }
            sums0 += temp;
            temp = samples[index + 1];
            if (temp < 0L) {
                temp = -temp;
            }
            sums1 += temp;
            temp = midSideSamples[index];
            if (temp < 0L) {
                temp = -temp;
            }
            sums2 += temp;
            temp = midSideSamples[index + 1];
            if (temp < 0L) {
                temp = -temp;
            }
            sums3 += temp;
            index += 2;
        }
        constantCandidate[0] = (long)samples[0] == (sums0 /= (long)count);
        constantCandidate[1] = (long)samples[1] == (sums1 /= (long)count);
        constantCandidate[2] = (long)midSideSamples[2] == (sums2 /= (long)count);
        constantCandidate[3] = (long)midSideSamples[3] == (sums3 /= (long)count);
        long[] results = f._decorrelationResults;
        results[0] = sums0 + sums1;
        results[1] = sums2 + sums3;
        results[2] = sums0 + sums3;
        results[3] = sums3 + sums1;
        int choice = 0;
        for (int i3 = 0; i3 < 4; ++i3) {
            if (results[choice] <= results[i3]) continue;
            choice = i3;
        }
        int encodeResult = -1;
        if (choice == 0) {
            f.testConstant = constantCandidate[0] || constantCandidate[1];
            f.ec.channelConfig = EncodingConfiguration.ChannelConfig.INDEPENDENT;
            encodeResult = f.encodeIndependent(samples, count, start, skip, data, offset);
        } else if (choice == 1) {
            f.testConstant = constantCandidate[2] || constantCandidate[3];
            f.ec.channelConfig = EncodingConfiguration.ChannelConfig.MID_SIDE;
            encodeResult = f.encodeIndependent(midSideSamples, count, start, skip, data, offset);
        } else if (choice == 2) {
            f.testConstant = constantCandidate[0] || constantCandidate[3];
            f.ec.channelConfig = EncodingConfiguration.ChannelConfig.LEFT_SIDE;
            for (int i4 = 0; i4 < count; ++i4) {
                midSideSamples[2 * i4] = samples[2 * i4];
            }
            encodeResult = f.encodeIndependent(midSideSamples, count, start, skip, data, offset);
        } else {
            f.testConstant = constantCandidate[1] || constantCandidate[3];
            f.ec.channelConfig = EncodingConfiguration.ChannelConfig.RIGHT_SIDE;
            for (int i5 = 0; i5 < count; ++i5) {
                midSideSamples[2 * i5] = midSideSamples[2 * i5 + 1];
                midSideSamples[2 * i5 + 1] = samples[2 * i5 + 1];
            }
            encodeResult = f.encodeIndependent(midSideSamples, count, start, skip, data, offset);
        }
        return encodeResult;
    }
}

