/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.javaflacencoder;

import java.util.concurrent.locks.ReentrantLock;
import net.sourceforge.javaflacencoder.BlockEncodeRequest;
import net.sourceforge.javaflacencoder.BlockThreadManager;
import net.sourceforge.javaflacencoder.Frame;

public class FrameThread
implements Runnable {
    Frame frame = null;
    ReentrantLock runLock = null;
    BlockThreadManager manager = null;

    private FrameThread() {
    }

    public FrameThread(Frame f, BlockThreadManager manager) {
        if (f == null) {
            System.err.println("Frame is null. Error.");
        }
        this.frame = f;
        this.runLock = new ReentrantLock();
        this.manager = manager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        boolean process = true;
        FrameThread frameThread = this;
        synchronized (frameThread) {
            BlockEncodeRequest ber = this.manager.getWaitingRequest();
            if (ber != null && ber.frameNumber < 0L) {
                ber = null;
            }
            while (ber != null && process) {
                if (ber.frameNumber < 0L) {
                    process = false;
                    continue;
                }
                ber.encodedSamples = this.frame.encodeSamples(ber.samples, ber.count, ber.start, ber.skip, ber.result, ber.frameNumber);
                ber.valid = true;
                this.manager.returnFinishedRequest(ber);
                ber = this.manager.getWaitingRequest();
            }
            this.manager.notifyFrameThreadExit(this);
        }
    }
}

