/*
 * Decompiled with CFR 0.152.
 */
package org.bbottema.javareflection;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bbottema.javareflection.LookupCaches;
import org.bbottema.javareflection.model.LookupMode;
import org.bbottema.javareflection.util.ArrayKey;
import org.bbottema.javareflection.valueconverter.ValueConversionHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TypeUtils {
    private static final Map<Class<?>, Integer> numSizes = new LinkedHashMap();

    @NotNull
    public static Class<?>[] collectTypes(Object[] objects) {
        Class[] types = new Class[objects.length];
        for (int i = 0; i < objects.length; ++i) {
            Object o = objects[i];
            types[i] = o != null ? o.getClass() : null;
        }
        return types;
    }

    public static boolean isTypeListCompatible(Class<?>[] inputTypeList, Class<?>[] targetTypeList, Set<LookupMode> lookupMode) {
        List<Class<?>[]> derivableTypeLists = TypeUtils.generateCompatibleTypeLists(lookupMode, inputTypeList);
        for (Class<?>[] derivableTypeList : derivableTypeLists) {
            boolean currentTypeListCompatible = true;
            for (int i = 0; i < derivableTypeList.length && currentTypeListCompatible; ++i) {
                if (derivableTypeList[i] == null || derivableTypeList[i].equals(targetTypeList[i])) continue;
                currentTypeListCompatible = false;
            }
            if (!currentTypeListCompatible) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public static List<Class<?>[]> generateCompatibleTypeLists(Set<LookupMode> lookupMode, Class<?> ... inputTypelist) {
        ArrayKey arrayKey = new ArrayKey(inputTypelist);
        List<Class<?>[]> cachedResult = LookupCaches.getCachedCompatibleSignatures(lookupMode, arrayKey);
        return cachedResult != null ? cachedResult : LookupCaches.addCompatiblesignaturesToCache(lookupMode, arrayKey, TypeUtils.generateCompatibleTypeLists(0, lookupMode, new ArrayList<Class<?>[]>(), inputTypelist));
    }

    private static List<Class<?>[]> generateCompatibleTypeLists(int index, Set<LookupMode> lookupMode, List<Class<?>[]> compatibleTypeLists, Class<?> ... inputTypelist) {
        if (index == inputTypelist.length) {
            compatibleTypeLists.add(inputTypelist);
        } else {
            Class<?> original = inputTypelist[index];
            TypeUtils.generateCompatibleTypeLists(index + 1, lookupMode, compatibleTypeLists, (Class[])inputTypelist.clone());
            if (original != null) {
                Class[] newTypeList;
                Class<?>[] autoboxed;
                if (lookupMode.contains((Object)LookupMode.AUTOBOX) && !lookupMode.contains((Object)LookupMode.SMART_CONVERT) && (autoboxed = TypeUtils.autobox(original)) != null) {
                    newTypeList = (Class[])TypeUtils.replaceInArray((Object[])inputTypelist.clone(), index, autoboxed);
                    TypeUtils.generateCompatibleTypeLists(index + 1, lookupMode, compatibleTypeLists, newTypeList);
                }
                if (lookupMode.contains((Object)LookupMode.CAST_TO_INTERFACE)) {
                    for (Class<?> iface : original.getInterfaces()) {
                        Class<?>[] newTypeList2 = TypeUtils.replaceInArray((Object[])inputTypelist.clone(), index, iface);
                        TypeUtils.generateCompatibleTypeLists(index + 1, lookupMode, compatibleTypeLists, newTypeList2);
                    }
                }
                if (lookupMode.contains((Object)LookupMode.CAST_TO_SUPER)) {
                    Class<?> supertype = original;
                    while ((supertype = supertype.getSuperclass()) != null) {
                        newTypeList = TypeUtils.replaceInArray((Object[])inputTypelist.clone(), index, supertype);
                        TypeUtils.generateCompatibleTypeLists(index + 1, lookupMode, compatibleTypeLists, newTypeList);
                    }
                }
                if (lookupMode.contains((Object)LookupMode.COMMON_CONVERT) && !lookupMode.contains((Object)LookupMode.SMART_CONVERT)) {
                    for (Class<?> convert : TypeUtils.collectRegisteredCompatibleTargetTypes(original)) {
                        Class<?>[] newTypeList3 = TypeUtils.replaceInArray((Object[])inputTypelist.clone(), index, convert);
                        TypeUtils.generateCompatibleTypeLists(index + 1, lookupMode, compatibleTypeLists, newTypeList3);
                    }
                }
                if (lookupMode.contains((Object)LookupMode.SMART_CONVERT)) {
                    for (Class<?> convert : TypeUtils.collectCompatibleTargetTypes(original)) {
                        Class<?>[] newTypeList4 = TypeUtils.replaceInArray((Object[])inputTypelist.clone(), index, convert);
                        TypeUtils.generateCompatibleTypeLists(index + 1, lookupMode, compatibleTypeLists, newTypeList4);
                    }
                }
            }
        }
        return compatibleTypeLists;
    }

    @NotNull
    private static Set<Class<?>> collectRegisteredCompatibleTargetTypes(Class<?> fromType) {
        if (!LookupCaches.CACHED_REGISTERED_COMPATIBLE_TARGET_TYPES.containsKey(fromType)) {
            LookupCaches.CACHED_REGISTERED_COMPATIBLE_TARGET_TYPES.put(fromType, ValueConversionHelper.collectRegisteredCompatibleTargetTypes(fromType));
        }
        return LookupCaches.CACHED_REGISTERED_COMPATIBLE_TARGET_TYPES.get(fromType);
    }

    @NotNull
    private static Set<Class<?>> collectCompatibleTargetTypes(Class<?> fromType) {
        if (!LookupCaches.CACHED_COMPATIBLE_TARGET_TYPES.containsKey(fromType)) {
            LookupCaches.CACHED_COMPATIBLE_TARGET_TYPES.put(fromType, ValueConversionHelper.collectCompatibleTargetTypes(fromType));
        }
        return LookupCaches.CACHED_COMPATIBLE_TARGET_TYPES.get(fromType);
    }

    @Nullable
    public static Class<?> autobox(Class<?> c) {
        if (c == Integer.class) {
            return Integer.TYPE;
        }
        if (c == Integer.TYPE) {
            return Integer.class;
        }
        if (c == Boolean.class) {
            return Boolean.TYPE;
        }
        if (c == Boolean.TYPE) {
            return Boolean.class;
        }
        if (c == Character.class) {
            return Character.TYPE;
        }
        if (c == Character.TYPE) {
            return Character.class;
        }
        if (c == Byte.class) {
            return Byte.TYPE;
        }
        if (c == Byte.TYPE) {
            return Byte.class;
        }
        if (c == Short.class) {
            return Short.TYPE;
        }
        if (c == Short.TYPE) {
            return Short.class;
        }
        if (c == Long.class) {
            return Long.TYPE;
        }
        if (c == Long.TYPE) {
            return Long.class;
        }
        if (c == Float.class) {
            return Float.TYPE;
        }
        if (c == Float.TYPE) {
            return Float.class;
        }
        if (c == Double.class) {
            return Double.TYPE;
        }
        if (c == Double.TYPE) {
            return Double.class;
        }
        return null;
    }

    @NotNull
    public static Class<?> widestNumberClass(Number ... numbers) {
        Integer widest = 0;
        Class widestNumberType = Byte.class;
        for (Number number : numbers) {
            Integer size = numSizes.get(number.getClass());
            if (size <= widest) continue;
            widestNumberType = number.getClass();
            widest = size;
        }
        return widestNumberType;
    }

    public static boolean isPackage(String name) {
        return name.equals("java") || Package.getPackage(name) != null;
    }

    public static boolean containsAnnotation(List<Annotation> myListOfAnnotations, Class<? extends Annotation> annotationClass) {
        return TypeUtils.findAnnotation(myListOfAnnotations, annotationClass) != null;
    }

    public static boolean containsAnnotation(Annotation[] myListOfAnnotations, Class<? extends Annotation> annotationClass) {
        return TypeUtils.findAnnotation(myListOfAnnotations, annotationClass) != null;
    }

    @Nullable
    public static <T extends Annotation> T findAnnotation(Collection<Annotation> myListOfAnnotations, Class<T> annotationClass) {
        return TypeUtils.findAnnotation(myListOfAnnotations.toArray(new Annotation[0]), annotationClass);
    }

    @Nullable
    public static <T extends Annotation> T findAnnotation(Annotation[] myListOfAnnotations, Class<T> annotationClass) {
        for (Annotation annotation : myListOfAnnotations) {
            if (annotation.annotationType() != annotationClass) continue;
            return (T)annotation;
        }
        return null;
    }

    @NotNull
    static <T> T[] replaceInArray(T[] array, int index, T value) {
        array[index] = value;
        return array;
    }

    private TypeUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    static {
        int size = 0;
        numSizes.put(Byte.class, ++size);
        numSizes.put(Short.class, ++size);
        numSizes.put(Integer.class, ++size);
        numSizes.put(Long.class, ++size);
        numSizes.put(Float.class, ++size);
        numSizes.put(Double.class, ++size);
    }
}

