/*
 * Decompiled with CFR 0.152.
 */
package org.bbottema.javareflection.valueconverter.converters;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.bbottema.javareflection.util.Function;
import org.bbottema.javareflection.util.MiscUtil;
import org.bbottema.javareflection.valueconverter.ValueFunction;

public final class NumberConverters {
    private static final List<Class<? extends Number>> CONVERTABLE_NUMBER_FROM_CLASSES_JDK7 = MiscUtil.newArrayList(Number.class, AtomicInteger.class, AtomicLong.class, BigDecimal.class, BigInteger.class, Byte.TYPE, Byte.class, Double.TYPE, Double.class, Float.TYPE, Float.class, Integer.TYPE, Integer.class, Long.TYPE, Long.class, Short.TYPE, Short.class);
    private static final Map<Class<?>, Function<Number, ?>> CONVERTERS_BY_TARGET_TYPE = new HashMap<Class<?>, Function<Number, ?>>(){
        {
            this.put(Number.class, new NumberDoubleFunction());
            this.put(Integer.class, new NumberIntegerFunction());
            this.put(Integer.TYPE, new NumberIntegerFunction());
            this.put(Boolean.class, new NumberBooleanFunction());
            this.put(Boolean.TYPE, new NumberBooleanFunction());
            this.put(Float.class, new NumberFloatFunction());
            this.put(Float.TYPE, new NumberFloatFunction());
            this.put(Double.class, new NumberDoubleFunction());
            this.put(Double.TYPE, new NumberDoubleFunction());
            this.put(Long.class, new NumberLongFunction());
            this.put(Long.TYPE, new NumberLongFunction());
            this.put(Byte.class, new NumberByteFunction());
            this.put(Byte.TYPE, new NumberByteFunction());
            this.put(Short.class, new NumberShortFunction());
            this.put(Short.TYPE, new NumberShortFunction());
            this.put(Character.class, new NumberCharacterFunction());
            this.put(Character.TYPE, new NumberCharacterFunction());
            this.put(String.class, Function.Functions.simpleToString());
        }
    };
    public static final Collection<ValueFunction<? extends Number, ?>> NUMBER_CONVERTERS = NumberConverters.produceNumberConverters();

    private static Collection<ValueFunction<? extends Number, ?>> produceNumberConverters() {
        ArrayList valueFunctions = new ArrayList();
        for (Class<? extends Number> numberFromClass : CONVERTABLE_NUMBER_FROM_CLASSES_JDK7) {
            for (Map.Entry<Class<?>, Function<Number, ?>> targetClassConverter : CONVERTERS_BY_TARGET_TYPE.entrySet()) {
                Class<? extends Number> targetClass = targetClassConverter.getKey();
                Function converter = numberFromClass == targetClass || targetClass.isAssignableFrom(numberFromClass) ? Function.Functions.identity() : targetClassConverter.getValue();
                valueFunctions.add(new ValueFunction.ValueFunctionImpl(numberFromClass, targetClass, converter));
            }
        }
        return valueFunctions;
    }

    private NumberConverters() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    public static class NumberCharacterFunction
    implements Function<Number, Character> {
        @Override
        public Character apply(Number value) {
            return Character.valueOf(Character.forDigit(value.intValue(), 10));
        }
    }

    public static class NumberShortFunction
    implements Function<Number, Short> {
        @Override
        public Short apply(Number value) {
            return value.shortValue();
        }
    }

    public static class NumberByteFunction
    implements Function<Number, Byte> {
        @Override
        public Byte apply(Number value) {
            return value.byteValue();
        }
    }

    public static class NumberLongFunction
    implements Function<Number, Long> {
        @Override
        public Long apply(Number value) {
            return value.longValue();
        }
    }

    public static class NumberDoubleFunction
    implements Function<Number, Double> {
        @Override
        public Double apply(Number value) {
            return value.doubleValue();
        }
    }

    public static class NumberFloatFunction
    implements Function<Number, Float> {
        @Override
        public Float apply(Number value) {
            return Float.valueOf(value.floatValue());
        }
    }

    public static class NumberBooleanFunction
    implements Function<Number, Boolean> {
        @Override
        public Boolean apply(Number value) {
            return value.intValue() > 0;
        }
    }

    public static class NumberIntegerFunction
    implements Function<Number, Integer> {
        @Override
        public Integer apply(Number value) {
            return value.intValue();
        }
    }
}

