/*
 * Decompiled with CFR 0.152.
 */
package org.bbottema.javareflection.valueconverter.converters;

import java.io.File;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.UUID;
import lombok.NonNull;
import org.bbottema.javareflection.util.Function;
import org.bbottema.javareflection.util.commonslang25.NumberUtils;
import org.bbottema.javareflection.valueconverter.IncompatibleTypeException;
import org.bbottema.javareflection.valueconverter.ValueFunction;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Nullable
public final class StringConverters {
    public static final Collection<ValueFunction<String, ?>> STRING_CONVERTERS = StringConverters.produceStringConverters();

    private static Collection<ValueFunction<String, ?>> produceStringConverters() {
        ArrayList converters = new ArrayList();
        converters.add(new ValueFunction.ValueFunctionImpl<String, String>(String.class, String.class, Function.Functions.identity()));
        converters.add(new ValueFunction.ValueFunctionImpl<String, Character>(String.class, Character.class, new StringToCharacterFunction()));
        converters.add(new ValueFunction.ValueFunctionImpl<String, Boolean>(String.class, Boolean.class, new StringToBooleanFunction()));
        converters.add(new ValueFunction.ValueFunctionImpl<String, Number>(String.class, Number.class, new StringToNumberFunction()));
        converters.add(new ValueFunction.ValueFunctionImpl<String, Byte>(String.class, Byte.class, new StringToByteFunction()));
        converters.add(new ValueFunction.ValueFunctionImpl<String, Short>(String.class, Short.class, new StringToShortFunction()));
        converters.add(new ValueFunction.ValueFunctionImpl<String, Long>(String.class, Long.class, new StringToLongFunction()));
        converters.add(new ValueFunction.ValueFunctionImpl<String, Float>(String.class, Float.class, new StringToFloatFunction()));
        converters.add(new ValueFunction.ValueFunctionImpl<String, Double>(String.class, Double.class, new StringToDoubleFunction()));
        converters.add(new ValueFunction.ValueFunctionImpl<String, BigInteger>(String.class, BigInteger.class, new StringToBigIntegerFunction()));
        converters.add(new ValueFunction.ValueFunctionImpl<String, BigDecimal>(String.class, BigDecimal.class, new StringToBigDecimalFunction()));
        converters.add(new ValueFunction.ValueFunctionImpl<String, File>(String.class, File.class, new StringToFileFunction()));
        converters.add(new ValueFunction.ValueFunctionImpl<String, UUID>(String.class, UUID.class, new StringToUUIDFunction()));
        converters.add(new ValueFunction.ValueFunctionImpl<String, Date>(String.class, Date.class, new StringToDateFunction()));
        return converters;
    }

    public static <T extends Enum<T>> ValueFunction<String, T> produceStringToEnumConverter(Class<T> targetEnumClass) {
        return new ValueFunction.ValueFunctionImpl<String, T>(String.class, targetEnumClass, new StringToEnumFunction<T>(targetEnumClass));
    }

    public static <F> ValueFunction<F, String> produceTypeToStringConverter(Class<F> fromType) {
        return new ValueFunction.ValueFunctionImpl<F, String>(fromType, String.class, Function.Functions.simpleToString());
    }

    private StringConverters() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    static class StringToDateFunction
    implements Function<String, Date> {
        private static ThreadLocal<DateFormat> DATETIME_FORMAT_SIMPLE = new ThreadLocal<DateFormat>(){

            @Override
            public DateFormat initialValue() {
                return new SimpleDateFormat("yyyy-MM-dd");
            }
        };
        private static ThreadLocal<DateFormat> DATETIME_FORMAT_ISO8601 = new ThreadLocal<DateFormat>(){

            @Override
            public DateFormat initialValue() {
                return new SimpleDateFormat("yyyy-MM-dd HH:mm");
            }
        };
        private IllegalArgumentException INCOMPATIBLE_EXCEPTION = new IllegalArgumentException("not compatible with yyyy-MM-dd or yyyy-MM-dd HH:mm");

        StringToDateFunction() {
        }

        @Override
        public Date apply(String value) {
            try {
                return DATETIME_FORMAT_ISO8601.get().parse(value);
            }
            catch (IllegalArgumentException | ParseException e1) {
                try {
                    return DATETIME_FORMAT_SIMPLE.get().parse(value);
                }
                catch (IllegalArgumentException | ParseException e2) {
                    throw new IncompatibleTypeException((Object)value, String.class, Date.class, this.INCOMPATIBLE_EXCEPTION);
                }
            }
        }
    }

    private static class StringToUUIDFunction
    implements Function<String, UUID> {
        private StringToUUIDFunction() {
        }

        @Override
        public UUID apply(String value) {
            try {
                return UUID.fromString(value);
            }
            catch (IllegalArgumentException e) {
                throw new IncompatibleTypeException(value, String.class, UUID.class);
            }
        }
    }

    private static class StringToFileFunction
    implements Function<String, File> {
        private static final Logger LOGGER = LoggerFactory.getLogger(StringToBigDecimalFunction.class);

        private StringToFileFunction() {
        }

        @Override
        public File apply(String value) {
            File file = new File(value);
            if (!file.exists()) {
                LOGGER.debug("file not found for [" + value + "]");
                throw new IncompatibleTypeException(value, String.class, File.class);
            }
            return file;
        }
    }

    private static class StringToBigDecimalFunction
    implements Function<String, BigDecimal> {
        private StringToBigDecimalFunction() {
        }

        @Override
        public BigDecimal apply(String value) {
            if (NumberUtils.isNumber(value)) {
                return new BigDecimal(value);
            }
            throw new IncompatibleTypeException(value, String.class, BigDecimal.class);
        }
    }

    private static class StringToBigIntegerFunction
    implements Function<String, BigInteger> {
        private StringToBigIntegerFunction() {
        }

        @Override
        public BigInteger apply(String value) {
            if (NumberUtils.isNumber(value)) {
                return BigInteger.valueOf(Long.parseLong(value));
            }
            throw new IncompatibleTypeException(value, String.class, BigInteger.class);
        }
    }

    private static class StringToDoubleFunction
    implements Function<String, Double> {
        private StringToDoubleFunction() {
        }

        @Override
        public Double apply(String value) {
            if (NumberUtils.isNumber(value)) {
                return Double.parseDouble(value);
            }
            throw new IncompatibleTypeException(value, String.class, Double.class);
        }
    }

    private static class StringToFloatFunction
    implements Function<String, Float> {
        private StringToFloatFunction() {
        }

        @Override
        public Float apply(String value) {
            if (NumberUtils.isNumber(value)) {
                return Float.valueOf(Float.parseFloat(value));
            }
            throw new IncompatibleTypeException(value, String.class, Float.class);
        }
    }

    private static class StringToLongFunction
    implements Function<String, Long> {
        private StringToLongFunction() {
        }

        @Override
        public Long apply(String value) {
            if (NumberUtils.isNumber(value)) {
                return Long.parseLong(value);
            }
            throw new IncompatibleTypeException(value, String.class, Long.class);
        }
    }

    private static class StringToShortFunction
    implements Function<String, Short> {
        private StringToShortFunction() {
        }

        @Override
        public Short apply(String value) {
            if (NumberUtils.isNumber(value)) {
                try {
                    return Short.parseShort(value);
                }
                catch (NumberFormatException e) {
                    throw new IncompatibleTypeException((Object)value, String.class, Short.class, e);
                }
            }
            throw new IncompatibleTypeException(value, String.class, Short.class);
        }
    }

    private static class StringToByteFunction
    implements Function<String, Byte> {
        private StringToByteFunction() {
        }

        @Override
        public Byte apply(String value) {
            if (NumberUtils.isNumber(value)) {
                try {
                    return Byte.parseByte(value);
                }
                catch (NumberFormatException e) {
                    throw new IncompatibleTypeException((Object)value, String.class, Byte.class, e);
                }
            }
            throw new IncompatibleTypeException(value, String.class, Byte.class);
        }
    }

    private static class StringToNumberFunction
    implements Function<String, Number> {
        private StringToNumberFunction() {
        }

        @Override
        public Number apply(String value) {
            if (NumberUtils.isNumber(value)) {
                return new BigDecimal(value);
            }
            throw new IncompatibleTypeException(value, String.class, Number.class);
        }
    }

    private static class StringToBooleanFunction
    implements Function<String, Boolean> {
        private StringToBooleanFunction() {
        }

        @Override
        public Boolean apply(String value) {
            if (value.equalsIgnoreCase("false") || value.equalsIgnoreCase("0")) {
                return false;
            }
            if (value.equalsIgnoreCase("true") || value.equalsIgnoreCase("1")) {
                return true;
            }
            throw new IncompatibleTypeException(value, String.class, Boolean.class);
        }
    }

    private static class StringToCharacterFunction
    implements Function<String, Character> {
        private StringToCharacterFunction() {
        }

        @Override
        public Character apply(String value) {
            if (value.length() == 1) {
                return Character.valueOf(value.charAt(0));
            }
            throw new IncompatibleTypeException(value, String.class, Character.class);
        }
    }

    private static class StringToEnumFunction<T extends Enum<T>>
    implements Function<String, T> {
        @NonNull
        private final Class<T> targetEnumClass;

        @Override
        public T apply(String value) {
            try {
                return Enum.valueOf(this.targetEnumClass, value);
            }
            catch (IllegalArgumentException | SecurityException e) {
                throw new IncompatibleTypeException((Object)value, String.class, this.targetEnumClass, e);
            }
        }

        public StringToEnumFunction(@NonNull Class<T> targetEnumClass) {
            if (targetEnumClass == null) {
                throw new NullPointerException("targetEnumClass is marked non-null but is null");
            }
            this.targetEnumClass = targetEnumClass;
        }
    }
}

