/*
 * Decompiled with CFR 0.152.
 */
package org.bbottema.javareflection.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class MiscUtil {
    @SafeVarargs
    public static <T> List<T> newArrayList(T ... o) {
        ArrayList l = new ArrayList();
        Collections.addAll(l, o);
        return l;
    }

    @NotNull
    public static <T> T trustedCast(Object o) {
        return (T)o;
    }

    @Nullable
    public static <T> T trustedNullableCast(@Nullable Object o) {
        return (T)o;
    }

    @NotNull
    public static <T> T requireNonNullOfType(Object o, Class<T> type) {
        if (Objects.requireNonNull(o).getClass() != type) {
            throw new AssertionError((Object)String.format("got type %s, expected type %s", o.getClass(), type));
        }
        return (T)o;
    }

    private MiscUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

