/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core;

import com.dropbox.core.util.IOUtil;
import com.dropbox.core.util.StringUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.regex.Pattern;

public class DbxSdkVersion {
    public static final String Version = DbxSdkVersion.loadVersion();
    private static final String ResourceName = "/sdk-version.txt";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String loadLineFromResource() throws LoadException {
        String string;
        InputStream in = DbxSdkVersion.class.getResourceAsStream(ResourceName);
        if (in == null) {
            throw new LoadException("Not found.");
        }
        try {
            BufferedReader bin = new BufferedReader(IOUtil.utf8Reader(in));
            String version = bin.readLine();
            if (version == null) {
                throw new LoadException("No lines.");
            }
            String secondLine = bin.readLine();
            if (secondLine != null) {
                throw new LoadException("Found more than one line.  Second line: " + StringUtil.jq(secondLine));
            }
            string = version;
        }
        catch (Throwable throwable) {
            try {
                IOUtil.closeInput(in);
                throw throwable;
            }
            catch (IOException ex) {
                throw new LoadException(ex.getMessage());
            }
        }
        IOUtil.closeInput(in);
        return string;
    }

    private static String loadVersion() {
        try {
            String version = DbxSdkVersion.loadLineFromResource();
            Pattern versionRegex = Pattern.compile("[0-9]+(?:\\.[0-9]+)*(?:-[-_A-Za-z0-9]+)?");
            if (!versionRegex.matcher(version).matches()) {
                throw new LoadException("Text doesn't follow expected pattern: " + StringUtil.jq(version));
            }
            return version;
        }
        catch (LoadException ex) {
            throw new RuntimeException("Error loading version from resource \"sdk-version.txt\": " + ex.getMessage());
        }
    }

    private static final class LoadException
    extends Exception {
        private static final long serialVersionUID = 0L;

        public LoadException(String message) {
            super(message);
        }
    }
}

