/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.files;

import com.dropbox.core.json.JsonUtil;
import com.dropbox.core.json.StructJsonDeserializer;
import com.dropbox.core.json.StructJsonSerializer;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.IOException;
import java.util.Arrays;

@JsonSerialize(using=Serializer.class)
@JsonDeserialize(using=Deserializer.class)
public class Dimensions {
    static final Serializer SERIALIZER = new Serializer();
    static final Deserializer DESERIALIZER = new Deserializer();
    protected final long height;
    protected final long width;

    public Dimensions(long height, long width) {
        this.height = height;
        this.width = width;
    }

    public long getHeight() {
        return this.height;
    }

    public long getWidth() {
        return this.width;
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.height, this.width});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj.getClass().equals(this.getClass())) {
            Dimensions other = (Dimensions)obj;
            return this.height == other.height && this.width == other.width;
        }
        return false;
    }

    public String toString() {
        return this.serialize(false);
    }

    public String toStringMultiline() {
        return this.serialize(true);
    }

    private String serialize(boolean longForm) {
        try {
            return JsonUtil.getMapper(longForm).writeValueAsString(this);
        }
        catch (JsonProcessingException ex) {
            throw new RuntimeException("Failed to serialize object", ex);
        }
    }

    static final class Deserializer
    extends StructJsonDeserializer<Dimensions> {
        private static final long serialVersionUID = 0L;

        public Deserializer() {
            super(Dimensions.class, new Class[0]);
        }

        public Deserializer(boolean unwrapping) {
            super(Dimensions.class, unwrapping, new Class[0]);
        }

        @Override
        protected JsonDeserializer<Dimensions> asUnwrapping() {
            return new Deserializer(true);
        }

        @Override
        public Dimensions deserializeFields(JsonParser _p, DeserializationContext _ctx) throws IOException, JsonParseException {
            Long height = null;
            Long width = null;
            while (_p.getCurrentToken() == JsonToken.FIELD_NAME) {
                String _field = _p.getCurrentName();
                _p.nextToken();
                if ("height".equals(_field)) {
                    height = _p.getLongValue();
                    Deserializer.assertUnsigned(_p, height);
                    _p.nextToken();
                    continue;
                }
                if ("width".equals(_field)) {
                    width = _p.getLongValue();
                    Deserializer.assertUnsigned(_p, width);
                    _p.nextToken();
                    continue;
                }
                Deserializer.skipValue(_p);
            }
            if (height == null) {
                throw new JsonParseException(_p, "Required field \"height\" is missing.");
            }
            if (width == null) {
                throw new JsonParseException(_p, "Required field \"width\" is missing.");
            }
            return new Dimensions(height, width);
        }
    }

    static final class Serializer
    extends StructJsonSerializer<Dimensions> {
        private static final long serialVersionUID = 0L;

        public Serializer() {
            super(Dimensions.class);
        }

        public Serializer(boolean unwrapping) {
            super(Dimensions.class, unwrapping);
        }

        @Override
        protected JsonSerializer<Dimensions> asUnwrapping() {
            return new Serializer(true);
        }

        @Override
        protected void serializeFields(Dimensions value, JsonGenerator g, SerializerProvider provider) throws IOException, JsonProcessingException {
            g.writeObjectField("height", value.height);
            g.writeObjectField("width", value.width);
        }
    }
}

