/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.files;

import com.dropbox.core.json.JsonUtil;
import com.dropbox.core.json.StructJsonDeserializer;
import com.dropbox.core.json.StructJsonSerializer;
import com.dropbox.core.v2.files.FolderSharingInfo;
import com.dropbox.core.v2.files.Metadata;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.IOException;
import java.util.Arrays;
import java.util.regex.Pattern;

@JsonSerialize(using=Serializer.class)
@JsonDeserialize(using=Deserializer.class)
public class FolderMetadata
extends Metadata {
    static final Serializer SERIALIZER = new Serializer();
    static final Deserializer DESERIALIZER = new Deserializer();
    protected final String id;
    protected final String sharedFolderId;
    protected final FolderSharingInfo sharingInfo;

    public FolderMetadata(String name, String pathLower, String pathDisplay, String id, String parentSharedFolderId, String sharedFolderId, FolderSharingInfo sharingInfo) {
        super(name, pathLower, pathDisplay, parentSharedFolderId);
        if (id == null) {
            throw new IllegalArgumentException("Required value for 'id' is null");
        }
        if (id.length() < 1) {
            throw new IllegalArgumentException("String 'id' is shorter than 1");
        }
        this.id = id;
        if (sharedFolderId != null && !Pattern.matches("[-_0-9a-zA-Z:]+", sharedFolderId)) {
            throw new IllegalArgumentException("String 'sharedFolderId' does not match pattern");
        }
        this.sharedFolderId = sharedFolderId;
        this.sharingInfo = sharingInfo;
    }

    public FolderMetadata(String name, String pathLower, String pathDisplay, String id) {
        this(name, pathLower, pathDisplay, id, null, null, null);
    }

    public String getId() {
        return this.id;
    }

    public String getSharedFolderId() {
        return this.sharedFolderId;
    }

    public FolderSharingInfo getSharingInfo() {
        return this.sharingInfo;
    }

    public static Builder newBuilder(String name, String pathLower, String pathDisplay, String id) {
        return new Builder(name, pathLower, pathDisplay, id);
    }

    @Override
    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.id, this.sharedFolderId, this.sharingInfo});
        hash = 31 * super.hashCode() + hash;
        return hash;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj.getClass().equals(this.getClass())) {
            FolderMetadata other = (FolderMetadata)obj;
            return !(this.name != other.name && !this.name.equals(other.name) || this.pathLower != other.pathLower && !this.pathLower.equals(other.pathLower) || this.pathDisplay != other.pathDisplay && !this.pathDisplay.equals(other.pathDisplay) || this.id != other.id && !this.id.equals(other.id) || this.parentSharedFolderId != other.parentSharedFolderId && (this.parentSharedFolderId == null || !this.parentSharedFolderId.equals(other.parentSharedFolderId)) || this.sharedFolderId != other.sharedFolderId && (this.sharedFolderId == null || !this.sharedFolderId.equals(other.sharedFolderId)) || this.sharingInfo != other.sharingInfo && (this.sharingInfo == null || !this.sharingInfo.equals(other.sharingInfo)));
        }
        return false;
    }

    @Override
    public String toString() {
        return this.serialize(false);
    }

    @Override
    public String toStringMultiline() {
        return this.serialize(true);
    }

    private String serialize(boolean longForm) {
        try {
            return JsonUtil.getMapper(longForm).writeValueAsString(this);
        }
        catch (JsonProcessingException ex) {
            throw new RuntimeException("Failed to serialize object", ex);
        }
    }

    static final class Deserializer
    extends StructJsonDeserializer<FolderMetadata> {
        private static final long serialVersionUID = 0L;

        public Deserializer() {
            super(FolderMetadata.class, new Class[0]);
        }

        public Deserializer(boolean unwrapping) {
            super(FolderMetadata.class, unwrapping, new Class[0]);
        }

        @Override
        protected JsonDeserializer<FolderMetadata> asUnwrapping() {
            return new Deserializer(true);
        }

        @Override
        public FolderMetadata deserializeFields(JsonParser _p, DeserializationContext _ctx) throws IOException, JsonParseException {
            String _subtype_tag = Deserializer.readEnumeratedSubtypeTag(_p, "folder");
            String name = null;
            String pathLower = null;
            String pathDisplay = null;
            String id = null;
            String parentSharedFolderId = null;
            String sharedFolderId = null;
            FolderSharingInfo sharingInfo = null;
            while (_p.getCurrentToken() == JsonToken.FIELD_NAME) {
                String _field = _p.getCurrentName();
                _p.nextToken();
                if ("name".equals(_field)) {
                    name = Deserializer.getStringValue(_p);
                    _p.nextToken();
                    continue;
                }
                if ("path_lower".equals(_field)) {
                    pathLower = Deserializer.getStringValue(_p);
                    _p.nextToken();
                    continue;
                }
                if ("path_display".equals(_field)) {
                    pathDisplay = Deserializer.getStringValue(_p);
                    _p.nextToken();
                    continue;
                }
                if ("id".equals(_field)) {
                    id = Deserializer.getStringValue(_p);
                    _p.nextToken();
                    continue;
                }
                if ("parent_shared_folder_id".equals(_field)) {
                    parentSharedFolderId = Deserializer.getStringValue(_p);
                    _p.nextToken();
                    continue;
                }
                if ("shared_folder_id".equals(_field)) {
                    sharedFolderId = Deserializer.getStringValue(_p);
                    _p.nextToken();
                    continue;
                }
                if ("sharing_info".equals(_field)) {
                    sharingInfo = _p.readValueAs(FolderSharingInfo.class);
                    _p.nextToken();
                    continue;
                }
                Deserializer.skipValue(_p);
            }
            if (name == null) {
                throw new JsonParseException(_p, "Required field \"name\" is missing.");
            }
            if (pathLower == null) {
                throw new JsonParseException(_p, "Required field \"path_lower\" is missing.");
            }
            if (pathDisplay == null) {
                throw new JsonParseException(_p, "Required field \"path_display\" is missing.");
            }
            if (id == null) {
                throw new JsonParseException(_p, "Required field \"id\" is missing.");
            }
            return new FolderMetadata(name, pathLower, pathDisplay, id, parentSharedFolderId, sharedFolderId, sharingInfo);
        }
    }

    static final class Serializer
    extends StructJsonSerializer<FolderMetadata> {
        private static final long serialVersionUID = 0L;

        public Serializer() {
            super(FolderMetadata.class);
        }

        public Serializer(boolean unwrapping) {
            super(FolderMetadata.class, unwrapping);
        }

        @Override
        protected void serializeFields(FolderMetadata value, JsonGenerator g, SerializerProvider provider) throws IOException, JsonProcessingException {
            g.writeStringField(".tag", "folder");
            g.writeObjectField("name", value.name);
            g.writeObjectField("path_lower", value.pathLower);
            g.writeObjectField("path_display", value.pathDisplay);
            g.writeObjectField("id", value.id);
            if (value.parentSharedFolderId != null) {
                g.writeObjectField("parent_shared_folder_id", value.parentSharedFolderId);
            }
            if (value.sharedFolderId != null) {
                g.writeObjectField("shared_folder_id", value.sharedFolderId);
            }
            if (value.sharingInfo != null) {
                g.writeObjectField("sharing_info", value.sharingInfo);
            }
        }
    }

    public static class Builder {
        protected final String name;
        protected final String pathLower;
        protected final String pathDisplay;
        protected final String id;
        protected String parentSharedFolderId;
        protected String sharedFolderId;
        protected FolderSharingInfo sharingInfo;

        protected Builder(String name, String pathLower, String pathDisplay, String id) {
            if (name == null) {
                throw new IllegalArgumentException("Required value for 'name' is null");
            }
            this.name = name;
            if (pathLower == null) {
                throw new IllegalArgumentException("Required value for 'pathLower' is null");
            }
            this.pathLower = pathLower;
            if (pathDisplay == null) {
                throw new IllegalArgumentException("Required value for 'pathDisplay' is null");
            }
            this.pathDisplay = pathDisplay;
            if (id == null) {
                throw new IllegalArgumentException("Required value for 'id' is null");
            }
            if (id.length() < 1) {
                throw new IllegalArgumentException("String 'id' is shorter than 1");
            }
            this.id = id;
            this.parentSharedFolderId = null;
            this.sharedFolderId = null;
            this.sharingInfo = null;
        }

        public Builder withParentSharedFolderId(String parentSharedFolderId) {
            if (parentSharedFolderId != null && !Pattern.matches("[-_0-9a-zA-Z:]+", parentSharedFolderId)) {
                throw new IllegalArgumentException("String 'parentSharedFolderId' does not match pattern");
            }
            this.parentSharedFolderId = parentSharedFolderId;
            return this;
        }

        public Builder withSharedFolderId(String sharedFolderId) {
            if (sharedFolderId != null && !Pattern.matches("[-_0-9a-zA-Z:]+", sharedFolderId)) {
                throw new IllegalArgumentException("String 'sharedFolderId' does not match pattern");
            }
            this.sharedFolderId = sharedFolderId;
            return this;
        }

        public Builder withSharingInfo(FolderSharingInfo sharingInfo) {
            this.sharingInfo = sharingInfo;
            return this;
        }

        public FolderMetadata build() {
            return new FolderMetadata(this.name, this.pathLower, this.pathDisplay, this.id, this.parentSharedFolderId, this.sharedFolderId, this.sharingInfo);
        }
    }
}

