/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.files;

import com.dropbox.core.json.JsonUtil;
import com.dropbox.core.json.StructJsonDeserializer;
import com.dropbox.core.json.StructJsonSerializer;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.IOException;
import java.util.Arrays;

@JsonSerialize(using=Serializer.class)
@JsonDeserialize(using=Deserializer.class)
class ListFolderLongpollArg {
    static final Serializer SERIALIZER = new Serializer();
    static final Deserializer DESERIALIZER = new Deserializer();
    protected final String cursor;
    protected final long timeout;

    public ListFolderLongpollArg(String cursor, long timeout) {
        if (cursor == null) {
            throw new IllegalArgumentException("Required value for 'cursor' is null");
        }
        if (cursor.length() < 1) {
            throw new IllegalArgumentException("String 'cursor' is shorter than 1");
        }
        this.cursor = cursor;
        if (timeout < 30L) {
            throw new IllegalArgumentException("Number 'timeout' is smaller than 30L");
        }
        if (timeout > 480L) {
            throw new IllegalArgumentException("Number 'timeout' is larger than 480L");
        }
        this.timeout = timeout;
    }

    public ListFolderLongpollArg(String cursor) {
        this(cursor, 30L);
    }

    public String getCursor() {
        return this.cursor;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.cursor, this.timeout});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj.getClass().equals(this.getClass())) {
            ListFolderLongpollArg other = (ListFolderLongpollArg)obj;
            return (this.cursor == other.cursor || this.cursor.equals(other.cursor)) && this.timeout == other.timeout;
        }
        return false;
    }

    public String toString() {
        return this.serialize(false);
    }

    public String toStringMultiline() {
        return this.serialize(true);
    }

    private String serialize(boolean longForm) {
        try {
            return JsonUtil.getMapper(longForm).writeValueAsString(this);
        }
        catch (JsonProcessingException ex) {
            throw new RuntimeException("Failed to serialize object", ex);
        }
    }

    static final class Deserializer
    extends StructJsonDeserializer<ListFolderLongpollArg> {
        private static final long serialVersionUID = 0L;

        public Deserializer() {
            super(ListFolderLongpollArg.class, new Class[0]);
        }

        public Deserializer(boolean unwrapping) {
            super(ListFolderLongpollArg.class, unwrapping, new Class[0]);
        }

        @Override
        protected JsonDeserializer<ListFolderLongpollArg> asUnwrapping() {
            return new Deserializer(true);
        }

        @Override
        public ListFolderLongpollArg deserializeFields(JsonParser _p, DeserializationContext _ctx) throws IOException, JsonParseException {
            String cursor = null;
            Long timeout = null;
            while (_p.getCurrentToken() == JsonToken.FIELD_NAME) {
                String _field = _p.getCurrentName();
                _p.nextToken();
                if ("cursor".equals(_field)) {
                    cursor = Deserializer.getStringValue(_p);
                    _p.nextToken();
                    continue;
                }
                if ("timeout".equals(_field)) {
                    timeout = _p.getLongValue();
                    Deserializer.assertUnsigned(_p, timeout);
                    _p.nextToken();
                    continue;
                }
                Deserializer.skipValue(_p);
            }
            if (cursor == null) {
                throw new JsonParseException(_p, "Required field \"cursor\" is missing.");
            }
            return new ListFolderLongpollArg(cursor, timeout);
        }
    }

    static final class Serializer
    extends StructJsonSerializer<ListFolderLongpollArg> {
        private static final long serialVersionUID = 0L;

        public Serializer() {
            super(ListFolderLongpollArg.class);
        }

        public Serializer(boolean unwrapping) {
            super(ListFolderLongpollArg.class, unwrapping);
        }

        @Override
        protected JsonSerializer<ListFolderLongpollArg> asUnwrapping() {
            return new Serializer(true);
        }

        @Override
        protected void serializeFields(ListFolderLongpollArg value, JsonGenerator g, SerializerProvider provider) throws IOException, JsonProcessingException {
            g.writeObjectField("cursor", value.cursor);
            g.writeObjectField("timeout", value.timeout);
        }
    }
}

