/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.files;

import com.dropbox.core.json.JsonUtil;
import com.dropbox.core.json.StructJsonDeserializer;
import com.dropbox.core.json.StructJsonSerializer;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.IOException;
import java.util.Arrays;
import java.util.regex.Pattern;

@JsonSerialize(using=Serializer.class)
@JsonDeserialize(using=Deserializer.class)
class ListRevisionsArg {
    static final Serializer SERIALIZER = new Serializer();
    static final Deserializer DESERIALIZER = new Deserializer();
    protected final String path;
    protected final long limit;

    public ListRevisionsArg(String path, long limit) {
        if (path == null) {
            throw new IllegalArgumentException("Required value for 'path' is null");
        }
        if (!Pattern.matches("/.*", path)) {
            throw new IllegalArgumentException("String 'path' does not match pattern");
        }
        this.path = path;
        if (limit < 1L) {
            throw new IllegalArgumentException("Number 'limit' is smaller than 1L");
        }
        if (limit > 100L) {
            throw new IllegalArgumentException("Number 'limit' is larger than 100L");
        }
        this.limit = limit;
    }

    public ListRevisionsArg(String path) {
        this(path, 10L);
    }

    public String getPath() {
        return this.path;
    }

    public long getLimit() {
        return this.limit;
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.path, this.limit});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj.getClass().equals(this.getClass())) {
            ListRevisionsArg other = (ListRevisionsArg)obj;
            return (this.path == other.path || this.path.equals(other.path)) && this.limit == other.limit;
        }
        return false;
    }

    public String toString() {
        return this.serialize(false);
    }

    public String toStringMultiline() {
        return this.serialize(true);
    }

    private String serialize(boolean longForm) {
        try {
            return JsonUtil.getMapper(longForm).writeValueAsString(this);
        }
        catch (JsonProcessingException ex) {
            throw new RuntimeException("Failed to serialize object", ex);
        }
    }

    static final class Deserializer
    extends StructJsonDeserializer<ListRevisionsArg> {
        private static final long serialVersionUID = 0L;

        public Deserializer() {
            super(ListRevisionsArg.class, new Class[0]);
        }

        public Deserializer(boolean unwrapping) {
            super(ListRevisionsArg.class, unwrapping, new Class[0]);
        }

        @Override
        protected JsonDeserializer<ListRevisionsArg> asUnwrapping() {
            return new Deserializer(true);
        }

        @Override
        public ListRevisionsArg deserializeFields(JsonParser _p, DeserializationContext _ctx) throws IOException, JsonParseException {
            String path = null;
            Long limit = null;
            while (_p.getCurrentToken() == JsonToken.FIELD_NAME) {
                String _field = _p.getCurrentName();
                _p.nextToken();
                if ("path".equals(_field)) {
                    path = Deserializer.getStringValue(_p);
                    _p.nextToken();
                    continue;
                }
                if ("limit".equals(_field)) {
                    limit = _p.getLongValue();
                    Deserializer.assertUnsigned(_p, limit);
                    _p.nextToken();
                    continue;
                }
                Deserializer.skipValue(_p);
            }
            if (path == null) {
                throw new JsonParseException(_p, "Required field \"path\" is missing.");
            }
            return new ListRevisionsArg(path, limit);
        }
    }

    static final class Serializer
    extends StructJsonSerializer<ListRevisionsArg> {
        private static final long serialVersionUID = 0L;

        public Serializer() {
            super(ListRevisionsArg.class);
        }

        public Serializer(boolean unwrapping) {
            super(ListRevisionsArg.class, unwrapping);
        }

        @Override
        protected JsonSerializer<ListRevisionsArg> asUnwrapping() {
            return new Serializer(true);
        }

        @Override
        protected void serializeFields(ListRevisionsArg value, JsonGenerator g, SerializerProvider provider) throws IOException, JsonProcessingException {
            g.writeObjectField("path", value.path);
            g.writeObjectField("limit", value.limit);
        }
    }
}

