/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.files;

import com.dropbox.core.json.JsonUtil;
import com.dropbox.core.json.StructJsonDeserializer;
import com.dropbox.core.json.StructJsonSerializer;
import com.dropbox.core.v2.files.DeletedMetadata;
import com.dropbox.core.v2.files.FileMetadata;
import com.dropbox.core.v2.files.FolderMetadata;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.IOException;
import java.util.Arrays;
import java.util.regex.Pattern;

@JsonSerialize(using=Serializer.class)
@JsonDeserialize(using=Deserializer.class)
public class Metadata {
    static final Serializer SERIALIZER = new Serializer();
    static final Deserializer DESERIALIZER = new Deserializer();
    protected final String name;
    protected final String pathLower;
    protected final String pathDisplay;
    protected final String parentSharedFolderId;

    public Metadata(String name, String pathLower, String pathDisplay, String parentSharedFolderId) {
        if (name == null) {
            throw new IllegalArgumentException("Required value for 'name' is null");
        }
        this.name = name;
        if (pathLower == null) {
            throw new IllegalArgumentException("Required value for 'pathLower' is null");
        }
        this.pathLower = pathLower;
        if (pathDisplay == null) {
            throw new IllegalArgumentException("Required value for 'pathDisplay' is null");
        }
        this.pathDisplay = pathDisplay;
        if (parentSharedFolderId != null && !Pattern.matches("[-_0-9a-zA-Z:]+", parentSharedFolderId)) {
            throw new IllegalArgumentException("String 'parentSharedFolderId' does not match pattern");
        }
        this.parentSharedFolderId = parentSharedFolderId;
    }

    public Metadata(String name, String pathLower, String pathDisplay) {
        this(name, pathLower, pathDisplay, null);
    }

    public String getName() {
        return this.name;
    }

    public String getPathLower() {
        return this.pathLower;
    }

    public String getPathDisplay() {
        return this.pathDisplay;
    }

    public String getParentSharedFolderId() {
        return this.parentSharedFolderId;
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.name, this.pathLower, this.pathDisplay, this.parentSharedFolderId});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj.getClass().equals(this.getClass())) {
            Metadata other = (Metadata)obj;
            return !(this.name != other.name && !this.name.equals(other.name) || this.pathLower != other.pathLower && !this.pathLower.equals(other.pathLower) || this.pathDisplay != other.pathDisplay && !this.pathDisplay.equals(other.pathDisplay) || this.parentSharedFolderId != other.parentSharedFolderId && (this.parentSharedFolderId == null || !this.parentSharedFolderId.equals(other.parentSharedFolderId)));
        }
        return false;
    }

    public String toString() {
        return this.serialize(false);
    }

    public String toStringMultiline() {
        return this.serialize(true);
    }

    private String serialize(boolean longForm) {
        try {
            return JsonUtil.getMapper(longForm).writeValueAsString(this);
        }
        catch (JsonProcessingException ex) {
            throw new RuntimeException("Failed to serialize object", ex);
        }
    }

    static final class Deserializer
    extends StructJsonDeserializer<Metadata> {
        private static final long serialVersionUID = 0L;

        public Deserializer() {
            super(Metadata.class, FileMetadata.class, FolderMetadata.class, DeletedMetadata.class);
        }

        public Deserializer(boolean unwrapping) {
            super(Metadata.class, unwrapping, FileMetadata.class, FolderMetadata.class, DeletedMetadata.class);
        }

        @Override
        protected JsonDeserializer<Metadata> asUnwrapping() {
            return new Deserializer(true);
        }

        @Override
        public Metadata deserializeFields(JsonParser _p, DeserializationContext _ctx) throws IOException, JsonParseException {
            String _subtype_tag = Deserializer.readEnumeratedSubtypeTag(_p, new String[0]);
            if ("file".equals(_subtype_tag)) {
                return this.readCollapsedStructValue(FileMetadata.class, _p, _ctx);
            }
            if ("folder".equals(_subtype_tag)) {
                return this.readCollapsedStructValue(FolderMetadata.class, _p, _ctx);
            }
            if ("deleted".equals(_subtype_tag)) {
                return this.readCollapsedStructValue(DeletedMetadata.class, _p, _ctx);
            }
            String name = null;
            String pathLower = null;
            String pathDisplay = null;
            String parentSharedFolderId = null;
            while (_p.getCurrentToken() == JsonToken.FIELD_NAME) {
                String _field = _p.getCurrentName();
                _p.nextToken();
                if ("name".equals(_field)) {
                    name = Deserializer.getStringValue(_p);
                    _p.nextToken();
                    continue;
                }
                if ("path_lower".equals(_field)) {
                    pathLower = Deserializer.getStringValue(_p);
                    _p.nextToken();
                    continue;
                }
                if ("path_display".equals(_field)) {
                    pathDisplay = Deserializer.getStringValue(_p);
                    _p.nextToken();
                    continue;
                }
                if ("parent_shared_folder_id".equals(_field)) {
                    parentSharedFolderId = Deserializer.getStringValue(_p);
                    _p.nextToken();
                    continue;
                }
                Deserializer.skipValue(_p);
            }
            if (name == null) {
                throw new JsonParseException(_p, "Required field \"name\" is missing.");
            }
            if (pathLower == null) {
                throw new JsonParseException(_p, "Required field \"path_lower\" is missing.");
            }
            if (pathDisplay == null) {
                throw new JsonParseException(_p, "Required field \"path_display\" is missing.");
            }
            return new Metadata(name, pathLower, pathDisplay, parentSharedFolderId);
        }
    }

    static final class Serializer
    extends StructJsonSerializer<Metadata> {
        private static final long serialVersionUID = 0L;

        public Serializer() {
            super(Metadata.class);
        }

        public Serializer(boolean unwrapping) {
            super(Metadata.class, unwrapping);
        }

        @Override
        protected void serializeFields(Metadata value, JsonGenerator g, SerializerProvider provider) throws IOException, JsonProcessingException {
            g.writeObjectField("name", value.name);
            g.writeObjectField("path_lower", value.pathLower);
            g.writeObjectField("path_display", value.pathDisplay);
            if (value.parentSharedFolderId != null) {
                g.writeObjectField("parent_shared_folder_id", value.parentSharedFolderId);
            }
        }
    }
}

