/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.files;

import com.dropbox.core.json.JsonUtil;
import com.dropbox.core.json.StructJsonDeserializer;
import com.dropbox.core.json.StructJsonSerializer;
import com.dropbox.core.v2.files.SearchMode;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.IOException;
import java.util.Arrays;
import java.util.regex.Pattern;

@JsonSerialize(using=Serializer.class)
@JsonDeserialize(using=Deserializer.class)
class SearchArg {
    static final Serializer SERIALIZER = new Serializer();
    static final Deserializer DESERIALIZER = new Deserializer();
    protected final String path;
    protected final String query;
    protected final long start;
    protected final long maxResults;
    protected final SearchMode mode;

    public SearchArg(String path, String query, long start, long maxResults, SearchMode mode) {
        if (path == null) {
            throw new IllegalArgumentException("Required value for 'path' is null");
        }
        if (!Pattern.matches("(/.*)?", path)) {
            throw new IllegalArgumentException("String 'path' does not match pattern");
        }
        this.path = path;
        if (query == null) {
            throw new IllegalArgumentException("Required value for 'query' is null");
        }
        this.query = query;
        this.start = start;
        if (maxResults < 1L) {
            throw new IllegalArgumentException("Number 'maxResults' is smaller than 1L");
        }
        if (maxResults > 1000L) {
            throw new IllegalArgumentException("Number 'maxResults' is larger than 1000L");
        }
        this.maxResults = maxResults;
        if (mode == null) {
            throw new IllegalArgumentException("Required value for 'mode' is null");
        }
        this.mode = mode;
    }

    public SearchArg(String path, String query) {
        this(path, query, 0L, 100L, SearchMode.FILENAME);
    }

    public String getPath() {
        return this.path;
    }

    public String getQuery() {
        return this.query;
    }

    public long getStart() {
        return this.start;
    }

    public long getMaxResults() {
        return this.maxResults;
    }

    public SearchMode getMode() {
        return this.mode;
    }

    public static Builder newBuilder(String path, String query) {
        return new Builder(path, query);
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.path, this.query, this.start, this.maxResults, this.mode});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj.getClass().equals(this.getClass())) {
            SearchArg other = (SearchArg)obj;
            return !(this.path != other.path && !this.path.equals(other.path) || this.query != other.query && !this.query.equals(other.query) || this.start != other.start || this.maxResults != other.maxResults || this.mode != other.mode && !this.mode.equals((Object)other.mode));
        }
        return false;
    }

    public String toString() {
        return this.serialize(false);
    }

    public String toStringMultiline() {
        return this.serialize(true);
    }

    private String serialize(boolean longForm) {
        try {
            return JsonUtil.getMapper(longForm).writeValueAsString(this);
        }
        catch (JsonProcessingException ex) {
            throw new RuntimeException("Failed to serialize object", ex);
        }
    }

    static final class Deserializer
    extends StructJsonDeserializer<SearchArg> {
        private static final long serialVersionUID = 0L;

        public Deserializer() {
            super(SearchArg.class, new Class[0]);
        }

        public Deserializer(boolean unwrapping) {
            super(SearchArg.class, unwrapping, new Class[0]);
        }

        @Override
        protected JsonDeserializer<SearchArg> asUnwrapping() {
            return new Deserializer(true);
        }

        @Override
        public SearchArg deserializeFields(JsonParser _p, DeserializationContext _ctx) throws IOException, JsonParseException {
            String path = null;
            String query = null;
            Long start = null;
            Long maxResults = null;
            SearchMode mode = null;
            while (_p.getCurrentToken() == JsonToken.FIELD_NAME) {
                String _field = _p.getCurrentName();
                _p.nextToken();
                if ("path".equals(_field)) {
                    path = Deserializer.getStringValue(_p);
                    _p.nextToken();
                    continue;
                }
                if ("query".equals(_field)) {
                    query = Deserializer.getStringValue(_p);
                    _p.nextToken();
                    continue;
                }
                if ("start".equals(_field)) {
                    start = _p.getLongValue();
                    Deserializer.assertUnsigned(_p, start);
                    _p.nextToken();
                    continue;
                }
                if ("max_results".equals(_field)) {
                    maxResults = _p.getLongValue();
                    Deserializer.assertUnsigned(_p, maxResults);
                    _p.nextToken();
                    continue;
                }
                if ("mode".equals(_field)) {
                    mode = _p.readValueAs(SearchMode.class);
                    _p.nextToken();
                    continue;
                }
                Deserializer.skipValue(_p);
            }
            if (path == null) {
                throw new JsonParseException(_p, "Required field \"path\" is missing.");
            }
            if (query == null) {
                throw new JsonParseException(_p, "Required field \"query\" is missing.");
            }
            return new SearchArg(path, query, start, maxResults, mode);
        }
    }

    static final class Serializer
    extends StructJsonSerializer<SearchArg> {
        private static final long serialVersionUID = 0L;

        public Serializer() {
            super(SearchArg.class);
        }

        public Serializer(boolean unwrapping) {
            super(SearchArg.class, unwrapping);
        }

        @Override
        protected JsonSerializer<SearchArg> asUnwrapping() {
            return new Serializer(true);
        }

        @Override
        protected void serializeFields(SearchArg value, JsonGenerator g, SerializerProvider provider) throws IOException, JsonProcessingException {
            g.writeObjectField("path", value.path);
            g.writeObjectField("query", value.query);
            g.writeObjectField("start", value.start);
            g.writeObjectField("max_results", value.maxResults);
            g.writeObjectField("mode", (Object)value.mode);
        }
    }

    public static class Builder {
        protected final String path;
        protected final String query;
        protected long start;
        protected long maxResults;
        protected SearchMode mode;

        protected Builder(String path, String query) {
            if (path == null) {
                throw new IllegalArgumentException("Required value for 'path' is null");
            }
            if (!Pattern.matches("(/.*)?", path)) {
                throw new IllegalArgumentException("String 'path' does not match pattern");
            }
            this.path = path;
            if (query == null) {
                throw new IllegalArgumentException("Required value for 'query' is null");
            }
            this.query = query;
            this.start = 0L;
            this.maxResults = 100L;
            this.mode = SearchMode.FILENAME;
        }

        public Builder withStart(Long start) {
            this.start = start != null ? start : 0L;
            return this;
        }

        public Builder withMaxResults(Long maxResults) {
            if (maxResults < 1L) {
                throw new IllegalArgumentException("Number 'maxResults' is smaller than 1L");
            }
            if (maxResults > 1000L) {
                throw new IllegalArgumentException("Number 'maxResults' is larger than 1000L");
            }
            this.maxResults = maxResults != null ? maxResults : 100L;
            return this;
        }

        public Builder withMode(SearchMode mode) {
            this.mode = mode != null ? mode : SearchMode.FILENAME;
            return this;
        }

        public SearchArg build() {
            return new SearchArg(this.path, this.query, this.start, this.maxResults, this.mode);
        }
    }
}

