/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.files;

import com.dropbox.core.DbxException;
import com.dropbox.core.v2.files.DbxUserFilesRequests;
import com.dropbox.core.v2.files.SearchArg;
import com.dropbox.core.v2.files.SearchErrorException;
import com.dropbox.core.v2.files.SearchMode;
import com.dropbox.core.v2.files.SearchResult;

public class SearchBuilder {
    private final DbxUserFilesRequests files;
    private final SearchArg.Builder searchArgBuilder;

    SearchBuilder(DbxUserFilesRequests files, SearchArg.Builder searchArgBuilder) {
        if (files == null) {
            throw new NullPointerException("files");
        }
        if (searchArgBuilder == null) {
            throw new NullPointerException("searchArgBuilder");
        }
        this.files = files;
        this.searchArgBuilder = searchArgBuilder;
    }

    public SearchBuilder withStart(Long start) {
        this.searchArgBuilder.withStart(start);
        return this;
    }

    public SearchBuilder withMaxResults(Long maxResults) {
        this.searchArgBuilder.withMaxResults(maxResults);
        return this;
    }

    public SearchBuilder withMode(SearchMode mode) {
        this.searchArgBuilder.withMode(mode);
        return this;
    }

    public SearchResult start() throws SearchErrorException, DbxException {
        SearchArg arg = this.searchArgBuilder.build();
        return this.files.search(arg);
    }
}

