/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.files;

import com.dropbox.core.json.JsonUtil;
import com.dropbox.core.json.UnionJsonDeserializer;
import com.dropbox.core.json.UnionJsonSerializer;
import com.dropbox.core.v2.files.LookupError;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

@JsonSerialize(using=Serializer.class)
@JsonDeserialize(using=Deserializer.class)
public final class ThumbnailError {
    static final Serializer SERIALIZER = new Serializer();
    static final Deserializer DESERIALIZER = new Deserializer();
    public static final ThumbnailError UNSUPPORTED_EXTENSION = new ThumbnailError(Tag.UNSUPPORTED_EXTENSION, null);
    public static final ThumbnailError UNSUPPORTED_IMAGE = new ThumbnailError(Tag.UNSUPPORTED_IMAGE, null);
    public static final ThumbnailError CONVERSION_ERROR = new ThumbnailError(Tag.CONVERSION_ERROR, null);
    private final Tag tag;
    private final LookupError pathValue;

    private ThumbnailError(Tag tag, LookupError pathValue) {
        this.tag = tag;
        this.pathValue = pathValue;
    }

    public Tag tag() {
        return this.tag;
    }

    public boolean isPath() {
        return this.tag == Tag.PATH;
    }

    public static ThumbnailError path(LookupError value) {
        if (value == null) {
            throw new IllegalArgumentException("Value is null");
        }
        return new ThumbnailError(Tag.PATH, value);
    }

    public LookupError getPathValue() {
        if (this.tag != Tag.PATH) {
            throw new IllegalStateException("Invalid tag: required Tag.PATH, but was Tag." + this.tag.name());
        }
        return this.pathValue;
    }

    public boolean isUnsupportedExtension() {
        return this.tag == Tag.UNSUPPORTED_EXTENSION;
    }

    public boolean isUnsupportedImage() {
        return this.tag == Tag.UNSUPPORTED_IMAGE;
    }

    public boolean isConversionError() {
        return this.tag == Tag.CONVERSION_ERROR;
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.tag, this.pathValue});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof ThumbnailError) {
            ThumbnailError other = (ThumbnailError)obj;
            if (this.tag != other.tag) {
                return false;
            }
            switch (this.tag) {
                case PATH: {
                    return this.pathValue == other.pathValue || this.pathValue.equals(other.pathValue);
                }
                case UNSUPPORTED_EXTENSION: {
                    return true;
                }
                case UNSUPPORTED_IMAGE: {
                    return true;
                }
                case CONVERSION_ERROR: {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    public String toString() {
        return this.serialize(false);
    }

    public String toStringMultiline() {
        return this.serialize(true);
    }

    private String serialize(boolean longForm) {
        try {
            return JsonUtil.getMapper(longForm).writeValueAsString(this);
        }
        catch (JsonProcessingException ex) {
            throw new RuntimeException("Failed to serialize object", ex);
        }
    }

    static final class Deserializer
    extends UnionJsonDeserializer<ThumbnailError, Tag> {
        private static final long serialVersionUID = 0L;

        public Deserializer() {
            super(ThumbnailError.class, Deserializer.getTagMapping(), null, new Class[0]);
        }

        @Override
        public ThumbnailError deserialize(Tag _tag, JsonParser _p, DeserializationContext _ctx) throws IOException, JsonParseException {
            switch (_tag) {
                case PATH: {
                    LookupError value = null;
                    Deserializer.expectField(_p, "path");
                    value = _p.readValueAs(LookupError.class);
                    _p.nextToken();
                    return ThumbnailError.path(value);
                }
                case UNSUPPORTED_EXTENSION: {
                    return UNSUPPORTED_EXTENSION;
                }
                case UNSUPPORTED_IMAGE: {
                    return UNSUPPORTED_IMAGE;
                }
                case CONVERSION_ERROR: {
                    return CONVERSION_ERROR;
                }
            }
            throw new IllegalStateException("Unparsed tag: \"" + (Object)((Object)_tag) + "\"");
        }

        private static Map<String, Tag> getTagMapping() {
            HashMap<String, Tag> values = new HashMap<String, Tag>();
            values.put("path", Tag.PATH);
            values.put("unsupported_extension", Tag.UNSUPPORTED_EXTENSION);
            values.put("unsupported_image", Tag.UNSUPPORTED_IMAGE);
            values.put("conversion_error", Tag.CONVERSION_ERROR);
            return Collections.unmodifiableMap(values);
        }
    }

    static final class Serializer
    extends UnionJsonSerializer<ThumbnailError> {
        private static final long serialVersionUID = 0L;

        public Serializer() {
            super(ThumbnailError.class, new Class[0]);
        }

        @Override
        public void serialize(ThumbnailError value, JsonGenerator g, SerializerProvider provider) throws IOException, JsonProcessingException {
            switch (value.tag) {
                case PATH: {
                    g.writeStartObject();
                    g.writeStringField(".tag", "path");
                    g.writeObjectField("path", value.pathValue);
                    g.writeEndObject();
                    break;
                }
                case UNSUPPORTED_EXTENSION: {
                    g.writeString("unsupported_extension");
                    break;
                }
                case UNSUPPORTED_IMAGE: {
                    g.writeString("unsupported_image");
                    break;
                }
                case CONVERSION_ERROR: {
                    g.writeString("conversion_error");
                }
            }
        }
    }

    public static enum Tag {
        PATH,
        UNSUPPORTED_EXTENSION,
        UNSUPPORTED_IMAGE,
        CONVERSION_ERROR;

    }
}

