/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.files;

import com.dropbox.core.json.JsonUtil;
import com.dropbox.core.json.UnionJsonDeserializer;
import com.dropbox.core.json.UnionJsonSerializer;
import com.dropbox.core.v2.files.UploadWriteFailed;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

@JsonSerialize(using=Serializer.class)
@JsonDeserialize(using=Deserializer.class)
public final class UploadError {
    static final Serializer SERIALIZER = new Serializer();
    static final Deserializer DESERIALIZER = new Deserializer();
    public static final UploadError OTHER = new UploadError(Tag.OTHER, null);
    private final Tag tag;
    private final UploadWriteFailed pathValue;

    private UploadError(Tag tag, UploadWriteFailed pathValue) {
        this.tag = tag;
        this.pathValue = pathValue;
    }

    public Tag tag() {
        return this.tag;
    }

    public boolean isPath() {
        return this.tag == Tag.PATH;
    }

    public static UploadError path(UploadWriteFailed value) {
        if (value == null) {
            throw new IllegalArgumentException("Value is null");
        }
        return new UploadError(Tag.PATH, value);
    }

    public UploadWriteFailed getPathValue() {
        if (this.tag != Tag.PATH) {
            throw new IllegalStateException("Invalid tag: required Tag.PATH, but was Tag." + this.tag.name());
        }
        return this.pathValue;
    }

    public boolean isOther() {
        return this.tag == Tag.OTHER;
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.tag, this.pathValue});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof UploadError) {
            UploadError other = (UploadError)obj;
            if (this.tag != other.tag) {
                return false;
            }
            switch (this.tag) {
                case PATH: {
                    return this.pathValue == other.pathValue || this.pathValue.equals(other.pathValue);
                }
                case OTHER: {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    public String toString() {
        return this.serialize(false);
    }

    public String toStringMultiline() {
        return this.serialize(true);
    }

    private String serialize(boolean longForm) {
        try {
            return JsonUtil.getMapper(longForm).writeValueAsString(this);
        }
        catch (JsonProcessingException ex) {
            throw new RuntimeException("Failed to serialize object", ex);
        }
    }

    static final class Deserializer
    extends UnionJsonDeserializer<UploadError, Tag> {
        private static final long serialVersionUID = 0L;

        public Deserializer() {
            super(UploadError.class, Deserializer.getTagMapping(), Tag.OTHER, UploadWriteFailed.class);
        }

        @Override
        public UploadError deserialize(Tag _tag, JsonParser _p, DeserializationContext _ctx) throws IOException, JsonParseException {
            switch (_tag) {
                case PATH: {
                    UploadWriteFailed value = null;
                    value = this.readCollapsedStructValue(UploadWriteFailed.class, _p, _ctx);
                    return UploadError.path(value);
                }
                case OTHER: {
                    return OTHER;
                }
            }
            throw new IllegalStateException("Unparsed tag: \"" + (Object)((Object)_tag) + "\"");
        }

        private static Map<String, Tag> getTagMapping() {
            HashMap<String, Tag> values = new HashMap<String, Tag>();
            values.put("path", Tag.PATH);
            values.put("other", Tag.OTHER);
            return Collections.unmodifiableMap(values);
        }
    }

    static final class Serializer
    extends UnionJsonSerializer<UploadError> {
        private static final long serialVersionUID = 0L;

        public Serializer() {
            super(UploadError.class, UploadWriteFailed.class);
        }

        @Override
        public void serialize(UploadError value, JsonGenerator g, SerializerProvider provider) throws IOException, JsonProcessingException {
            switch (value.tag) {
                case PATH: {
                    g.writeStartObject();
                    g.writeStringField(".tag", "path");
                    this.getUnwrappingSerializer(UploadWriteFailed.class).serialize(value.pathValue, g, provider);
                    g.writeEndObject();
                    break;
                }
                case OTHER: {
                    g.writeString("other");
                }
            }
        }
    }

    public static enum Tag {
        PATH,
        OTHER;

    }
}

