/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.files;

import com.dropbox.core.json.JsonUtil;
import com.dropbox.core.json.StructJsonDeserializer;
import com.dropbox.core.json.StructJsonSerializer;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.IOException;
import java.util.Arrays;

@JsonSerialize(using=Serializer.class)
@JsonDeserialize(using=Deserializer.class)
public class UploadSessionCursor {
    static final Serializer SERIALIZER = new Serializer();
    static final Deserializer DESERIALIZER = new Deserializer();
    protected final String sessionId;
    protected final long offset;

    public UploadSessionCursor(String sessionId, long offset) {
        if (sessionId == null) {
            throw new IllegalArgumentException("Required value for 'sessionId' is null");
        }
        this.sessionId = sessionId;
        this.offset = offset;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public long getOffset() {
        return this.offset;
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.sessionId, this.offset});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj.getClass().equals(this.getClass())) {
            UploadSessionCursor other = (UploadSessionCursor)obj;
            return (this.sessionId == other.sessionId || this.sessionId.equals(other.sessionId)) && this.offset == other.offset;
        }
        return false;
    }

    public String toString() {
        return this.serialize(false);
    }

    public String toStringMultiline() {
        return this.serialize(true);
    }

    private String serialize(boolean longForm) {
        try {
            return JsonUtil.getMapper(longForm).writeValueAsString(this);
        }
        catch (JsonProcessingException ex) {
            throw new RuntimeException("Failed to serialize object", ex);
        }
    }

    static final class Deserializer
    extends StructJsonDeserializer<UploadSessionCursor> {
        private static final long serialVersionUID = 0L;

        public Deserializer() {
            super(UploadSessionCursor.class, new Class[0]);
        }

        public Deserializer(boolean unwrapping) {
            super(UploadSessionCursor.class, unwrapping, new Class[0]);
        }

        @Override
        protected JsonDeserializer<UploadSessionCursor> asUnwrapping() {
            return new Deserializer(true);
        }

        @Override
        public UploadSessionCursor deserializeFields(JsonParser _p, DeserializationContext _ctx) throws IOException, JsonParseException {
            String sessionId = null;
            Long offset = null;
            while (_p.getCurrentToken() == JsonToken.FIELD_NAME) {
                String _field = _p.getCurrentName();
                _p.nextToken();
                if ("session_id".equals(_field)) {
                    sessionId = Deserializer.getStringValue(_p);
                    _p.nextToken();
                    continue;
                }
                if ("offset".equals(_field)) {
                    offset = _p.getLongValue();
                    Deserializer.assertUnsigned(_p, offset);
                    _p.nextToken();
                    continue;
                }
                Deserializer.skipValue(_p);
            }
            if (sessionId == null) {
                throw new JsonParseException(_p, "Required field \"session_id\" is missing.");
            }
            if (offset == null) {
                throw new JsonParseException(_p, "Required field \"offset\" is missing.");
            }
            return new UploadSessionCursor(sessionId, offset);
        }
    }

    static final class Serializer
    extends StructJsonSerializer<UploadSessionCursor> {
        private static final long serialVersionUID = 0L;

        public Serializer() {
            super(UploadSessionCursor.class);
        }

        public Serializer(boolean unwrapping) {
            super(UploadSessionCursor.class, unwrapping);
        }

        @Override
        protected JsonSerializer<UploadSessionCursor> asUnwrapping() {
            return new Serializer(true);
        }

        @Override
        protected void serializeFields(UploadSessionCursor value, JsonGenerator g, SerializerProvider provider) throws IOException, JsonProcessingException {
            g.writeObjectField("session_id", value.sessionId);
            g.writeObjectField("offset", value.offset);
        }
    }
}

