/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.files;

import com.dropbox.core.json.JsonUtil;
import com.dropbox.core.json.StructJsonDeserializer;
import com.dropbox.core.json.StructJsonSerializer;
import com.dropbox.core.v2.files.WriteError;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.IOException;
import java.util.Arrays;

@JsonSerialize(using=Serializer.class)
@JsonDeserialize(using=Deserializer.class)
public class UploadWriteFailed {
    static final Serializer SERIALIZER = new Serializer();
    static final Deserializer DESERIALIZER = new Deserializer();
    protected final WriteError reason;
    protected final String uploadSessionId;

    public UploadWriteFailed(WriteError reason, String uploadSessionId) {
        if (reason == null) {
            throw new IllegalArgumentException("Required value for 'reason' is null");
        }
        this.reason = reason;
        if (uploadSessionId == null) {
            throw new IllegalArgumentException("Required value for 'uploadSessionId' is null");
        }
        this.uploadSessionId = uploadSessionId;
    }

    public WriteError getReason() {
        return this.reason;
    }

    public String getUploadSessionId() {
        return this.uploadSessionId;
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.reason, this.uploadSessionId});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj.getClass().equals(this.getClass())) {
            UploadWriteFailed other = (UploadWriteFailed)obj;
            return !(this.reason != other.reason && !this.reason.equals(other.reason) || this.uploadSessionId != other.uploadSessionId && !this.uploadSessionId.equals(other.uploadSessionId));
        }
        return false;
    }

    public String toString() {
        return this.serialize(false);
    }

    public String toStringMultiline() {
        return this.serialize(true);
    }

    private String serialize(boolean longForm) {
        try {
            return JsonUtil.getMapper(longForm).writeValueAsString(this);
        }
        catch (JsonProcessingException ex) {
            throw new RuntimeException("Failed to serialize object", ex);
        }
    }

    static final class Deserializer
    extends StructJsonDeserializer<UploadWriteFailed> {
        private static final long serialVersionUID = 0L;

        public Deserializer() {
            super(UploadWriteFailed.class, new Class[0]);
        }

        public Deserializer(boolean unwrapping) {
            super(UploadWriteFailed.class, unwrapping, new Class[0]);
        }

        @Override
        protected JsonDeserializer<UploadWriteFailed> asUnwrapping() {
            return new Deserializer(true);
        }

        @Override
        public UploadWriteFailed deserializeFields(JsonParser _p, DeserializationContext _ctx) throws IOException, JsonParseException {
            WriteError reason = null;
            String uploadSessionId = null;
            while (_p.getCurrentToken() == JsonToken.FIELD_NAME) {
                String _field = _p.getCurrentName();
                _p.nextToken();
                if ("reason".equals(_field)) {
                    reason = _p.readValueAs(WriteError.class);
                    _p.nextToken();
                    continue;
                }
                if ("upload_session_id".equals(_field)) {
                    uploadSessionId = Deserializer.getStringValue(_p);
                    _p.nextToken();
                    continue;
                }
                Deserializer.skipValue(_p);
            }
            if (reason == null) {
                throw new JsonParseException(_p, "Required field \"reason\" is missing.");
            }
            if (uploadSessionId == null) {
                throw new JsonParseException(_p, "Required field \"upload_session_id\" is missing.");
            }
            return new UploadWriteFailed(reason, uploadSessionId);
        }
    }

    static final class Serializer
    extends StructJsonSerializer<UploadWriteFailed> {
        private static final long serialVersionUID = 0L;

        public Serializer() {
            super(UploadWriteFailed.class);
        }

        public Serializer(boolean unwrapping) {
            super(UploadWriteFailed.class, unwrapping);
        }

        @Override
        protected JsonSerializer<UploadWriteFailed> asUnwrapping() {
            return new Serializer(true);
        }

        @Override
        protected void serializeFields(UploadWriteFailed value, JsonGenerator g, SerializerProvider provider) throws IOException, JsonProcessingException {
            g.writeObjectField("reason", value.reason);
            g.writeObjectField("upload_session_id", value.uploadSessionId);
        }
    }
}

