/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.files;

import com.dropbox.core.json.JsonUtil;
import com.dropbox.core.json.StructJsonDeserializer;
import com.dropbox.core.json.StructJsonSerializer;
import com.dropbox.core.v2.files.Dimensions;
import com.dropbox.core.v2.files.GpsCoordinates;
import com.dropbox.core.v2.files.MediaMetadata;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.IOException;
import java.util.Arrays;
import java.util.Date;

@JsonSerialize(using=Serializer.class)
@JsonDeserialize(using=Deserializer.class)
public class VideoMetadata
extends MediaMetadata {
    static final Serializer SERIALIZER = new Serializer();
    static final Deserializer DESERIALIZER = new Deserializer();
    protected final Long duration;

    public VideoMetadata(Dimensions dimensions, GpsCoordinates location, Date timeTaken, Long duration) {
        super(dimensions, location, timeTaken);
        this.duration = duration;
    }

    public VideoMetadata() {
        this(null, null, null, null);
    }

    public Long getDuration() {
        return this.duration;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    @Override
    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.duration});
        hash = 31 * super.hashCode() + hash;
        return hash;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj.getClass().equals(this.getClass())) {
            VideoMetadata other = (VideoMetadata)obj;
            return (this.dimensions == other.dimensions || this.dimensions != null && this.dimensions.equals(other.dimensions)) && (this.location == other.location || this.location != null && this.location.equals(other.location)) && (this.timeTaken == other.timeTaken || this.timeTaken != null && this.timeTaken.equals(other.timeTaken)) && (this.duration == other.duration || this.duration != null && this.duration.equals(other.duration));
        }
        return false;
    }

    @Override
    public String toString() {
        return this.serialize(false);
    }

    @Override
    public String toStringMultiline() {
        return this.serialize(true);
    }

    private String serialize(boolean longForm) {
        try {
            return JsonUtil.getMapper(longForm).writeValueAsString(this);
        }
        catch (JsonProcessingException ex) {
            throw new RuntimeException("Failed to serialize object", ex);
        }
    }

    static final class Deserializer
    extends StructJsonDeserializer<VideoMetadata> {
        private static final long serialVersionUID = 0L;

        public Deserializer() {
            super(VideoMetadata.class, new Class[0]);
        }

        public Deserializer(boolean unwrapping) {
            super(VideoMetadata.class, unwrapping, new Class[0]);
        }

        @Override
        protected JsonDeserializer<VideoMetadata> asUnwrapping() {
            return new Deserializer(true);
        }

        @Override
        public VideoMetadata deserializeFields(JsonParser _p, DeserializationContext _ctx) throws IOException, JsonParseException {
            String _subtype_tag = Deserializer.readEnumeratedSubtypeTag(_p, "video");
            Dimensions dimensions = null;
            GpsCoordinates location = null;
            Date timeTaken = null;
            Long duration = null;
            while (_p.getCurrentToken() == JsonToken.FIELD_NAME) {
                String _field = _p.getCurrentName();
                _p.nextToken();
                if ("dimensions".equals(_field)) {
                    dimensions = _p.readValueAs(Dimensions.class);
                    _p.nextToken();
                    continue;
                }
                if ("location".equals(_field)) {
                    location = _p.readValueAs(GpsCoordinates.class);
                    _p.nextToken();
                    continue;
                }
                if ("time_taken".equals(_field)) {
                    timeTaken = _ctx.parseDate(Deserializer.getStringValue(_p));
                    _p.nextToken();
                    continue;
                }
                if ("duration".equals(_field)) {
                    duration = _p.getLongValue();
                    Deserializer.assertUnsigned(_p, duration);
                    _p.nextToken();
                    continue;
                }
                Deserializer.skipValue(_p);
            }
            return new VideoMetadata(dimensions, location, timeTaken, duration);
        }
    }

    static final class Serializer
    extends StructJsonSerializer<VideoMetadata> {
        private static final long serialVersionUID = 0L;

        public Serializer() {
            super(VideoMetadata.class);
        }

        public Serializer(boolean unwrapping) {
            super(VideoMetadata.class, unwrapping);
        }

        @Override
        protected void serializeFields(VideoMetadata value, JsonGenerator g, SerializerProvider provider) throws IOException, JsonProcessingException {
            g.writeStringField(".tag", "video");
            if (value.dimensions != null) {
                g.writeObjectField("dimensions", value.dimensions);
            }
            if (value.location != null) {
                g.writeObjectField("location", value.location);
            }
            if (value.timeTaken != null) {
                g.writeObjectField("time_taken", value.timeTaken);
            }
            if (value.duration != null) {
                g.writeObjectField("duration", value.duration);
            }
        }
    }

    public static class Builder
    extends MediaMetadata.Builder {
        protected Long duration = null;

        protected Builder() {
        }

        public Builder withDuration(Long duration) {
            this.duration = duration;
            return this;
        }

        @Override
        public VideoMetadata build() {
            return new VideoMetadata(this.dimensions, this.location, this.timeTaken, this.duration);
        }
    }
}

