/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.sharing;

import com.dropbox.core.json.JsonUtil;
import com.dropbox.core.json.StructJsonDeserializer;
import com.dropbox.core.json.StructJsonSerializer;
import com.dropbox.core.v2.sharing.AccessLevel;
import com.dropbox.core.v2.sharing.MemberSelector;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.IOException;
import java.util.Arrays;

@JsonSerialize(using=Serializer.class)
@JsonDeserialize(using=Deserializer.class)
public class AddMember {
    static final Serializer SERIALIZER = new Serializer();
    static final Deserializer DESERIALIZER = new Deserializer();
    protected final MemberSelector member;
    protected final AccessLevel accessLevel;

    public AddMember(MemberSelector member, AccessLevel accessLevel) {
        if (member == null) {
            throw new IllegalArgumentException("Required value for 'member' is null");
        }
        this.member = member;
        if (accessLevel == null) {
            throw new IllegalArgumentException("Required value for 'accessLevel' is null");
        }
        this.accessLevel = accessLevel;
    }

    public AddMember(MemberSelector member) {
        this(member, AccessLevel.VIEWER);
    }

    public MemberSelector getMember() {
        return this.member;
    }

    public AccessLevel getAccessLevel() {
        return this.accessLevel;
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.member, this.accessLevel});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj.getClass().equals(this.getClass())) {
            AddMember other = (AddMember)obj;
            return !(this.member != other.member && !this.member.equals(other.member) || this.accessLevel != other.accessLevel && !this.accessLevel.equals((Object)other.accessLevel));
        }
        return false;
    }

    public String toString() {
        return this.serialize(false);
    }

    public String toStringMultiline() {
        return this.serialize(true);
    }

    private String serialize(boolean longForm) {
        try {
            return JsonUtil.getMapper(longForm).writeValueAsString(this);
        }
        catch (JsonProcessingException ex) {
            throw new RuntimeException("Failed to serialize object", ex);
        }
    }

    static final class Deserializer
    extends StructJsonDeserializer<AddMember> {
        private static final long serialVersionUID = 0L;

        public Deserializer() {
            super(AddMember.class, new Class[0]);
        }

        public Deserializer(boolean unwrapping) {
            super(AddMember.class, unwrapping, new Class[0]);
        }

        @Override
        protected JsonDeserializer<AddMember> asUnwrapping() {
            return new Deserializer(true);
        }

        @Override
        public AddMember deserializeFields(JsonParser _p, DeserializationContext _ctx) throws IOException, JsonParseException {
            MemberSelector member = null;
            AccessLevel accessLevel = null;
            while (_p.getCurrentToken() == JsonToken.FIELD_NAME) {
                String _field = _p.getCurrentName();
                _p.nextToken();
                if ("member".equals(_field)) {
                    member = _p.readValueAs(MemberSelector.class);
                    _p.nextToken();
                    continue;
                }
                if ("access_level".equals(_field)) {
                    accessLevel = _p.readValueAs(AccessLevel.class);
                    _p.nextToken();
                    continue;
                }
                Deserializer.skipValue(_p);
            }
            if (member == null) {
                throw new JsonParseException(_p, "Required field \"member\" is missing.");
            }
            return new AddMember(member, accessLevel);
        }
    }

    static final class Serializer
    extends StructJsonSerializer<AddMember> {
        private static final long serialVersionUID = 0L;

        public Serializer() {
            super(AddMember.class);
        }

        public Serializer(boolean unwrapping) {
            super(AddMember.class, unwrapping);
        }

        @Override
        protected JsonSerializer<AddMember> asUnwrapping() {
            return new Serializer(true);
        }

        @Override
        protected void serializeFields(AddMember value, JsonGenerator g, SerializerProvider provider) throws IOException, JsonProcessingException {
            g.writeObjectField("member", value.member);
            g.writeObjectField("access_level", (Object)value.accessLevel);
        }
    }
}

