/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.sharing;

import com.dropbox.core.json.JsonUtil;
import com.dropbox.core.json.StructJsonDeserializer;
import com.dropbox.core.json.StructJsonSerializer;
import com.dropbox.core.v2.sharing.LinkMetadata;
import com.dropbox.core.v2.sharing.Visibility;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.IOException;
import java.util.Date;

@JsonSerialize(using=Serializer.class)
@JsonDeserialize(using=Deserializer.class)
public class CollectionLinkMetadata
extends LinkMetadata {
    static final Serializer SERIALIZER = new Serializer();
    static final Deserializer DESERIALIZER = new Deserializer();

    public CollectionLinkMetadata(String url, Visibility visibility, Date expires) {
        super(url, visibility, expires);
    }

    public CollectionLinkMetadata(String url, Visibility visibility) {
        this(url, visibility, null);
    }

    @Override
    public int hashCode() {
        return this.getClass().toString().hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj.getClass().equals(this.getClass())) {
            CollectionLinkMetadata other = (CollectionLinkMetadata)obj;
            return !(this.url != other.url && !this.url.equals(other.url) || this.visibility != other.visibility && !this.visibility.equals((Object)other.visibility) || this.expires != other.expires && (this.expires == null || !this.expires.equals(other.expires)));
        }
        return false;
    }

    @Override
    public String toString() {
        return this.serialize(false);
    }

    @Override
    public String toStringMultiline() {
        return this.serialize(true);
    }

    private String serialize(boolean longForm) {
        try {
            return JsonUtil.getMapper(longForm).writeValueAsString(this);
        }
        catch (JsonProcessingException ex) {
            throw new RuntimeException("Failed to serialize object", ex);
        }
    }

    static final class Deserializer
    extends StructJsonDeserializer<CollectionLinkMetadata> {
        private static final long serialVersionUID = 0L;

        public Deserializer() {
            super(CollectionLinkMetadata.class, new Class[0]);
        }

        public Deserializer(boolean unwrapping) {
            super(CollectionLinkMetadata.class, unwrapping, new Class[0]);
        }

        @Override
        protected JsonDeserializer<CollectionLinkMetadata> asUnwrapping() {
            return new Deserializer(true);
        }

        @Override
        public CollectionLinkMetadata deserializeFields(JsonParser _p, DeserializationContext _ctx) throws IOException, JsonParseException {
            String _subtype_tag = Deserializer.readEnumeratedSubtypeTag(_p, "collection");
            String url = null;
            Visibility visibility = null;
            Date expires = null;
            while (_p.getCurrentToken() == JsonToken.FIELD_NAME) {
                String _field = _p.getCurrentName();
                _p.nextToken();
                if ("url".equals(_field)) {
                    url = Deserializer.getStringValue(_p);
                    _p.nextToken();
                    continue;
                }
                if ("visibility".equals(_field)) {
                    visibility = _p.readValueAs(Visibility.class);
                    _p.nextToken();
                    continue;
                }
                if ("expires".equals(_field)) {
                    expires = _ctx.parseDate(Deserializer.getStringValue(_p));
                    _p.nextToken();
                    continue;
                }
                Deserializer.skipValue(_p);
            }
            if (url == null) {
                throw new JsonParseException(_p, "Required field \"url\" is missing.");
            }
            if (visibility == null) {
                throw new JsonParseException(_p, "Required field \"visibility\" is missing.");
            }
            return new CollectionLinkMetadata(url, visibility, expires);
        }
    }

    static final class Serializer
    extends StructJsonSerializer<CollectionLinkMetadata> {
        private static final long serialVersionUID = 0L;

        public Serializer() {
            super(CollectionLinkMetadata.class);
        }

        public Serializer(boolean unwrapping) {
            super(CollectionLinkMetadata.class, unwrapping);
        }

        @Override
        protected void serializeFields(CollectionLinkMetadata value, JsonGenerator g, SerializerProvider provider) throws IOException, JsonProcessingException {
            g.writeStringField(".tag", "collection");
            g.writeObjectField("url", value.url);
            g.writeObjectField("visibility", (Object)value.visibility);
            if (value.expires != null) {
                g.writeObjectField("expires", value.expires);
            }
        }
    }
}

