/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.sharing;

import com.dropbox.core.json.JsonUtil;
import com.dropbox.core.json.StructJsonDeserializer;
import com.dropbox.core.json.StructJsonSerializer;
import com.dropbox.core.v2.sharing.LinkPermissions;
import com.dropbox.core.v2.sharing.SharedLinkMetadata;
import com.dropbox.core.v2.sharing.TeamMemberInfo;
import com.dropbox.core.v2.users.Team;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.IOException;
import java.util.Date;

@JsonSerialize(using=Serializer.class)
@JsonDeserialize(using=Deserializer.class)
public class FolderLinkMetadata
extends SharedLinkMetadata {
    static final Serializer SERIALIZER = new Serializer();
    static final Deserializer DESERIALIZER = new Deserializer();

    public FolderLinkMetadata(String url, String name, LinkPermissions linkPermissions, String id, Date expires, String pathLower, TeamMemberInfo teamMemberInfo, Team contentOwnerTeamInfo) {
        super(url, name, linkPermissions, id, expires, pathLower, teamMemberInfo, contentOwnerTeamInfo);
    }

    public FolderLinkMetadata(String url, String name, LinkPermissions linkPermissions) {
        this(url, name, linkPermissions, null, null, null, null, null);
    }

    public static Builder newBuilder(String url, String name, LinkPermissions linkPermissions) {
        return new Builder(url, name, linkPermissions);
    }

    @Override
    public int hashCode() {
        return this.getClass().toString().hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj.getClass().equals(this.getClass())) {
            FolderLinkMetadata other = (FolderLinkMetadata)obj;
            return !(this.url != other.url && !this.url.equals(other.url) || this.name != other.name && !this.name.equals(other.name) || this.linkPermissions != other.linkPermissions && !this.linkPermissions.equals(other.linkPermissions) || this.id != other.id && (this.id == null || !this.id.equals(other.id)) || this.expires != other.expires && (this.expires == null || !this.expires.equals(other.expires)) || this.pathLower != other.pathLower && (this.pathLower == null || !this.pathLower.equals(other.pathLower)) || this.teamMemberInfo != other.teamMemberInfo && (this.teamMemberInfo == null || !this.teamMemberInfo.equals(other.teamMemberInfo)) || this.contentOwnerTeamInfo != other.contentOwnerTeamInfo && (this.contentOwnerTeamInfo == null || !this.contentOwnerTeamInfo.equals(other.contentOwnerTeamInfo)));
        }
        return false;
    }

    @Override
    public String toString() {
        return this.serialize(false);
    }

    @Override
    public String toStringMultiline() {
        return this.serialize(true);
    }

    private String serialize(boolean longForm) {
        try {
            return JsonUtil.getMapper(longForm).writeValueAsString(this);
        }
        catch (JsonProcessingException ex) {
            throw new RuntimeException("Failed to serialize object", ex);
        }
    }

    static final class Deserializer
    extends StructJsonDeserializer<FolderLinkMetadata> {
        private static final long serialVersionUID = 0L;

        public Deserializer() {
            super(FolderLinkMetadata.class, new Class[0]);
        }

        public Deserializer(boolean unwrapping) {
            super(FolderLinkMetadata.class, unwrapping, new Class[0]);
        }

        @Override
        protected JsonDeserializer<FolderLinkMetadata> asUnwrapping() {
            return new Deserializer(true);
        }

        @Override
        public FolderLinkMetadata deserializeFields(JsonParser _p, DeserializationContext _ctx) throws IOException, JsonParseException {
            String _subtype_tag = Deserializer.readEnumeratedSubtypeTag(_p, "folder");
            String url = null;
            String name = null;
            LinkPermissions linkPermissions = null;
            String id = null;
            Date expires = null;
            String pathLower = null;
            TeamMemberInfo teamMemberInfo = null;
            Team contentOwnerTeamInfo = null;
            while (_p.getCurrentToken() == JsonToken.FIELD_NAME) {
                String _field = _p.getCurrentName();
                _p.nextToken();
                if ("url".equals(_field)) {
                    url = Deserializer.getStringValue(_p);
                    _p.nextToken();
                    continue;
                }
                if ("name".equals(_field)) {
                    name = Deserializer.getStringValue(_p);
                    _p.nextToken();
                    continue;
                }
                if ("link_permissions".equals(_field)) {
                    linkPermissions = _p.readValueAs(LinkPermissions.class);
                    _p.nextToken();
                    continue;
                }
                if ("id".equals(_field)) {
                    id = Deserializer.getStringValue(_p);
                    _p.nextToken();
                    continue;
                }
                if ("expires".equals(_field)) {
                    expires = _ctx.parseDate(Deserializer.getStringValue(_p));
                    _p.nextToken();
                    continue;
                }
                if ("path_lower".equals(_field)) {
                    pathLower = Deserializer.getStringValue(_p);
                    _p.nextToken();
                    continue;
                }
                if ("team_member_info".equals(_field)) {
                    teamMemberInfo = _p.readValueAs(TeamMemberInfo.class);
                    _p.nextToken();
                    continue;
                }
                if ("content_owner_team_info".equals(_field)) {
                    contentOwnerTeamInfo = _p.readValueAs(Team.class);
                    _p.nextToken();
                    continue;
                }
                Deserializer.skipValue(_p);
            }
            if (url == null) {
                throw new JsonParseException(_p, "Required field \"url\" is missing.");
            }
            if (name == null) {
                throw new JsonParseException(_p, "Required field \"name\" is missing.");
            }
            if (linkPermissions == null) {
                throw new JsonParseException(_p, "Required field \"link_permissions\" is missing.");
            }
            return new FolderLinkMetadata(url, name, linkPermissions, id, expires, pathLower, teamMemberInfo, contentOwnerTeamInfo);
        }
    }

    static final class Serializer
    extends StructJsonSerializer<FolderLinkMetadata> {
        private static final long serialVersionUID = 0L;

        public Serializer() {
            super(FolderLinkMetadata.class);
        }

        public Serializer(boolean unwrapping) {
            super(FolderLinkMetadata.class, unwrapping);
        }

        @Override
        protected void serializeFields(FolderLinkMetadata value, JsonGenerator g, SerializerProvider provider) throws IOException, JsonProcessingException {
            g.writeStringField(".tag", "folder");
            g.writeObjectField("url", value.url);
            g.writeObjectField("name", value.name);
            g.writeObjectField("link_permissions", value.linkPermissions);
            if (value.id != null) {
                g.writeObjectField("id", value.id);
            }
            if (value.expires != null) {
                g.writeObjectField("expires", value.expires);
            }
            if (value.pathLower != null) {
                g.writeObjectField("path_lower", value.pathLower);
            }
            if (value.teamMemberInfo != null) {
                g.writeObjectField("team_member_info", value.teamMemberInfo);
            }
            if (value.contentOwnerTeamInfo != null) {
                g.writeObjectField("content_owner_team_info", value.contentOwnerTeamInfo);
            }
        }
    }

    public static class Builder
    extends SharedLinkMetadata.Builder {
        protected Builder(String url, String name, LinkPermissions linkPermissions) {
            super(url, name, linkPermissions);
        }

        @Override
        public FolderLinkMetadata build() {
            return new FolderLinkMetadata(this.url, this.name, this.linkPermissions, this.id, this.expires, this.pathLower, this.teamMemberInfo, this.contentOwnerTeamInfo);
        }
    }
}

