/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.sharing;

import com.dropbox.core.json.JsonUtil;
import com.dropbox.core.json.StructJsonDeserializer;
import com.dropbox.core.json.StructJsonSerializer;
import com.dropbox.core.v2.sharing.AclUpdatePolicy;
import com.dropbox.core.v2.sharing.MemberPolicy;
import com.dropbox.core.v2.sharing.SharedLinkPolicy;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.IOException;
import java.util.Arrays;

@JsonSerialize(using=Serializer.class)
@JsonDeserialize(using=Deserializer.class)
public class FolderPolicy {
    static final Serializer SERIALIZER = new Serializer();
    static final Deserializer DESERIALIZER = new Deserializer();
    protected final MemberPolicy memberPolicy;
    protected final AclUpdatePolicy aclUpdatePolicy;
    protected final SharedLinkPolicy sharedLinkPolicy;

    public FolderPolicy(AclUpdatePolicy aclUpdatePolicy, SharedLinkPolicy sharedLinkPolicy, MemberPolicy memberPolicy) {
        this.memberPolicy = memberPolicy;
        if (aclUpdatePolicy == null) {
            throw new IllegalArgumentException("Required value for 'aclUpdatePolicy' is null");
        }
        this.aclUpdatePolicy = aclUpdatePolicy;
        if (sharedLinkPolicy == null) {
            throw new IllegalArgumentException("Required value for 'sharedLinkPolicy' is null");
        }
        this.sharedLinkPolicy = sharedLinkPolicy;
    }

    public FolderPolicy(AclUpdatePolicy aclUpdatePolicy, SharedLinkPolicy sharedLinkPolicy) {
        this(aclUpdatePolicy, sharedLinkPolicy, null);
    }

    public MemberPolicy getMemberPolicy() {
        return this.memberPolicy;
    }

    public AclUpdatePolicy getAclUpdatePolicy() {
        return this.aclUpdatePolicy;
    }

    public SharedLinkPolicy getSharedLinkPolicy() {
        return this.sharedLinkPolicy;
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.memberPolicy, this.aclUpdatePolicy, this.sharedLinkPolicy});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj.getClass().equals(this.getClass())) {
            FolderPolicy other = (FolderPolicy)obj;
            return !(this.aclUpdatePolicy != other.aclUpdatePolicy && !this.aclUpdatePolicy.equals((Object)other.aclUpdatePolicy) || this.sharedLinkPolicy != other.sharedLinkPolicy && !this.sharedLinkPolicy.equals((Object)other.sharedLinkPolicy) || this.memberPolicy != other.memberPolicy && (this.memberPolicy == null || !this.memberPolicy.equals((Object)other.memberPolicy)));
        }
        return false;
    }

    public String toString() {
        return this.serialize(false);
    }

    public String toStringMultiline() {
        return this.serialize(true);
    }

    private String serialize(boolean longForm) {
        try {
            return JsonUtil.getMapper(longForm).writeValueAsString(this);
        }
        catch (JsonProcessingException ex) {
            throw new RuntimeException("Failed to serialize object", ex);
        }
    }

    static final class Deserializer
    extends StructJsonDeserializer<FolderPolicy> {
        private static final long serialVersionUID = 0L;

        public Deserializer() {
            super(FolderPolicy.class, new Class[0]);
        }

        public Deserializer(boolean unwrapping) {
            super(FolderPolicy.class, unwrapping, new Class[0]);
        }

        @Override
        protected JsonDeserializer<FolderPolicy> asUnwrapping() {
            return new Deserializer(true);
        }

        @Override
        public FolderPolicy deserializeFields(JsonParser _p, DeserializationContext _ctx) throws IOException, JsonParseException {
            AclUpdatePolicy aclUpdatePolicy = null;
            SharedLinkPolicy sharedLinkPolicy = null;
            MemberPolicy memberPolicy = null;
            while (_p.getCurrentToken() == JsonToken.FIELD_NAME) {
                String _field = _p.getCurrentName();
                _p.nextToken();
                if ("acl_update_policy".equals(_field)) {
                    aclUpdatePolicy = _p.readValueAs(AclUpdatePolicy.class);
                    _p.nextToken();
                    continue;
                }
                if ("shared_link_policy".equals(_field)) {
                    sharedLinkPolicy = _p.readValueAs(SharedLinkPolicy.class);
                    _p.nextToken();
                    continue;
                }
                if ("member_policy".equals(_field)) {
                    memberPolicy = _p.readValueAs(MemberPolicy.class);
                    _p.nextToken();
                    continue;
                }
                Deserializer.skipValue(_p);
            }
            if (aclUpdatePolicy == null) {
                throw new JsonParseException(_p, "Required field \"acl_update_policy\" is missing.");
            }
            if (sharedLinkPolicy == null) {
                throw new JsonParseException(_p, "Required field \"shared_link_policy\" is missing.");
            }
            return new FolderPolicy(aclUpdatePolicy, sharedLinkPolicy, memberPolicy);
        }
    }

    static final class Serializer
    extends StructJsonSerializer<FolderPolicy> {
        private static final long serialVersionUID = 0L;

        public Serializer() {
            super(FolderPolicy.class);
        }

        public Serializer(boolean unwrapping) {
            super(FolderPolicy.class, unwrapping);
        }

        @Override
        protected JsonSerializer<FolderPolicy> asUnwrapping() {
            return new Serializer(true);
        }

        @Override
        protected void serializeFields(FolderPolicy value, JsonGenerator g, SerializerProvider provider) throws IOException, JsonProcessingException {
            g.writeObjectField("acl_update_policy", (Object)value.aclUpdatePolicy);
            g.writeObjectField("shared_link_policy", (Object)value.sharedLinkPolicy);
            if (value.memberPolicy != null) {
                g.writeObjectField("member_policy", (Object)value.memberPolicy);
            }
        }
    }
}

