/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.sharing;

import com.dropbox.core.json.JsonUtil;
import com.dropbox.core.json.StructJsonDeserializer;
import com.dropbox.core.json.StructJsonSerializer;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.IOException;
import java.util.Arrays;
import java.util.regex.Pattern;

@JsonSerialize(using=Serializer.class)
@JsonDeserialize(using=Deserializer.class)
class GetSharedLinkMetadataArg {
    static final Serializer SERIALIZER = new Serializer();
    static final Deserializer DESERIALIZER = new Deserializer();
    protected final String url;
    protected final String path;
    protected final String linkPassword;

    public GetSharedLinkMetadataArg(String url, String path, String linkPassword) {
        if (url == null) {
            throw new IllegalArgumentException("Required value for 'url' is null");
        }
        this.url = url;
        if (path != null && !Pattern.matches("/.*", path)) {
            throw new IllegalArgumentException("String 'path' does not match pattern");
        }
        this.path = path;
        this.linkPassword = linkPassword;
    }

    public GetSharedLinkMetadataArg(String url) {
        this(url, null, null);
    }

    public String getUrl() {
        return this.url;
    }

    public String getPath() {
        return this.path;
    }

    public String getLinkPassword() {
        return this.linkPassword;
    }

    public static Builder newBuilder(String url) {
        return new Builder(url);
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.url, this.path, this.linkPassword});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj.getClass().equals(this.getClass())) {
            GetSharedLinkMetadataArg other = (GetSharedLinkMetadataArg)obj;
            return (this.url == other.url || this.url.equals(other.url)) && (this.path == other.path || this.path != null && this.path.equals(other.path)) && (this.linkPassword == other.linkPassword || this.linkPassword != null && this.linkPassword.equals(other.linkPassword));
        }
        return false;
    }

    public String toString() {
        return this.serialize(false);
    }

    public String toStringMultiline() {
        return this.serialize(true);
    }

    private String serialize(boolean longForm) {
        try {
            return JsonUtil.getMapper(longForm).writeValueAsString(this);
        }
        catch (JsonProcessingException ex) {
            throw new RuntimeException("Failed to serialize object", ex);
        }
    }

    static final class Deserializer
    extends StructJsonDeserializer<GetSharedLinkMetadataArg> {
        private static final long serialVersionUID = 0L;

        public Deserializer() {
            super(GetSharedLinkMetadataArg.class, new Class[0]);
        }

        public Deserializer(boolean unwrapping) {
            super(GetSharedLinkMetadataArg.class, unwrapping, new Class[0]);
        }

        @Override
        protected JsonDeserializer<GetSharedLinkMetadataArg> asUnwrapping() {
            return new Deserializer(true);
        }

        @Override
        public GetSharedLinkMetadataArg deserializeFields(JsonParser _p, DeserializationContext _ctx) throws IOException, JsonParseException {
            String url = null;
            String path = null;
            String linkPassword = null;
            while (_p.getCurrentToken() == JsonToken.FIELD_NAME) {
                String _field = _p.getCurrentName();
                _p.nextToken();
                if ("url".equals(_field)) {
                    url = Deserializer.getStringValue(_p);
                    _p.nextToken();
                    continue;
                }
                if ("path".equals(_field)) {
                    path = Deserializer.getStringValue(_p);
                    _p.nextToken();
                    continue;
                }
                if ("link_password".equals(_field)) {
                    linkPassword = Deserializer.getStringValue(_p);
                    _p.nextToken();
                    continue;
                }
                Deserializer.skipValue(_p);
            }
            if (url == null) {
                throw new JsonParseException(_p, "Required field \"url\" is missing.");
            }
            return new GetSharedLinkMetadataArg(url, path, linkPassword);
        }
    }

    static final class Serializer
    extends StructJsonSerializer<GetSharedLinkMetadataArg> {
        private static final long serialVersionUID = 0L;

        public Serializer() {
            super(GetSharedLinkMetadataArg.class);
        }

        public Serializer(boolean unwrapping) {
            super(GetSharedLinkMetadataArg.class, unwrapping);
        }

        @Override
        protected JsonSerializer<GetSharedLinkMetadataArg> asUnwrapping() {
            return new Serializer(true);
        }

        @Override
        protected void serializeFields(GetSharedLinkMetadataArg value, JsonGenerator g, SerializerProvider provider) throws IOException, JsonProcessingException {
            g.writeObjectField("url", value.url);
            if (value.path != null) {
                g.writeObjectField("path", value.path);
            }
            if (value.linkPassword != null) {
                g.writeObjectField("link_password", value.linkPassword);
            }
        }
    }

    public static class Builder {
        protected final String url;
        protected String path;
        protected String linkPassword;

        protected Builder(String url) {
            if (url == null) {
                throw new IllegalArgumentException("Required value for 'url' is null");
            }
            this.url = url;
            this.path = null;
            this.linkPassword = null;
        }

        public Builder withPath(String path) {
            if (path != null && !Pattern.matches("/.*", path)) {
                throw new IllegalArgumentException("String 'path' does not match pattern");
            }
            this.path = path;
            return this;
        }

        public Builder withLinkPassword(String linkPassword) {
            this.linkPassword = linkPassword;
            return this;
        }

        public GetSharedLinkMetadataArg build() {
            return new GetSharedLinkMetadataArg(this.url, this.path, this.linkPassword);
        }
    }
}

