/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.sharing;

import com.dropbox.core.json.JsonUtil;
import com.dropbox.core.json.StructJsonDeserializer;
import com.dropbox.core.json.StructJsonSerializer;
import com.dropbox.core.v2.sharing.RequestedVisibility;
import com.dropbox.core.v2.sharing.ResolvedVisibility;
import com.dropbox.core.v2.sharing.SharedLinkAccessFailureReason;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.IOException;
import java.util.Arrays;

@JsonSerialize(using=Serializer.class)
@JsonDeserialize(using=Deserializer.class)
public class LinkPermissions {
    static final Serializer SERIALIZER = new Serializer();
    static final Deserializer DESERIALIZER = new Deserializer();
    protected final ResolvedVisibility resolvedVisibility;
    protected final RequestedVisibility requestedVisibility;
    protected final boolean canRevoke;
    protected final SharedLinkAccessFailureReason revokeFailureReason;

    public LinkPermissions(boolean canRevoke, ResolvedVisibility resolvedVisibility, RequestedVisibility requestedVisibility, SharedLinkAccessFailureReason revokeFailureReason) {
        this.resolvedVisibility = resolvedVisibility;
        this.requestedVisibility = requestedVisibility;
        this.canRevoke = canRevoke;
        this.revokeFailureReason = revokeFailureReason;
    }

    public LinkPermissions(boolean canRevoke) {
        this(canRevoke, null, null, null);
    }

    public ResolvedVisibility getResolvedVisibility() {
        return this.resolvedVisibility;
    }

    public RequestedVisibility getRequestedVisibility() {
        return this.requestedVisibility;
    }

    public boolean getCanRevoke() {
        return this.canRevoke;
    }

    public SharedLinkAccessFailureReason getRevokeFailureReason() {
        return this.revokeFailureReason;
    }

    public static Builder newBuilder(boolean canRevoke) {
        return new Builder(canRevoke);
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.resolvedVisibility, this.requestedVisibility, this.canRevoke, this.revokeFailureReason});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj.getClass().equals(this.getClass())) {
            LinkPermissions other = (LinkPermissions)obj;
            return this.canRevoke == other.canRevoke && (this.resolvedVisibility == other.resolvedVisibility || this.resolvedVisibility != null && this.resolvedVisibility.equals((Object)other.resolvedVisibility)) && (this.requestedVisibility == other.requestedVisibility || this.requestedVisibility != null && this.requestedVisibility.equals((Object)other.requestedVisibility)) && (this.revokeFailureReason == other.revokeFailureReason || this.revokeFailureReason != null && this.revokeFailureReason.equals((Object)other.revokeFailureReason));
        }
        return false;
    }

    public String toString() {
        return this.serialize(false);
    }

    public String toStringMultiline() {
        return this.serialize(true);
    }

    private String serialize(boolean longForm) {
        try {
            return JsonUtil.getMapper(longForm).writeValueAsString(this);
        }
        catch (JsonProcessingException ex) {
            throw new RuntimeException("Failed to serialize object", ex);
        }
    }

    static final class Deserializer
    extends StructJsonDeserializer<LinkPermissions> {
        private static final long serialVersionUID = 0L;

        public Deserializer() {
            super(LinkPermissions.class, new Class[0]);
        }

        public Deserializer(boolean unwrapping) {
            super(LinkPermissions.class, unwrapping, new Class[0]);
        }

        @Override
        protected JsonDeserializer<LinkPermissions> asUnwrapping() {
            return new Deserializer(true);
        }

        @Override
        public LinkPermissions deserializeFields(JsonParser _p, DeserializationContext _ctx) throws IOException, JsonParseException {
            Boolean canRevoke = null;
            ResolvedVisibility resolvedVisibility = null;
            RequestedVisibility requestedVisibility = null;
            SharedLinkAccessFailureReason revokeFailureReason = null;
            while (_p.getCurrentToken() == JsonToken.FIELD_NAME) {
                String _field = _p.getCurrentName();
                _p.nextToken();
                if ("can_revoke".equals(_field)) {
                    canRevoke = _p.getValueAsBoolean();
                    _p.nextToken();
                    continue;
                }
                if ("resolved_visibility".equals(_field)) {
                    resolvedVisibility = _p.readValueAs(ResolvedVisibility.class);
                    _p.nextToken();
                    continue;
                }
                if ("requested_visibility".equals(_field)) {
                    requestedVisibility = _p.readValueAs(RequestedVisibility.class);
                    _p.nextToken();
                    continue;
                }
                if ("revoke_failure_reason".equals(_field)) {
                    revokeFailureReason = _p.readValueAs(SharedLinkAccessFailureReason.class);
                    _p.nextToken();
                    continue;
                }
                Deserializer.skipValue(_p);
            }
            if (canRevoke == null) {
                throw new JsonParseException(_p, "Required field \"can_revoke\" is missing.");
            }
            return new LinkPermissions(canRevoke, resolvedVisibility, requestedVisibility, revokeFailureReason);
        }
    }

    static final class Serializer
    extends StructJsonSerializer<LinkPermissions> {
        private static final long serialVersionUID = 0L;

        public Serializer() {
            super(LinkPermissions.class);
        }

        public Serializer(boolean unwrapping) {
            super(LinkPermissions.class, unwrapping);
        }

        @Override
        protected JsonSerializer<LinkPermissions> asUnwrapping() {
            return new Serializer(true);
        }

        @Override
        protected void serializeFields(LinkPermissions value, JsonGenerator g, SerializerProvider provider) throws IOException, JsonProcessingException {
            g.writeObjectField("can_revoke", value.canRevoke);
            if (value.resolvedVisibility != null) {
                g.writeObjectField("resolved_visibility", (Object)value.resolvedVisibility);
            }
            if (value.requestedVisibility != null) {
                g.writeObjectField("requested_visibility", (Object)value.requestedVisibility);
            }
            if (value.revokeFailureReason != null) {
                g.writeObjectField("revoke_failure_reason", (Object)value.revokeFailureReason);
            }
        }
    }

    public static class Builder {
        protected final boolean canRevoke;
        protected ResolvedVisibility resolvedVisibility;
        protected RequestedVisibility requestedVisibility;
        protected SharedLinkAccessFailureReason revokeFailureReason;

        protected Builder(boolean canRevoke) {
            this.canRevoke = canRevoke;
            this.resolvedVisibility = null;
            this.requestedVisibility = null;
            this.revokeFailureReason = null;
        }

        public Builder withResolvedVisibility(ResolvedVisibility resolvedVisibility) {
            this.resolvedVisibility = resolvedVisibility;
            return this;
        }

        public Builder withRequestedVisibility(RequestedVisibility requestedVisibility) {
            this.requestedVisibility = requestedVisibility;
            return this;
        }

        public Builder withRevokeFailureReason(SharedLinkAccessFailureReason revokeFailureReason) {
            this.revokeFailureReason = revokeFailureReason;
            return this;
        }

        public LinkPermissions build() {
            return new LinkPermissions(this.canRevoke, this.resolvedVisibility, this.requestedVisibility, this.revokeFailureReason);
        }
    }
}

