/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.sharing;

import com.dropbox.core.json.JsonUtil;
import com.dropbox.core.json.StructJsonDeserializer;
import com.dropbox.core.json.StructJsonSerializer;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.IOException;
import java.util.Arrays;
import java.util.regex.Pattern;

@JsonSerialize(using=Serializer.class)
@JsonDeserialize(using=Deserializer.class)
class ListSharedLinksArg {
    static final Serializer SERIALIZER = new Serializer();
    static final Deserializer DESERIALIZER = new Deserializer();
    protected final String path;
    protected final String cursor;
    protected final Boolean directOnly;

    public ListSharedLinksArg(String path, String cursor, Boolean directOnly) {
        if (path != null && !Pattern.matches("((/|id:).*)|(rev:[0-9a-f]{9,})", path)) {
            throw new IllegalArgumentException("String 'path' does not match pattern");
        }
        this.path = path;
        this.cursor = cursor;
        this.directOnly = directOnly;
    }

    public ListSharedLinksArg() {
        this(null, null, null);
    }

    public String getPath() {
        return this.path;
    }

    public String getCursor() {
        return this.cursor;
    }

    public Boolean getDirectOnly() {
        return this.directOnly;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.path, this.cursor, this.directOnly});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj.getClass().equals(this.getClass())) {
            ListSharedLinksArg other = (ListSharedLinksArg)obj;
            return (this.path == other.path || this.path != null && this.path.equals(other.path)) && (this.cursor == other.cursor || this.cursor != null && this.cursor.equals(other.cursor)) && (this.directOnly == other.directOnly || this.directOnly != null && this.directOnly.equals(other.directOnly));
        }
        return false;
    }

    public String toString() {
        return this.serialize(false);
    }

    public String toStringMultiline() {
        return this.serialize(true);
    }

    private String serialize(boolean longForm) {
        try {
            return JsonUtil.getMapper(longForm).writeValueAsString(this);
        }
        catch (JsonProcessingException ex) {
            throw new RuntimeException("Failed to serialize object", ex);
        }
    }

    static final class Deserializer
    extends StructJsonDeserializer<ListSharedLinksArg> {
        private static final long serialVersionUID = 0L;

        public Deserializer() {
            super(ListSharedLinksArg.class, new Class[0]);
        }

        public Deserializer(boolean unwrapping) {
            super(ListSharedLinksArg.class, unwrapping, new Class[0]);
        }

        @Override
        protected JsonDeserializer<ListSharedLinksArg> asUnwrapping() {
            return new Deserializer(true);
        }

        @Override
        public ListSharedLinksArg deserializeFields(JsonParser _p, DeserializationContext _ctx) throws IOException, JsonParseException {
            String path = null;
            String cursor = null;
            Boolean directOnly = null;
            while (_p.getCurrentToken() == JsonToken.FIELD_NAME) {
                String _field = _p.getCurrentName();
                _p.nextToken();
                if ("path".equals(_field)) {
                    path = Deserializer.getStringValue(_p);
                    _p.nextToken();
                    continue;
                }
                if ("cursor".equals(_field)) {
                    cursor = Deserializer.getStringValue(_p);
                    _p.nextToken();
                    continue;
                }
                if ("direct_only".equals(_field)) {
                    directOnly = _p.getValueAsBoolean();
                    _p.nextToken();
                    continue;
                }
                Deserializer.skipValue(_p);
            }
            return new ListSharedLinksArg(path, cursor, directOnly);
        }
    }

    static final class Serializer
    extends StructJsonSerializer<ListSharedLinksArg> {
        private static final long serialVersionUID = 0L;

        public Serializer() {
            super(ListSharedLinksArg.class);
        }

        public Serializer(boolean unwrapping) {
            super(ListSharedLinksArg.class, unwrapping);
        }

        @Override
        protected JsonSerializer<ListSharedLinksArg> asUnwrapping() {
            return new Serializer(true);
        }

        @Override
        protected void serializeFields(ListSharedLinksArg value, JsonGenerator g, SerializerProvider provider) throws IOException, JsonProcessingException {
            if (value.path != null) {
                g.writeObjectField("path", value.path);
            }
            if (value.cursor != null) {
                g.writeObjectField("cursor", value.cursor);
            }
            if (value.directOnly != null) {
                g.writeObjectField("direct_only", value.directOnly);
            }
        }
    }

    public static class Builder {
        protected String path = null;
        protected String cursor = null;
        protected Boolean directOnly = null;

        protected Builder() {
        }

        public Builder withPath(String path) {
            if (path != null && !Pattern.matches("((/|id:).*)|(rev:[0-9a-f]{9,})", path)) {
                throw new IllegalArgumentException("String 'path' does not match pattern");
            }
            this.path = path;
            return this;
        }

        public Builder withCursor(String cursor) {
            this.cursor = cursor;
            return this;
        }

        public Builder withDirectOnly(Boolean directOnly) {
            this.directOnly = directOnly;
            return this;
        }

        public ListSharedLinksArg build() {
            return new ListSharedLinksArg(this.path, this.cursor, this.directOnly);
        }
    }
}

