/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.sharing;

import com.dropbox.core.json.JsonUtil;
import com.dropbox.core.json.StructJsonDeserializer;
import com.dropbox.core.json.StructJsonSerializer;
import com.dropbox.core.v2.sharing.SharedLinkSettings;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.IOException;
import java.util.Arrays;

@JsonSerialize(using=Serializer.class)
@JsonDeserialize(using=Deserializer.class)
class ModifySharedLinkSettingsArgs {
    static final Serializer SERIALIZER = new Serializer();
    static final Deserializer DESERIALIZER = new Deserializer();
    protected final String url;
    protected final SharedLinkSettings settings;

    public ModifySharedLinkSettingsArgs(String url, SharedLinkSettings settings) {
        if (url == null) {
            throw new IllegalArgumentException("Required value for 'url' is null");
        }
        this.url = url;
        if (settings == null) {
            throw new IllegalArgumentException("Required value for 'settings' is null");
        }
        this.settings = settings;
    }

    public String getUrl() {
        return this.url;
    }

    public SharedLinkSettings getSettings() {
        return this.settings;
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.url, this.settings});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj.getClass().equals(this.getClass())) {
            ModifySharedLinkSettingsArgs other = (ModifySharedLinkSettingsArgs)obj;
            return !(this.url != other.url && !this.url.equals(other.url) || this.settings != other.settings && !this.settings.equals(other.settings));
        }
        return false;
    }

    public String toString() {
        return this.serialize(false);
    }

    public String toStringMultiline() {
        return this.serialize(true);
    }

    private String serialize(boolean longForm) {
        try {
            return JsonUtil.getMapper(longForm).writeValueAsString(this);
        }
        catch (JsonProcessingException ex) {
            throw new RuntimeException("Failed to serialize object", ex);
        }
    }

    static final class Deserializer
    extends StructJsonDeserializer<ModifySharedLinkSettingsArgs> {
        private static final long serialVersionUID = 0L;

        public Deserializer() {
            super(ModifySharedLinkSettingsArgs.class, new Class[0]);
        }

        public Deserializer(boolean unwrapping) {
            super(ModifySharedLinkSettingsArgs.class, unwrapping, new Class[0]);
        }

        @Override
        protected JsonDeserializer<ModifySharedLinkSettingsArgs> asUnwrapping() {
            return new Deserializer(true);
        }

        @Override
        public ModifySharedLinkSettingsArgs deserializeFields(JsonParser _p, DeserializationContext _ctx) throws IOException, JsonParseException {
            String url = null;
            SharedLinkSettings settings = null;
            while (_p.getCurrentToken() == JsonToken.FIELD_NAME) {
                String _field = _p.getCurrentName();
                _p.nextToken();
                if ("url".equals(_field)) {
                    url = Deserializer.getStringValue(_p);
                    _p.nextToken();
                    continue;
                }
                if ("settings".equals(_field)) {
                    settings = _p.readValueAs(SharedLinkSettings.class);
                    _p.nextToken();
                    continue;
                }
                Deserializer.skipValue(_p);
            }
            if (url == null) {
                throw new JsonParseException(_p, "Required field \"url\" is missing.");
            }
            if (settings == null) {
                throw new JsonParseException(_p, "Required field \"settings\" is missing.");
            }
            return new ModifySharedLinkSettingsArgs(url, settings);
        }
    }

    static final class Serializer
    extends StructJsonSerializer<ModifySharedLinkSettingsArgs> {
        private static final long serialVersionUID = 0L;

        public Serializer() {
            super(ModifySharedLinkSettingsArgs.class);
        }

        public Serializer(boolean unwrapping) {
            super(ModifySharedLinkSettingsArgs.class, unwrapping);
        }

        @Override
        protected JsonSerializer<ModifySharedLinkSettingsArgs> asUnwrapping() {
            return new Serializer(true);
        }

        @Override
        protected void serializeFields(ModifySharedLinkSettingsArgs value, JsonGenerator g, SerializerProvider provider) throws IOException, JsonProcessingException {
            g.writeObjectField("url", value.url);
            g.writeObjectField("settings", value.settings);
        }
    }
}

