/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.sharing;

import com.dropbox.core.json.JsonUtil;
import com.dropbox.core.json.UnionJsonDeserializer;
import com.dropbox.core.json.UnionJsonSerializer;
import com.dropbox.core.v2.sharing.SharedFolderAccessError;
import com.dropbox.core.v2.sharing.SharedFolderMemberError;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

@JsonSerialize(using=Serializer.class)
@JsonDeserialize(using=Deserializer.class)
public final class RemoveFolderMemberError {
    static final Serializer SERIALIZER = new Serializer();
    static final Deserializer DESERIALIZER = new Deserializer();
    public static final RemoveFolderMemberError FOLDER_OWNER = new RemoveFolderMemberError(Tag.FOLDER_OWNER, null, null);
    public static final RemoveFolderMemberError GROUP_ACCESS = new RemoveFolderMemberError(Tag.GROUP_ACCESS, null, null);
    public static final RemoveFolderMemberError TEAM_FOLDER = new RemoveFolderMemberError(Tag.TEAM_FOLDER, null, null);
    public static final RemoveFolderMemberError NO_PERMISSION = new RemoveFolderMemberError(Tag.NO_PERMISSION, null, null);
    public static final RemoveFolderMemberError OTHER = new RemoveFolderMemberError(Tag.OTHER, null, null);
    private final Tag tag;
    private final SharedFolderAccessError accessErrorValue;
    private final SharedFolderMemberError memberErrorValue;

    private RemoveFolderMemberError(Tag tag, SharedFolderAccessError accessErrorValue, SharedFolderMemberError memberErrorValue) {
        this.tag = tag;
        this.accessErrorValue = accessErrorValue;
        this.memberErrorValue = memberErrorValue;
    }

    public Tag tag() {
        return this.tag;
    }

    public boolean isAccessError() {
        return this.tag == Tag.ACCESS_ERROR;
    }

    public static RemoveFolderMemberError accessError(SharedFolderAccessError value) {
        if (value == null) {
            throw new IllegalArgumentException("Value is null");
        }
        return new RemoveFolderMemberError(Tag.ACCESS_ERROR, value, null);
    }

    public SharedFolderAccessError getAccessErrorValue() {
        if (this.tag != Tag.ACCESS_ERROR) {
            throw new IllegalStateException("Invalid tag: required Tag.ACCESS_ERROR, but was Tag." + this.tag.name());
        }
        return this.accessErrorValue;
    }

    public boolean isMemberError() {
        return this.tag == Tag.MEMBER_ERROR;
    }

    public static RemoveFolderMemberError memberError(SharedFolderMemberError value) {
        if (value == null) {
            throw new IllegalArgumentException("Value is null");
        }
        return new RemoveFolderMemberError(Tag.MEMBER_ERROR, null, value);
    }

    public SharedFolderMemberError getMemberErrorValue() {
        if (this.tag != Tag.MEMBER_ERROR) {
            throw new IllegalStateException("Invalid tag: required Tag.MEMBER_ERROR, but was Tag." + this.tag.name());
        }
        return this.memberErrorValue;
    }

    public boolean isFolderOwner() {
        return this.tag == Tag.FOLDER_OWNER;
    }

    public boolean isGroupAccess() {
        return this.tag == Tag.GROUP_ACCESS;
    }

    public boolean isTeamFolder() {
        return this.tag == Tag.TEAM_FOLDER;
    }

    public boolean isNoPermission() {
        return this.tag == Tag.NO_PERMISSION;
    }

    public boolean isOther() {
        return this.tag == Tag.OTHER;
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.tag, this.accessErrorValue, this.memberErrorValue});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof RemoveFolderMemberError) {
            RemoveFolderMemberError other = (RemoveFolderMemberError)obj;
            if (this.tag != other.tag) {
                return false;
            }
            switch (this.tag) {
                case ACCESS_ERROR: {
                    return this.accessErrorValue == other.accessErrorValue || this.accessErrorValue.equals((Object)other.accessErrorValue);
                }
                case MEMBER_ERROR: {
                    return this.memberErrorValue == other.memberErrorValue || this.memberErrorValue.equals((Object)other.memberErrorValue);
                }
                case FOLDER_OWNER: {
                    return true;
                }
                case GROUP_ACCESS: {
                    return true;
                }
                case TEAM_FOLDER: {
                    return true;
                }
                case NO_PERMISSION: {
                    return true;
                }
                case OTHER: {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    public String toString() {
        return this.serialize(false);
    }

    public String toStringMultiline() {
        return this.serialize(true);
    }

    private String serialize(boolean longForm) {
        try {
            return JsonUtil.getMapper(longForm).writeValueAsString(this);
        }
        catch (JsonProcessingException ex) {
            throw new RuntimeException("Failed to serialize object", ex);
        }
    }

    static final class Deserializer
    extends UnionJsonDeserializer<RemoveFolderMemberError, Tag> {
        private static final long serialVersionUID = 0L;

        public Deserializer() {
            super(RemoveFolderMemberError.class, Deserializer.getTagMapping(), Tag.OTHER, new Class[0]);
        }

        @Override
        public RemoveFolderMemberError deserialize(Tag _tag, JsonParser _p, DeserializationContext _ctx) throws IOException, JsonParseException {
            switch (_tag) {
                case ACCESS_ERROR: {
                    SharedFolderAccessError value = null;
                    Deserializer.expectField(_p, "access_error");
                    value = _p.readValueAs(SharedFolderAccessError.class);
                    _p.nextToken();
                    return RemoveFolderMemberError.accessError(value);
                }
                case MEMBER_ERROR: {
                    SharedFolderMemberError value = null;
                    Deserializer.expectField(_p, "member_error");
                    value = _p.readValueAs(SharedFolderMemberError.class);
                    _p.nextToken();
                    return RemoveFolderMemberError.memberError(value);
                }
                case FOLDER_OWNER: {
                    return FOLDER_OWNER;
                }
                case GROUP_ACCESS: {
                    return GROUP_ACCESS;
                }
                case TEAM_FOLDER: {
                    return TEAM_FOLDER;
                }
                case NO_PERMISSION: {
                    return NO_PERMISSION;
                }
                case OTHER: {
                    return OTHER;
                }
            }
            throw new IllegalStateException("Unparsed tag: \"" + (Object)((Object)_tag) + "\"");
        }

        private static Map<String, Tag> getTagMapping() {
            HashMap<String, Tag> values = new HashMap<String, Tag>();
            values.put("access_error", Tag.ACCESS_ERROR);
            values.put("member_error", Tag.MEMBER_ERROR);
            values.put("folder_owner", Tag.FOLDER_OWNER);
            values.put("group_access", Tag.GROUP_ACCESS);
            values.put("team_folder", Tag.TEAM_FOLDER);
            values.put("no_permission", Tag.NO_PERMISSION);
            values.put("other", Tag.OTHER);
            return Collections.unmodifiableMap(values);
        }
    }

    static final class Serializer
    extends UnionJsonSerializer<RemoveFolderMemberError> {
        private static final long serialVersionUID = 0L;

        public Serializer() {
            super(RemoveFolderMemberError.class, new Class[0]);
        }

        @Override
        public void serialize(RemoveFolderMemberError value, JsonGenerator g, SerializerProvider provider) throws IOException, JsonProcessingException {
            switch (value.tag) {
                case ACCESS_ERROR: {
                    g.writeStartObject();
                    g.writeStringField(".tag", "access_error");
                    g.writeObjectField("access_error", (Object)value.accessErrorValue);
                    g.writeEndObject();
                    break;
                }
                case MEMBER_ERROR: {
                    g.writeStartObject();
                    g.writeStringField(".tag", "member_error");
                    g.writeObjectField("member_error", (Object)value.memberErrorValue);
                    g.writeEndObject();
                    break;
                }
                case FOLDER_OWNER: {
                    g.writeString("folder_owner");
                    break;
                }
                case GROUP_ACCESS: {
                    g.writeString("group_access");
                    break;
                }
                case TEAM_FOLDER: {
                    g.writeString("team_folder");
                    break;
                }
                case NO_PERMISSION: {
                    g.writeString("no_permission");
                    break;
                }
                case OTHER: {
                    g.writeString("other");
                }
            }
        }
    }

    public static enum Tag {
        ACCESS_ERROR,
        MEMBER_ERROR,
        FOLDER_OWNER,
        GROUP_ACCESS,
        TEAM_FOLDER,
        NO_PERMISSION,
        OTHER;

    }
}

