/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.sharing;

import com.dropbox.core.json.JsonUtil;
import com.dropbox.core.json.StructJsonDeserializer;
import com.dropbox.core.json.StructJsonSerializer;
import com.dropbox.core.v2.sharing.AclUpdatePolicy;
import com.dropbox.core.v2.sharing.MemberPolicy;
import com.dropbox.core.v2.sharing.SharedLinkPolicy;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.IOException;
import java.util.Arrays;
import java.util.regex.Pattern;

@JsonSerialize(using=Serializer.class)
@JsonDeserialize(using=Deserializer.class)
class UpdateFolderPolicyArg {
    static final Serializer SERIALIZER = new Serializer();
    static final Deserializer DESERIALIZER = new Deserializer();
    protected final String sharedFolderId;
    protected final MemberPolicy memberPolicy;
    protected final AclUpdatePolicy aclUpdatePolicy;
    protected final SharedLinkPolicy sharedLinkPolicy;

    public UpdateFolderPolicyArg(String sharedFolderId, MemberPolicy memberPolicy, AclUpdatePolicy aclUpdatePolicy, SharedLinkPolicy sharedLinkPolicy) {
        if (sharedFolderId == null) {
            throw new IllegalArgumentException("Required value for 'sharedFolderId' is null");
        }
        if (!Pattern.matches("[-_0-9a-zA-Z:]+", sharedFolderId)) {
            throw new IllegalArgumentException("String 'sharedFolderId' does not match pattern");
        }
        this.sharedFolderId = sharedFolderId;
        this.memberPolicy = memberPolicy;
        this.aclUpdatePolicy = aclUpdatePolicy;
        this.sharedLinkPolicy = sharedLinkPolicy;
    }

    public UpdateFolderPolicyArg(String sharedFolderId) {
        this(sharedFolderId, null, null, null);
    }

    public String getSharedFolderId() {
        return this.sharedFolderId;
    }

    public MemberPolicy getMemberPolicy() {
        return this.memberPolicy;
    }

    public AclUpdatePolicy getAclUpdatePolicy() {
        return this.aclUpdatePolicy;
    }

    public SharedLinkPolicy getSharedLinkPolicy() {
        return this.sharedLinkPolicy;
    }

    public static Builder newBuilder(String sharedFolderId) {
        return new Builder(sharedFolderId);
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.sharedFolderId, this.memberPolicy, this.aclUpdatePolicy, this.sharedLinkPolicy});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj.getClass().equals(this.getClass())) {
            UpdateFolderPolicyArg other = (UpdateFolderPolicyArg)obj;
            return (this.sharedFolderId == other.sharedFolderId || this.sharedFolderId.equals(other.sharedFolderId)) && (this.memberPolicy == other.memberPolicy || this.memberPolicy != null && this.memberPolicy.equals((Object)other.memberPolicy)) && (this.aclUpdatePolicy == other.aclUpdatePolicy || this.aclUpdatePolicy != null && this.aclUpdatePolicy.equals((Object)other.aclUpdatePolicy)) && (this.sharedLinkPolicy == other.sharedLinkPolicy || this.sharedLinkPolicy != null && this.sharedLinkPolicy.equals((Object)other.sharedLinkPolicy));
        }
        return false;
    }

    public String toString() {
        return this.serialize(false);
    }

    public String toStringMultiline() {
        return this.serialize(true);
    }

    private String serialize(boolean longForm) {
        try {
            return JsonUtil.getMapper(longForm).writeValueAsString(this);
        }
        catch (JsonProcessingException ex) {
            throw new RuntimeException("Failed to serialize object", ex);
        }
    }

    static final class Deserializer
    extends StructJsonDeserializer<UpdateFolderPolicyArg> {
        private static final long serialVersionUID = 0L;

        public Deserializer() {
            super(UpdateFolderPolicyArg.class, new Class[0]);
        }

        public Deserializer(boolean unwrapping) {
            super(UpdateFolderPolicyArg.class, unwrapping, new Class[0]);
        }

        @Override
        protected JsonDeserializer<UpdateFolderPolicyArg> asUnwrapping() {
            return new Deserializer(true);
        }

        @Override
        public UpdateFolderPolicyArg deserializeFields(JsonParser _p, DeserializationContext _ctx) throws IOException, JsonParseException {
            String sharedFolderId = null;
            MemberPolicy memberPolicy = null;
            AclUpdatePolicy aclUpdatePolicy = null;
            SharedLinkPolicy sharedLinkPolicy = null;
            while (_p.getCurrentToken() == JsonToken.FIELD_NAME) {
                String _field = _p.getCurrentName();
                _p.nextToken();
                if ("shared_folder_id".equals(_field)) {
                    sharedFolderId = Deserializer.getStringValue(_p);
                    _p.nextToken();
                    continue;
                }
                if ("member_policy".equals(_field)) {
                    memberPolicy = _p.readValueAs(MemberPolicy.class);
                    _p.nextToken();
                    continue;
                }
                if ("acl_update_policy".equals(_field)) {
                    aclUpdatePolicy = _p.readValueAs(AclUpdatePolicy.class);
                    _p.nextToken();
                    continue;
                }
                if ("shared_link_policy".equals(_field)) {
                    sharedLinkPolicy = _p.readValueAs(SharedLinkPolicy.class);
                    _p.nextToken();
                    continue;
                }
                Deserializer.skipValue(_p);
            }
            if (sharedFolderId == null) {
                throw new JsonParseException(_p, "Required field \"shared_folder_id\" is missing.");
            }
            return new UpdateFolderPolicyArg(sharedFolderId, memberPolicy, aclUpdatePolicy, sharedLinkPolicy);
        }
    }

    static final class Serializer
    extends StructJsonSerializer<UpdateFolderPolicyArg> {
        private static final long serialVersionUID = 0L;

        public Serializer() {
            super(UpdateFolderPolicyArg.class);
        }

        public Serializer(boolean unwrapping) {
            super(UpdateFolderPolicyArg.class, unwrapping);
        }

        @Override
        protected JsonSerializer<UpdateFolderPolicyArg> asUnwrapping() {
            return new Serializer(true);
        }

        @Override
        protected void serializeFields(UpdateFolderPolicyArg value, JsonGenerator g, SerializerProvider provider) throws IOException, JsonProcessingException {
            g.writeObjectField("shared_folder_id", value.sharedFolderId);
            if (value.memberPolicy != null) {
                g.writeObjectField("member_policy", (Object)value.memberPolicy);
            }
            if (value.aclUpdatePolicy != null) {
                g.writeObjectField("acl_update_policy", (Object)value.aclUpdatePolicy);
            }
            if (value.sharedLinkPolicy != null) {
                g.writeObjectField("shared_link_policy", (Object)value.sharedLinkPolicy);
            }
        }
    }

    public static class Builder {
        protected final String sharedFolderId;
        protected MemberPolicy memberPolicy;
        protected AclUpdatePolicy aclUpdatePolicy;
        protected SharedLinkPolicy sharedLinkPolicy;

        protected Builder(String sharedFolderId) {
            if (sharedFolderId == null) {
                throw new IllegalArgumentException("Required value for 'sharedFolderId' is null");
            }
            if (!Pattern.matches("[-_0-9a-zA-Z:]+", sharedFolderId)) {
                throw new IllegalArgumentException("String 'sharedFolderId' does not match pattern");
            }
            this.sharedFolderId = sharedFolderId;
            this.memberPolicy = null;
            this.aclUpdatePolicy = null;
            this.sharedLinkPolicy = null;
        }

        public Builder withMemberPolicy(MemberPolicy memberPolicy) {
            this.memberPolicy = memberPolicy;
            return this;
        }

        public Builder withAclUpdatePolicy(AclUpdatePolicy aclUpdatePolicy) {
            this.aclUpdatePolicy = aclUpdatePolicy;
            return this;
        }

        public Builder withSharedLinkPolicy(SharedLinkPolicy sharedLinkPolicy) {
            this.sharedLinkPolicy = sharedLinkPolicy;
            return this;
        }

        public UpdateFolderPolicyArg build() {
            return new UpdateFolderPolicyArg(this.sharedFolderId, this.memberPolicy, this.aclUpdatePolicy, this.sharedLinkPolicy);
        }
    }
}

