/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.team;

import com.dropbox.core.json.JsonUtil;
import com.dropbox.core.json.StructJsonDeserializer;
import com.dropbox.core.json.StructJsonSerializer;
import com.dropbox.core.v2.team.BaseDfbReport;
import com.dropbox.core.v2.team.StorageBucket;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

@JsonSerialize(using=Serializer.class)
@JsonDeserialize(using=Deserializer.class)
public class GetStorageReport
extends BaseDfbReport {
    static final Serializer SERIALIZER = new Serializer();
    static final Deserializer DESERIALIZER = new Deserializer();
    protected final List<Long> totalUsage;
    protected final List<Long> sharedUsage;
    protected final List<Long> unsharedUsage;
    protected final List<Long> sharedFolders;
    protected final List<List<StorageBucket>> memberStorageMap;

    public GetStorageReport(String startDate, List<Long> totalUsage, List<Long> sharedUsage, List<Long> unsharedUsage, List<Long> sharedFolders, List<List<StorageBucket>> memberStorageMap) {
        super(startDate);
        if (totalUsage == null) {
            throw new IllegalArgumentException("Required value for 'totalUsage' is null");
        }
        Iterator<Object> iterator = totalUsage.iterator();
        if (iterator.hasNext()) {
            Long l = iterator.next();
            if (l == null) {
                throw new IllegalArgumentException("An item in list 'totalUsage' is null");
            }
            throw new RuntimeException("XXX Don't know how to validate an item in list 'totalUsage': type Nullable");
        }
        this.totalUsage = totalUsage;
        if (sharedUsage == null) {
            throw new IllegalArgumentException("Required value for 'sharedUsage' is null");
        }
        iterator = sharedUsage.iterator();
        if (iterator.hasNext()) {
            Long l = iterator.next();
            if (l == null) {
                throw new IllegalArgumentException("An item in list 'sharedUsage' is null");
            }
            throw new RuntimeException("XXX Don't know how to validate an item in list 'sharedUsage': type Nullable");
        }
        this.sharedUsage = sharedUsage;
        if (unsharedUsage == null) {
            throw new IllegalArgumentException("Required value for 'unsharedUsage' is null");
        }
        iterator = unsharedUsage.iterator();
        if (iterator.hasNext()) {
            Long l = iterator.next();
            if (l == null) {
                throw new IllegalArgumentException("An item in list 'unsharedUsage' is null");
            }
            throw new RuntimeException("XXX Don't know how to validate an item in list 'unsharedUsage': type Nullable");
        }
        this.unsharedUsage = unsharedUsage;
        if (sharedFolders == null) {
            throw new IllegalArgumentException("Required value for 'sharedFolders' is null");
        }
        iterator = sharedFolders.iterator();
        if (iterator.hasNext()) {
            Long l = iterator.next();
            if (l == null) {
                throw new IllegalArgumentException("An item in list 'sharedFolders' is null");
            }
            throw new RuntimeException("XXX Don't know how to validate an item in list 'sharedFolders': type Nullable");
        }
        this.sharedFolders = sharedFolders;
        if (memberStorageMap == null) {
            throw new IllegalArgumentException("Required value for 'memberStorageMap' is null");
        }
        for (List list : memberStorageMap) {
            if (list == null) {
                throw new IllegalArgumentException("An item in list 'memberStorageMap' is null");
            }
            for (StorageBucket x1 : list) {
                if (x1 != null) continue;
                throw new IllegalArgumentException("An item in listan item in list 'memberStorageMap' is null");
            }
        }
        this.memberStorageMap = memberStorageMap;
    }

    public List<Long> getTotalUsage() {
        return this.totalUsage;
    }

    public List<Long> getSharedUsage() {
        return this.sharedUsage;
    }

    public List<Long> getUnsharedUsage() {
        return this.unsharedUsage;
    }

    public List<Long> getSharedFolders() {
        return this.sharedFolders;
    }

    public List<List<StorageBucket>> getMemberStorageMap() {
        return this.memberStorageMap;
    }

    @Override
    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.totalUsage, this.sharedUsage, this.unsharedUsage, this.sharedFolders, this.memberStorageMap});
        hash = 31 * super.hashCode() + hash;
        return hash;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj.getClass().equals(this.getClass())) {
            GetStorageReport other = (GetStorageReport)obj;
            return !(this.startDate != other.startDate && !this.startDate.equals(other.startDate) || this.totalUsage != other.totalUsage && !this.totalUsage.equals(other.totalUsage) || this.sharedUsage != other.sharedUsage && !this.sharedUsage.equals(other.sharedUsage) || this.unsharedUsage != other.unsharedUsage && !this.unsharedUsage.equals(other.unsharedUsage) || this.sharedFolders != other.sharedFolders && !this.sharedFolders.equals(other.sharedFolders) || this.memberStorageMap != other.memberStorageMap && !this.memberStorageMap.equals(other.memberStorageMap));
        }
        return false;
    }

    @Override
    public String toString() {
        return this.serialize(false);
    }

    @Override
    public String toStringMultiline() {
        return this.serialize(true);
    }

    private String serialize(boolean longForm) {
        try {
            return JsonUtil.getMapper(longForm).writeValueAsString(this);
        }
        catch (JsonProcessingException ex) {
            throw new RuntimeException("Failed to serialize object", ex);
        }
    }

    static final class Deserializer
    extends StructJsonDeserializer<GetStorageReport> {
        private static final long serialVersionUID = 0L;

        public Deserializer() {
            super(GetStorageReport.class, new Class[0]);
        }

        public Deserializer(boolean unwrapping) {
            super(GetStorageReport.class, unwrapping, new Class[0]);
        }

        @Override
        protected JsonDeserializer<GetStorageReport> asUnwrapping() {
            return new Deserializer(true);
        }

        @Override
        public GetStorageReport deserializeFields(JsonParser _p, DeserializationContext _ctx) throws IOException, JsonParseException {
            String startDate = null;
            ArrayList<Long> totalUsage = null;
            ArrayList<Long> sharedUsage = null;
            ArrayList<Long> unsharedUsage = null;
            ArrayList<Serializable> sharedFolders = null;
            ArrayList<Serializable> memberStorageMap = null;
            while (_p.getCurrentToken() == JsonToken.FIELD_NAME) {
                Serializable _x;
                String _field = _p.getCurrentName();
                _p.nextToken();
                if ("start_date".equals(_field)) {
                    startDate = Deserializer.getStringValue(_p);
                    _p.nextToken();
                    continue;
                }
                if ("total_usage".equals(_field)) {
                    Deserializer.expectArrayStart(_p);
                    totalUsage = new ArrayList<Long>();
                    while (!Deserializer.isArrayEnd(_p)) {
                        _x = null;
                        _x = Long.valueOf(_p.getLongValue());
                        Deserializer.assertUnsigned(_p, (Number)_x);
                        _p.nextToken();
                        totalUsage.add((Long)_x);
                    }
                    Deserializer.expectArrayEnd(_p);
                    _p.nextToken();
                    continue;
                }
                if ("shared_usage".equals(_field)) {
                    Deserializer.expectArrayStart(_p);
                    sharedUsage = new ArrayList<Long>();
                    while (!Deserializer.isArrayEnd(_p)) {
                        _x = null;
                        _x = Long.valueOf(_p.getLongValue());
                        Deserializer.assertUnsigned(_p, (Number)_x);
                        _p.nextToken();
                        sharedUsage.add((Long)_x);
                    }
                    Deserializer.expectArrayEnd(_p);
                    _p.nextToken();
                    continue;
                }
                if ("unshared_usage".equals(_field)) {
                    Deserializer.expectArrayStart(_p);
                    unsharedUsage = new ArrayList<Long>();
                    while (!Deserializer.isArrayEnd(_p)) {
                        _x = null;
                        _x = Long.valueOf(_p.getLongValue());
                        Deserializer.assertUnsigned(_p, (Number)_x);
                        _p.nextToken();
                        unsharedUsage.add((Long)_x);
                    }
                    Deserializer.expectArrayEnd(_p);
                    _p.nextToken();
                    continue;
                }
                if ("shared_folders".equals(_field)) {
                    Deserializer.expectArrayStart(_p);
                    sharedFolders = new ArrayList<Serializable>();
                    while (!Deserializer.isArrayEnd(_p)) {
                        _x = null;
                        _x = Long.valueOf(_p.getLongValue());
                        Deserializer.assertUnsigned(_p, (Number)_x);
                        _p.nextToken();
                        sharedFolders.add(_x);
                    }
                    Deserializer.expectArrayEnd(_p);
                    _p.nextToken();
                    continue;
                }
                if ("member_storage_map".equals(_field)) {
                    Deserializer.expectArrayStart(_p);
                    memberStorageMap = new ArrayList<Serializable>();
                    while (!Deserializer.isArrayEnd(_p)) {
                        _x = null;
                        Deserializer.expectArrayStart(_p);
                        _x = new ArrayList();
                        while (!Deserializer.isArrayEnd(_p)) {
                            StorageBucket _x1 = null;
                            _x1 = _p.readValueAs(StorageBucket.class);
                            _p.nextToken();
                            _x.add(_x1);
                        }
                        Deserializer.expectArrayEnd(_p);
                        _p.nextToken();
                        memberStorageMap.add(_x);
                    }
                    Deserializer.expectArrayEnd(_p);
                    _p.nextToken();
                    continue;
                }
                Deserializer.skipValue(_p);
            }
            if (startDate == null) {
                throw new JsonParseException(_p, "Required field \"start_date\" is missing.");
            }
            if (totalUsage == null) {
                throw new JsonParseException(_p, "Required field \"total_usage\" is missing.");
            }
            if (sharedUsage == null) {
                throw new JsonParseException(_p, "Required field \"shared_usage\" is missing.");
            }
            if (unsharedUsage == null) {
                throw new JsonParseException(_p, "Required field \"unshared_usage\" is missing.");
            }
            if (sharedFolders == null) {
                throw new JsonParseException(_p, "Required field \"shared_folders\" is missing.");
            }
            if (memberStorageMap == null) {
                throw new JsonParseException(_p, "Required field \"member_storage_map\" is missing.");
            }
            return new GetStorageReport(startDate, totalUsage, sharedUsage, unsharedUsage, sharedFolders, memberStorageMap);
        }
    }

    static final class Serializer
    extends StructJsonSerializer<GetStorageReport> {
        private static final long serialVersionUID = 0L;

        public Serializer() {
            super(GetStorageReport.class);
        }

        public Serializer(boolean unwrapping) {
            super(GetStorageReport.class, unwrapping);
        }

        @Override
        protected JsonSerializer<GetStorageReport> asUnwrapping() {
            return new Serializer(true);
        }

        @Override
        protected void serializeFields(GetStorageReport value, JsonGenerator g, SerializerProvider provider) throws IOException, JsonProcessingException {
            g.writeObjectField("start_date", value.startDate);
            g.writeObjectField("total_usage", value.totalUsage);
            g.writeObjectField("shared_usage", value.sharedUsage);
            g.writeObjectField("unshared_usage", value.unsharedUsage);
            g.writeObjectField("shared_folders", value.sharedFolders);
            g.writeObjectField("member_storage_map", value.memberStorageMap);
        }
    }
}

