/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.team;

import com.dropbox.core.json.JsonUtil;
import com.dropbox.core.json.StructJsonDeserializer;
import com.dropbox.core.json.StructJsonSerializer;
import com.dropbox.core.v2.team.GroupSelector;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.IOException;
import java.util.Arrays;

@JsonSerialize(using=Serializer.class)
@JsonDeserialize(using=Deserializer.class)
class GroupUpdateArgs {
    static final Serializer SERIALIZER = new Serializer();
    static final Deserializer DESERIALIZER = new Deserializer();
    protected final GroupSelector group;
    protected final String newGroupName;
    protected final String newGroupExternalId;

    public GroupUpdateArgs(GroupSelector group, String newGroupName, String newGroupExternalId) {
        if (group == null) {
            throw new IllegalArgumentException("Required value for 'group' is null");
        }
        this.group = group;
        this.newGroupName = newGroupName;
        this.newGroupExternalId = newGroupExternalId;
    }

    public GroupUpdateArgs(GroupSelector group) {
        this(group, null, null);
    }

    public GroupSelector getGroup() {
        return this.group;
    }

    public String getNewGroupName() {
        return this.newGroupName;
    }

    public String getNewGroupExternalId() {
        return this.newGroupExternalId;
    }

    public static Builder newBuilder(GroupSelector group) {
        return new Builder(group);
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.group, this.newGroupName, this.newGroupExternalId});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj.getClass().equals(this.getClass())) {
            GroupUpdateArgs other = (GroupUpdateArgs)obj;
            return (this.group == other.group || this.group.equals(other.group)) && (this.newGroupName == other.newGroupName || this.newGroupName != null && this.newGroupName.equals(other.newGroupName)) && (this.newGroupExternalId == other.newGroupExternalId || this.newGroupExternalId != null && this.newGroupExternalId.equals(other.newGroupExternalId));
        }
        return false;
    }

    public String toString() {
        return this.serialize(false);
    }

    public String toStringMultiline() {
        return this.serialize(true);
    }

    private String serialize(boolean longForm) {
        try {
            return JsonUtil.getMapper(longForm).writeValueAsString(this);
        }
        catch (JsonProcessingException ex) {
            throw new RuntimeException("Failed to serialize object", ex);
        }
    }

    static final class Deserializer
    extends StructJsonDeserializer<GroupUpdateArgs> {
        private static final long serialVersionUID = 0L;

        public Deserializer() {
            super(GroupUpdateArgs.class, new Class[0]);
        }

        public Deserializer(boolean unwrapping) {
            super(GroupUpdateArgs.class, unwrapping, new Class[0]);
        }

        @Override
        protected JsonDeserializer<GroupUpdateArgs> asUnwrapping() {
            return new Deserializer(true);
        }

        @Override
        public GroupUpdateArgs deserializeFields(JsonParser _p, DeserializationContext _ctx) throws IOException, JsonParseException {
            GroupSelector group = null;
            String newGroupName = null;
            String newGroupExternalId = null;
            while (_p.getCurrentToken() == JsonToken.FIELD_NAME) {
                String _field = _p.getCurrentName();
                _p.nextToken();
                if ("group".equals(_field)) {
                    group = _p.readValueAs(GroupSelector.class);
                    _p.nextToken();
                    continue;
                }
                if ("new_group_name".equals(_field)) {
                    newGroupName = Deserializer.getStringValue(_p);
                    _p.nextToken();
                    continue;
                }
                if ("new_group_external_id".equals(_field)) {
                    newGroupExternalId = Deserializer.getStringValue(_p);
                    _p.nextToken();
                    continue;
                }
                Deserializer.skipValue(_p);
            }
            if (group == null) {
                throw new JsonParseException(_p, "Required field \"group\" is missing.");
            }
            return new GroupUpdateArgs(group, newGroupName, newGroupExternalId);
        }
    }

    static final class Serializer
    extends StructJsonSerializer<GroupUpdateArgs> {
        private static final long serialVersionUID = 0L;

        public Serializer() {
            super(GroupUpdateArgs.class);
        }

        public Serializer(boolean unwrapping) {
            super(GroupUpdateArgs.class, unwrapping);
        }

        @Override
        protected JsonSerializer<GroupUpdateArgs> asUnwrapping() {
            return new Serializer(true);
        }

        @Override
        protected void serializeFields(GroupUpdateArgs value, JsonGenerator g, SerializerProvider provider) throws IOException, JsonProcessingException {
            g.writeObjectField("group", value.group);
            if (value.newGroupName != null) {
                g.writeObjectField("new_group_name", value.newGroupName);
            }
            if (value.newGroupExternalId != null) {
                g.writeObjectField("new_group_external_id", value.newGroupExternalId);
            }
        }
    }

    public static class Builder {
        protected final GroupSelector group;
        protected String newGroupName;
        protected String newGroupExternalId;

        protected Builder(GroupSelector group) {
            if (group == null) {
                throw new IllegalArgumentException("Required value for 'group' is null");
            }
            this.group = group;
            this.newGroupName = null;
            this.newGroupExternalId = null;
        }

        public Builder withNewGroupName(String newGroupName) {
            this.newGroupName = newGroupName;
            return this;
        }

        public Builder withNewGroupExternalId(String newGroupExternalId) {
            this.newGroupExternalId = newGroupExternalId;
            return this;
        }

        public GroupUpdateArgs build() {
            return new GroupUpdateArgs(this.group, this.newGroupName, this.newGroupExternalId);
        }
    }
}

