/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.team;

import com.dropbox.core.json.JsonUtil;
import com.dropbox.core.json.UnionJsonDeserializer;
import com.dropbox.core.json.UnionJsonSerializer;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@JsonSerialize(using=Serializer.class)
@JsonDeserialize(using=Deserializer.class)
public final class GroupsSelector {
    static final Serializer SERIALIZER = new Serializer();
    static final Deserializer DESERIALIZER = new Deserializer();
    private final Tag tag;
    private final List<String> groupIdsValue;
    private final List<String> groupExternalIdsValue;

    private GroupsSelector(Tag tag, List<String> groupIdsValue, List<String> groupExternalIdsValue) {
        this.tag = tag;
        this.groupIdsValue = groupIdsValue;
        this.groupExternalIdsValue = groupExternalIdsValue;
    }

    public Tag tag() {
        return this.tag;
    }

    public boolean isGroupIds() {
        return this.tag == Tag.GROUP_IDS;
    }

    public static GroupsSelector groupIds(List<String> value) {
        if (value == null) {
            throw new IllegalArgumentException("Value is null");
        }
        for (String x : value) {
            if (x != null) continue;
            throw new IllegalArgumentException("An item in list is null");
        }
        return new GroupsSelector(Tag.GROUP_IDS, value, null);
    }

    public List<String> getGroupIdsValue() {
        if (this.tag != Tag.GROUP_IDS) {
            throw new IllegalStateException("Invalid tag: required Tag.GROUP_IDS, but was Tag." + this.tag.name());
        }
        return this.groupIdsValue;
    }

    public boolean isGroupExternalIds() {
        return this.tag == Tag.GROUP_EXTERNAL_IDS;
    }

    public static GroupsSelector groupExternalIds(List<String> value) {
        if (value == null) {
            throw new IllegalArgumentException("Value is null");
        }
        for (String x : value) {
            if (x != null) continue;
            throw new IllegalArgumentException("An item in list is null");
        }
        return new GroupsSelector(Tag.GROUP_EXTERNAL_IDS, null, value);
    }

    public List<String> getGroupExternalIdsValue() {
        if (this.tag != Tag.GROUP_EXTERNAL_IDS) {
            throw new IllegalStateException("Invalid tag: required Tag.GROUP_EXTERNAL_IDS, but was Tag." + this.tag.name());
        }
        return this.groupExternalIdsValue;
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.tag, this.groupIdsValue, this.groupExternalIdsValue});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof GroupsSelector) {
            GroupsSelector other = (GroupsSelector)obj;
            if (this.tag != other.tag) {
                return false;
            }
            switch (this.tag) {
                case GROUP_IDS: {
                    return this.groupIdsValue == other.groupIdsValue || this.groupIdsValue.equals(other.groupIdsValue);
                }
                case GROUP_EXTERNAL_IDS: {
                    return this.groupExternalIdsValue == other.groupExternalIdsValue || this.groupExternalIdsValue.equals(other.groupExternalIdsValue);
                }
            }
            return false;
        }
        return false;
    }

    public String toString() {
        return this.serialize(false);
    }

    public String toStringMultiline() {
        return this.serialize(true);
    }

    private String serialize(boolean longForm) {
        try {
            return JsonUtil.getMapper(longForm).writeValueAsString(this);
        }
        catch (JsonProcessingException ex) {
            throw new RuntimeException("Failed to serialize object", ex);
        }
    }

    static final class Deserializer
    extends UnionJsonDeserializer<GroupsSelector, Tag> {
        private static final long serialVersionUID = 0L;

        public Deserializer() {
            super(GroupsSelector.class, Deserializer.getTagMapping(), null, new Class[0]);
        }

        @Override
        public GroupsSelector deserialize(Tag _tag, JsonParser _p, DeserializationContext _ctx) throws IOException, JsonParseException {
            switch (_tag) {
                case GROUP_IDS: {
                    ArrayList<String> value = null;
                    Deserializer.expectField(_p, "group_ids");
                    Deserializer.expectArrayStart(_p);
                    value = new ArrayList<String>();
                    while (!Deserializer.isArrayEnd(_p)) {
                        String _x = null;
                        _x = Deserializer.getStringValue(_p);
                        _p.nextToken();
                        value.add(_x);
                    }
                    Deserializer.expectArrayEnd(_p);
                    _p.nextToken();
                    return GroupsSelector.groupIds(value);
                }
                case GROUP_EXTERNAL_IDS: {
                    ArrayList<String> value = null;
                    Deserializer.expectField(_p, "group_external_ids");
                    Deserializer.expectArrayStart(_p);
                    value = new ArrayList<String>();
                    while (!Deserializer.isArrayEnd(_p)) {
                        String _x = null;
                        _x = Deserializer.getStringValue(_p);
                        _p.nextToken();
                        value.add(_x);
                    }
                    Deserializer.expectArrayEnd(_p);
                    _p.nextToken();
                    return GroupsSelector.groupExternalIds(value);
                }
            }
            throw new IllegalStateException("Unparsed tag: \"" + (Object)((Object)_tag) + "\"");
        }

        private static Map<String, Tag> getTagMapping() {
            HashMap<String, Tag> values = new HashMap<String, Tag>();
            values.put("group_ids", Tag.GROUP_IDS);
            values.put("group_external_ids", Tag.GROUP_EXTERNAL_IDS);
            return Collections.unmodifiableMap(values);
        }
    }

    static final class Serializer
    extends UnionJsonSerializer<GroupsSelector> {
        private static final long serialVersionUID = 0L;

        public Serializer() {
            super(GroupsSelector.class, new Class[0]);
        }

        @Override
        public void serialize(GroupsSelector value, JsonGenerator g, SerializerProvider provider) throws IOException, JsonProcessingException {
            switch (value.tag) {
                case GROUP_IDS: {
                    g.writeStartObject();
                    g.writeStringField(".tag", "group_ids");
                    g.writeObjectField("group_ids", value.groupIdsValue);
                    g.writeEndObject();
                    break;
                }
                case GROUP_EXTERNAL_IDS: {
                    g.writeStartObject();
                    g.writeStringField(".tag", "group_external_ids");
                    g.writeObjectField("group_external_ids", value.groupExternalIdsValue);
                    g.writeEndObject();
                }
            }
        }
    }

    public static enum Tag {
        GROUP_IDS,
        GROUP_EXTERNAL_IDS;

    }
}

