/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.team;

import com.dropbox.core.json.JsonUtil;
import com.dropbox.core.json.StructJsonDeserializer;
import com.dropbox.core.json.StructJsonSerializer;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.IOException;
import java.util.Arrays;

@JsonSerialize(using=Serializer.class)
@JsonDeserialize(using=Deserializer.class)
class ListTeamDevicesArg {
    static final Serializer SERIALIZER = new Serializer();
    static final Deserializer DESERIALIZER = new Deserializer();
    protected final String cursor;
    protected final boolean includeWebSessions;
    protected final boolean includeDesktopClients;
    protected final boolean includeMobileClients;

    public ListTeamDevicesArg(String cursor, boolean includeWebSessions, boolean includeDesktopClients, boolean includeMobileClients) {
        this.cursor = cursor;
        this.includeWebSessions = includeWebSessions;
        this.includeDesktopClients = includeDesktopClients;
        this.includeMobileClients = includeMobileClients;
    }

    public ListTeamDevicesArg() {
        this(null, true, true, true);
    }

    public String getCursor() {
        return this.cursor;
    }

    public boolean getIncludeWebSessions() {
        return this.includeWebSessions;
    }

    public boolean getIncludeDesktopClients() {
        return this.includeDesktopClients;
    }

    public boolean getIncludeMobileClients() {
        return this.includeMobileClients;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.cursor, this.includeWebSessions, this.includeDesktopClients, this.includeMobileClients});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj.getClass().equals(this.getClass())) {
            ListTeamDevicesArg other = (ListTeamDevicesArg)obj;
            return (this.cursor == other.cursor || this.cursor != null && this.cursor.equals(other.cursor)) && this.includeWebSessions == other.includeWebSessions && this.includeDesktopClients == other.includeDesktopClients && this.includeMobileClients == other.includeMobileClients;
        }
        return false;
    }

    public String toString() {
        return this.serialize(false);
    }

    public String toStringMultiline() {
        return this.serialize(true);
    }

    private String serialize(boolean longForm) {
        try {
            return JsonUtil.getMapper(longForm).writeValueAsString(this);
        }
        catch (JsonProcessingException ex) {
            throw new RuntimeException("Failed to serialize object", ex);
        }
    }

    static final class Deserializer
    extends StructJsonDeserializer<ListTeamDevicesArg> {
        private static final long serialVersionUID = 0L;

        public Deserializer() {
            super(ListTeamDevicesArg.class, new Class[0]);
        }

        public Deserializer(boolean unwrapping) {
            super(ListTeamDevicesArg.class, unwrapping, new Class[0]);
        }

        @Override
        protected JsonDeserializer<ListTeamDevicesArg> asUnwrapping() {
            return new Deserializer(true);
        }

        @Override
        public ListTeamDevicesArg deserializeFields(JsonParser _p, DeserializationContext _ctx) throws IOException, JsonParseException {
            String cursor = null;
            Boolean includeWebSessions = null;
            Boolean includeDesktopClients = null;
            Boolean includeMobileClients = null;
            while (_p.getCurrentToken() == JsonToken.FIELD_NAME) {
                String _field = _p.getCurrentName();
                _p.nextToken();
                if ("cursor".equals(_field)) {
                    cursor = Deserializer.getStringValue(_p);
                    _p.nextToken();
                    continue;
                }
                if ("include_web_sessions".equals(_field)) {
                    includeWebSessions = _p.getValueAsBoolean();
                    _p.nextToken();
                    continue;
                }
                if ("include_desktop_clients".equals(_field)) {
                    includeDesktopClients = _p.getValueAsBoolean();
                    _p.nextToken();
                    continue;
                }
                if ("include_mobile_clients".equals(_field)) {
                    includeMobileClients = _p.getValueAsBoolean();
                    _p.nextToken();
                    continue;
                }
                Deserializer.skipValue(_p);
            }
            return new ListTeamDevicesArg(cursor, includeWebSessions, includeDesktopClients, includeMobileClients);
        }
    }

    static final class Serializer
    extends StructJsonSerializer<ListTeamDevicesArg> {
        private static final long serialVersionUID = 0L;

        public Serializer() {
            super(ListTeamDevicesArg.class);
        }

        public Serializer(boolean unwrapping) {
            super(ListTeamDevicesArg.class, unwrapping);
        }

        @Override
        protected JsonSerializer<ListTeamDevicesArg> asUnwrapping() {
            return new Serializer(true);
        }

        @Override
        protected void serializeFields(ListTeamDevicesArg value, JsonGenerator g, SerializerProvider provider) throws IOException, JsonProcessingException {
            if (value.cursor != null) {
                g.writeObjectField("cursor", value.cursor);
            }
            g.writeObjectField("include_web_sessions", value.includeWebSessions);
            g.writeObjectField("include_desktop_clients", value.includeDesktopClients);
            g.writeObjectField("include_mobile_clients", value.includeMobileClients);
        }
    }

    public static class Builder {
        protected String cursor = null;
        protected boolean includeWebSessions = true;
        protected boolean includeDesktopClients = true;
        protected boolean includeMobileClients = true;

        protected Builder() {
        }

        public Builder withCursor(String cursor) {
            this.cursor = cursor;
            return this;
        }

        public Builder withIncludeWebSessions(Boolean includeWebSessions) {
            this.includeWebSessions = includeWebSessions != null ? includeWebSessions : true;
            return this;
        }

        public Builder withIncludeDesktopClients(Boolean includeDesktopClients) {
            this.includeDesktopClients = includeDesktopClients != null ? includeDesktopClients : true;
            return this;
        }

        public Builder withIncludeMobileClients(Boolean includeMobileClients) {
            this.includeMobileClients = includeMobileClients != null ? includeMobileClients : true;
            return this;
        }

        public ListTeamDevicesArg build() {
            return new ListTeamDevicesArg(this.cursor, this.includeWebSessions, this.includeDesktopClients, this.includeMobileClients);
        }
    }
}

