/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.team;

import com.dropbox.core.json.JsonUtil;
import com.dropbox.core.json.StructJsonDeserializer;
import com.dropbox.core.json.StructJsonSerializer;
import com.dropbox.core.v2.team.DeviceSession;
import com.dropbox.core.v2.team.MobileClientPlatform;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.IOException;
import java.util.Arrays;
import java.util.Date;

@JsonSerialize(using=Serializer.class)
@JsonDeserialize(using=Deserializer.class)
public class MobileClientSession
extends DeviceSession {
    static final Serializer SERIALIZER = new Serializer();
    static final Deserializer DESERIALIZER = new Deserializer();
    protected final String deviceName;
    protected final MobileClientPlatform clientType;
    protected final String clientVersion;
    protected final String osVersion;
    protected final String lastCarrier;

    public MobileClientSession(String sessionId, String deviceName, MobileClientPlatform clientType, String ipAddress, String country, Date created, Date updated, String clientVersion, String osVersion, String lastCarrier) {
        super(sessionId, ipAddress, country, created, updated);
        if (deviceName == null) {
            throw new IllegalArgumentException("Required value for 'deviceName' is null");
        }
        this.deviceName = deviceName;
        if (clientType == null) {
            throw new IllegalArgumentException("Required value for 'clientType' is null");
        }
        this.clientType = clientType;
        this.clientVersion = clientVersion;
        this.osVersion = osVersion;
        this.lastCarrier = lastCarrier;
    }

    public MobileClientSession(String sessionId, String deviceName, MobileClientPlatform clientType) {
        this(sessionId, deviceName, clientType, null, null, null, null, null, null, null);
    }

    public String getDeviceName() {
        return this.deviceName;
    }

    public MobileClientPlatform getClientType() {
        return this.clientType;
    }

    public String getClientVersion() {
        return this.clientVersion;
    }

    public String getOsVersion() {
        return this.osVersion;
    }

    public String getLastCarrier() {
        return this.lastCarrier;
    }

    public static Builder newBuilder(String sessionId, String deviceName, MobileClientPlatform clientType) {
        return new Builder(sessionId, deviceName, clientType);
    }

    @Override
    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.deviceName, this.clientType, this.clientVersion, this.osVersion, this.lastCarrier});
        hash = 31 * super.hashCode() + hash;
        return hash;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj.getClass().equals(this.getClass())) {
            MobileClientSession other = (MobileClientSession)obj;
            return !(this.sessionId != other.sessionId && !this.sessionId.equals(other.sessionId) || this.deviceName != other.deviceName && !this.deviceName.equals(other.deviceName) || this.clientType != other.clientType && !this.clientType.equals((Object)other.clientType) || this.ipAddress != other.ipAddress && (this.ipAddress == null || !this.ipAddress.equals(other.ipAddress)) || this.country != other.country && (this.country == null || !this.country.equals(other.country)) || this.created != other.created && (this.created == null || !this.created.equals(other.created)) || this.updated != other.updated && (this.updated == null || !this.updated.equals(other.updated)) || this.clientVersion != other.clientVersion && (this.clientVersion == null || !this.clientVersion.equals(other.clientVersion)) || this.osVersion != other.osVersion && (this.osVersion == null || !this.osVersion.equals(other.osVersion)) || this.lastCarrier != other.lastCarrier && (this.lastCarrier == null || !this.lastCarrier.equals(other.lastCarrier)));
        }
        return false;
    }

    @Override
    public String toString() {
        return this.serialize(false);
    }

    @Override
    public String toStringMultiline() {
        return this.serialize(true);
    }

    private String serialize(boolean longForm) {
        try {
            return JsonUtil.getMapper(longForm).writeValueAsString(this);
        }
        catch (JsonProcessingException ex) {
            throw new RuntimeException("Failed to serialize object", ex);
        }
    }

    static final class Deserializer
    extends StructJsonDeserializer<MobileClientSession> {
        private static final long serialVersionUID = 0L;

        public Deserializer() {
            super(MobileClientSession.class, new Class[0]);
        }

        public Deserializer(boolean unwrapping) {
            super(MobileClientSession.class, unwrapping, new Class[0]);
        }

        @Override
        protected JsonDeserializer<MobileClientSession> asUnwrapping() {
            return new Deserializer(true);
        }

        @Override
        public MobileClientSession deserializeFields(JsonParser _p, DeserializationContext _ctx) throws IOException, JsonParseException {
            String sessionId = null;
            String deviceName = null;
            MobileClientPlatform clientType = null;
            String ipAddress = null;
            String country = null;
            Date created = null;
            Date updated = null;
            String clientVersion = null;
            String osVersion = null;
            String lastCarrier = null;
            while (_p.getCurrentToken() == JsonToken.FIELD_NAME) {
                String _field = _p.getCurrentName();
                _p.nextToken();
                if ("session_id".equals(_field)) {
                    sessionId = Deserializer.getStringValue(_p);
                    _p.nextToken();
                    continue;
                }
                if ("device_name".equals(_field)) {
                    deviceName = Deserializer.getStringValue(_p);
                    _p.nextToken();
                    continue;
                }
                if ("client_type".equals(_field)) {
                    clientType = _p.readValueAs(MobileClientPlatform.class);
                    _p.nextToken();
                    continue;
                }
                if ("ip_address".equals(_field)) {
                    ipAddress = Deserializer.getStringValue(_p);
                    _p.nextToken();
                    continue;
                }
                if ("country".equals(_field)) {
                    country = Deserializer.getStringValue(_p);
                    _p.nextToken();
                    continue;
                }
                if ("created".equals(_field)) {
                    created = _ctx.parseDate(Deserializer.getStringValue(_p));
                    _p.nextToken();
                    continue;
                }
                if ("updated".equals(_field)) {
                    updated = _ctx.parseDate(Deserializer.getStringValue(_p));
                    _p.nextToken();
                    continue;
                }
                if ("client_version".equals(_field)) {
                    clientVersion = Deserializer.getStringValue(_p);
                    _p.nextToken();
                    continue;
                }
                if ("os_version".equals(_field)) {
                    osVersion = Deserializer.getStringValue(_p);
                    _p.nextToken();
                    continue;
                }
                if ("last_carrier".equals(_field)) {
                    lastCarrier = Deserializer.getStringValue(_p);
                    _p.nextToken();
                    continue;
                }
                Deserializer.skipValue(_p);
            }
            if (sessionId == null) {
                throw new JsonParseException(_p, "Required field \"session_id\" is missing.");
            }
            if (deviceName == null) {
                throw new JsonParseException(_p, "Required field \"device_name\" is missing.");
            }
            if (clientType == null) {
                throw new JsonParseException(_p, "Required field \"client_type\" is missing.");
            }
            return new MobileClientSession(sessionId, deviceName, clientType, ipAddress, country, created, updated, clientVersion, osVersion, lastCarrier);
        }
    }

    static final class Serializer
    extends StructJsonSerializer<MobileClientSession> {
        private static final long serialVersionUID = 0L;

        public Serializer() {
            super(MobileClientSession.class);
        }

        public Serializer(boolean unwrapping) {
            super(MobileClientSession.class, unwrapping);
        }

        @Override
        protected JsonSerializer<MobileClientSession> asUnwrapping() {
            return new Serializer(true);
        }

        @Override
        protected void serializeFields(MobileClientSession value, JsonGenerator g, SerializerProvider provider) throws IOException, JsonProcessingException {
            g.writeObjectField("session_id", value.sessionId);
            g.writeObjectField("device_name", value.deviceName);
            g.writeObjectField("client_type", (Object)value.clientType);
            if (value.ipAddress != null) {
                g.writeObjectField("ip_address", value.ipAddress);
            }
            if (value.country != null) {
                g.writeObjectField("country", value.country);
            }
            if (value.created != null) {
                g.writeObjectField("created", value.created);
            }
            if (value.updated != null) {
                g.writeObjectField("updated", value.updated);
            }
            if (value.clientVersion != null) {
                g.writeObjectField("client_version", value.clientVersion);
            }
            if (value.osVersion != null) {
                g.writeObjectField("os_version", value.osVersion);
            }
            if (value.lastCarrier != null) {
                g.writeObjectField("last_carrier", value.lastCarrier);
            }
        }
    }

    public static class Builder
    extends DeviceSession.Builder {
        protected final String deviceName;
        protected final MobileClientPlatform clientType;
        protected String clientVersion;
        protected String osVersion;
        protected String lastCarrier;

        protected Builder(String sessionId, String deviceName, MobileClientPlatform clientType) {
            super(sessionId);
            if (deviceName == null) {
                throw new IllegalArgumentException("Required value for 'deviceName' is null");
            }
            this.deviceName = deviceName;
            if (clientType == null) {
                throw new IllegalArgumentException("Required value for 'clientType' is null");
            }
            this.clientType = clientType;
            this.clientVersion = null;
            this.osVersion = null;
            this.lastCarrier = null;
        }

        public Builder withClientVersion(String clientVersion) {
            this.clientVersion = clientVersion;
            return this;
        }

        public Builder withOsVersion(String osVersion) {
            this.osVersion = osVersion;
            return this;
        }

        public Builder withLastCarrier(String lastCarrier) {
            this.lastCarrier = lastCarrier;
            return this;
        }

        @Override
        public MobileClientSession build() {
            return new MobileClientSession(this.sessionId, this.deviceName, this.clientType, this.ipAddress, this.country, this.created, this.updated, this.clientVersion, this.osVersion, this.lastCarrier);
        }
    }
}

