/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.users;

import com.dropbox.core.json.JsonUtil;
import com.dropbox.core.json.StructJsonDeserializer;
import com.dropbox.core.json.StructJsonSerializer;
import com.dropbox.core.v2.users.Name;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.IOException;
import java.util.Arrays;

@JsonSerialize(using=Serializer.class)
@JsonDeserialize(using=Deserializer.class)
public class Account {
    static final Serializer SERIALIZER = new Serializer();
    static final Deserializer DESERIALIZER = new Deserializer();
    protected final String accountId;
    protected final Name name;
    protected final String email;
    protected final boolean emailVerified;
    protected final String profilePhotoUrl;

    public Account(String accountId, Name name, String email, boolean emailVerified, String profilePhotoUrl) {
        if (accountId == null) {
            throw new IllegalArgumentException("Required value for 'accountId' is null");
        }
        if (accountId.length() < 40) {
            throw new IllegalArgumentException("String 'accountId' is shorter than 40");
        }
        if (accountId.length() > 40) {
            throw new IllegalArgumentException("String 'accountId' is longer than 40");
        }
        this.accountId = accountId;
        if (name == null) {
            throw new IllegalArgumentException("Required value for 'name' is null");
        }
        this.name = name;
        if (email == null) {
            throw new IllegalArgumentException("Required value for 'email' is null");
        }
        this.email = email;
        this.emailVerified = emailVerified;
        this.profilePhotoUrl = profilePhotoUrl;
    }

    public Account(String accountId, Name name, String email, boolean emailVerified) {
        this(accountId, name, email, emailVerified, null);
    }

    public String getAccountId() {
        return this.accountId;
    }

    public Name getName() {
        return this.name;
    }

    public String getEmail() {
        return this.email;
    }

    public boolean getEmailVerified() {
        return this.emailVerified;
    }

    public String getProfilePhotoUrl() {
        return this.profilePhotoUrl;
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.accountId, this.name, this.email, this.emailVerified, this.profilePhotoUrl});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj.getClass().equals(this.getClass())) {
            Account other = (Account)obj;
            return !(this.accountId != other.accountId && !this.accountId.equals(other.accountId) || this.name != other.name && !this.name.equals(other.name) || this.email != other.email && !this.email.equals(other.email) || this.emailVerified != other.emailVerified || this.profilePhotoUrl != other.profilePhotoUrl && (this.profilePhotoUrl == null || !this.profilePhotoUrl.equals(other.profilePhotoUrl)));
        }
        return false;
    }

    public String toString() {
        return this.serialize(false);
    }

    public String toStringMultiline() {
        return this.serialize(true);
    }

    private String serialize(boolean longForm) {
        try {
            return JsonUtil.getMapper(longForm).writeValueAsString(this);
        }
        catch (JsonProcessingException ex) {
            throw new RuntimeException("Failed to serialize object", ex);
        }
    }

    static final class Deserializer
    extends StructJsonDeserializer<Account> {
        private static final long serialVersionUID = 0L;

        public Deserializer() {
            super(Account.class, new Class[0]);
        }

        public Deserializer(boolean unwrapping) {
            super(Account.class, unwrapping, new Class[0]);
        }

        @Override
        protected JsonDeserializer<Account> asUnwrapping() {
            return new Deserializer(true);
        }

        @Override
        public Account deserializeFields(JsonParser _p, DeserializationContext _ctx) throws IOException, JsonParseException {
            String accountId = null;
            Name name = null;
            String email = null;
            Boolean emailVerified = null;
            String profilePhotoUrl = null;
            while (_p.getCurrentToken() == JsonToken.FIELD_NAME) {
                String _field = _p.getCurrentName();
                _p.nextToken();
                if ("account_id".equals(_field)) {
                    accountId = Deserializer.getStringValue(_p);
                    _p.nextToken();
                    continue;
                }
                if ("name".equals(_field)) {
                    name = _p.readValueAs(Name.class);
                    _p.nextToken();
                    continue;
                }
                if ("email".equals(_field)) {
                    email = Deserializer.getStringValue(_p);
                    _p.nextToken();
                    continue;
                }
                if ("email_verified".equals(_field)) {
                    emailVerified = _p.getValueAsBoolean();
                    _p.nextToken();
                    continue;
                }
                if ("profile_photo_url".equals(_field)) {
                    profilePhotoUrl = Deserializer.getStringValue(_p);
                    _p.nextToken();
                    continue;
                }
                Deserializer.skipValue(_p);
            }
            if (accountId == null) {
                throw new JsonParseException(_p, "Required field \"account_id\" is missing.");
            }
            if (name == null) {
                throw new JsonParseException(_p, "Required field \"name\" is missing.");
            }
            if (email == null) {
                throw new JsonParseException(_p, "Required field \"email\" is missing.");
            }
            if (emailVerified == null) {
                throw new JsonParseException(_p, "Required field \"email_verified\" is missing.");
            }
            return new Account(accountId, name, email, emailVerified, profilePhotoUrl);
        }
    }

    static final class Serializer
    extends StructJsonSerializer<Account> {
        private static final long serialVersionUID = 0L;

        public Serializer() {
            super(Account.class);
        }

        public Serializer(boolean unwrapping) {
            super(Account.class, unwrapping);
        }

        @Override
        protected JsonSerializer<Account> asUnwrapping() {
            return new Serializer(true);
        }

        @Override
        protected void serializeFields(Account value, JsonGenerator g, SerializerProvider provider) throws IOException, JsonProcessingException {
            g.writeObjectField("account_id", value.accountId);
            g.writeObjectField("name", value.name);
            g.writeObjectField("email", value.email);
            g.writeObjectField("email_verified", value.emailVerified);
            if (value.profilePhotoUrl != null) {
                g.writeObjectField("profile_photo_url", value.profilePhotoUrl);
            }
        }
    }
}

