/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.users;

import com.dropbox.core.DbxApiException;
import com.dropbox.core.DbxException;
import com.dropbox.core.DbxRequestUtil;
import com.dropbox.core.json.JsonUtil;
import com.dropbox.core.v2.DbxRawClientV2;
import com.dropbox.core.v2.users.BasicAccount;
import com.dropbox.core.v2.users.FullAccount;
import com.dropbox.core.v2.users.GetAccountArg;
import com.dropbox.core.v2.users.GetAccountBatchArg;
import com.dropbox.core.v2.users.GetAccountBatchError;
import com.dropbox.core.v2.users.GetAccountBatchErrorException;
import com.dropbox.core.v2.users.GetAccountError;
import com.dropbox.core.v2.users.GetAccountErrorException;
import com.dropbox.core.v2.users.SpaceUsage;
import com.fasterxml.jackson.core.type.TypeReference;
import java.util.List;

public final class DbxUserUsersRequests {
    private final DbxRawClientV2 client;

    public DbxUserUsersRequests(DbxRawClientV2 client) {
        this.client = client;
    }

    BasicAccount getAccount(GetAccountArg getAccountArg) throws GetAccountErrorException, DbxException {
        try {
            return (BasicAccount)this.client.rpcStyle(this.client.getHost().getApi(), "2/users/get_account", getAccountArg, false, JsonUtil.createType(BasicAccount.class), JsonUtil.createType(GetAccountError.class));
        }
        catch (DbxRequestUtil.ErrorWrapper ew) {
            throw new GetAccountErrorException(ew.getRequestId(), ew.getUserMessage(), (GetAccountError)((Object)ew.getErrorValue()));
        }
    }

    public BasicAccount getAccount(String accountId) throws GetAccountErrorException, DbxException {
        GetAccountArg arg = new GetAccountArg(accountId);
        return this.getAccount(arg);
    }

    List<BasicAccount> getAccountBatch(GetAccountBatchArg getAccountBatchArg) throws GetAccountBatchErrorException, DbxException {
        try {
            return (List)this.client.rpcStyle(this.client.getHost().getApi(), "2/users/get_account_batch", getAccountBatchArg, false, JsonUtil.createType(new TypeReference<List<BasicAccount>>(){}), JsonUtil.createType(GetAccountBatchError.class));
        }
        catch (DbxRequestUtil.ErrorWrapper ew) {
            throw new GetAccountBatchErrorException(ew.getRequestId(), ew.getUserMessage(), (GetAccountBatchError)ew.getErrorValue());
        }
    }

    public List<BasicAccount> getAccountBatch(List<String> accountIds) throws GetAccountBatchErrorException, DbxException {
        GetAccountBatchArg arg = new GetAccountBatchArg(accountIds);
        return this.getAccountBatch(arg);
    }

    public FullAccount getCurrentAccount() throws DbxException {
        try {
            return (FullAccount)this.client.rpcStyle(this.client.getHost().getApi(), "2/users/get_current_account", null, false, JsonUtil.createType(FullAccount.class), JsonUtil.createType(Void.class));
        }
        catch (DbxRequestUtil.ErrorWrapper ew) {
            throw new DbxApiException(ew.getRequestId(), ew.getUserMessage(), "Unexpected error response for \"get_current_account\": ew.errValue");
        }
    }

    public SpaceUsage getSpaceUsage() throws DbxException {
        try {
            return (SpaceUsage)this.client.rpcStyle(this.client.getHost().getApi(), "2/users/get_space_usage", null, false, JsonUtil.createType(SpaceUsage.class), JsonUtil.createType(Void.class));
        }
        catch (DbxRequestUtil.ErrorWrapper ew) {
            throw new DbxApiException(ew.getRequestId(), ew.getUserMessage(), "Unexpected error response for \"get_space_usage\": ew.errValue");
        }
    }
}

