/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.users;

import com.dropbox.core.json.JsonUtil;
import com.dropbox.core.json.UnionJsonDeserializer;
import com.dropbox.core.json.UnionJsonSerializer;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

@JsonSerialize(using=Serializer.class)
@JsonDeserialize(using=Deserializer.class)
public final class GetAccountBatchError {
    static final Serializer SERIALIZER = new Serializer();
    static final Deserializer DESERIALIZER = new Deserializer();
    public static final GetAccountBatchError OTHER = new GetAccountBatchError(Tag.OTHER, null);
    private final Tag tag;
    private final String noAccountValue;

    private GetAccountBatchError(Tag tag, String noAccountValue) {
        this.tag = tag;
        this.noAccountValue = noAccountValue;
    }

    public Tag tag() {
        return this.tag;
    }

    public boolean isNoAccount() {
        return this.tag == Tag.NO_ACCOUNT;
    }

    public static GetAccountBatchError noAccount(String value) {
        if (value == null) {
            throw new IllegalArgumentException("Value is null");
        }
        if (value.length() < 40) {
            throw new IllegalArgumentException("String is shorter than 40");
        }
        if (value.length() > 40) {
            throw new IllegalArgumentException("String is longer than 40");
        }
        return new GetAccountBatchError(Tag.NO_ACCOUNT, value);
    }

    public String getNoAccountValue() {
        if (this.tag != Tag.NO_ACCOUNT) {
            throw new IllegalStateException("Invalid tag: required Tag.NO_ACCOUNT, but was Tag." + this.tag.name());
        }
        return this.noAccountValue;
    }

    public boolean isOther() {
        return this.tag == Tag.OTHER;
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.tag, this.noAccountValue});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof GetAccountBatchError) {
            GetAccountBatchError other = (GetAccountBatchError)obj;
            if (this.tag != other.tag) {
                return false;
            }
            switch (this.tag) {
                case NO_ACCOUNT: {
                    return this.noAccountValue == other.noAccountValue || this.noAccountValue.equals(other.noAccountValue);
                }
                case OTHER: {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    public String toString() {
        return this.serialize(false);
    }

    public String toStringMultiline() {
        return this.serialize(true);
    }

    private String serialize(boolean longForm) {
        try {
            return JsonUtil.getMapper(longForm).writeValueAsString(this);
        }
        catch (JsonProcessingException ex) {
            throw new RuntimeException("Failed to serialize object", ex);
        }
    }

    static final class Deserializer
    extends UnionJsonDeserializer<GetAccountBatchError, Tag> {
        private static final long serialVersionUID = 0L;

        public Deserializer() {
            super(GetAccountBatchError.class, Deserializer.getTagMapping(), Tag.OTHER, new Class[0]);
        }

        @Override
        public GetAccountBatchError deserialize(Tag _tag, JsonParser _p, DeserializationContext _ctx) throws IOException, JsonParseException {
            switch (_tag) {
                case NO_ACCOUNT: {
                    String value = null;
                    Deserializer.expectField(_p, "no_account");
                    value = Deserializer.getStringValue(_p);
                    _p.nextToken();
                    return GetAccountBatchError.noAccount(value);
                }
                case OTHER: {
                    return OTHER;
                }
            }
            throw new IllegalStateException("Unparsed tag: \"" + (Object)((Object)_tag) + "\"");
        }

        private static Map<String, Tag> getTagMapping() {
            HashMap<String, Tag> values = new HashMap<String, Tag>();
            values.put("no_account", Tag.NO_ACCOUNT);
            values.put("other", Tag.OTHER);
            return Collections.unmodifiableMap(values);
        }
    }

    static final class Serializer
    extends UnionJsonSerializer<GetAccountBatchError> {
        private static final long serialVersionUID = 0L;

        public Serializer() {
            super(GetAccountBatchError.class, new Class[0]);
        }

        @Override
        public void serialize(GetAccountBatchError value, JsonGenerator g, SerializerProvider provider) throws IOException, JsonProcessingException {
            switch (value.tag) {
                case NO_ACCOUNT: {
                    g.writeStartObject();
                    g.writeStringField(".tag", "no_account");
                    g.writeObjectField("no_account", value.noAccountValue);
                    g.writeEndObject();
                    break;
                }
                case OTHER: {
                    g.writeString("other");
                }
            }
        }
    }

    public static enum Tag {
        NO_ACCOUNT,
        OTHER;

    }
}

